/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.runtime.PersistedParser;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.BlendMode;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.IMaterial;
import com.lowdragmc.photon.client.gameobject.emitter.data.material.TextureMaterial;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MaterialSetting
implements IConfigurable,
ITagSerializable<CompoundTag> {
    @Configurable(name="Blend Mode", subConfigurable=true)
    protected final BlendMode blendMode = new BlendMode();
    @Configurable
    protected boolean cull = true;
    @Configurable
    protected boolean depthTest = true;
    @Configurable
    protected boolean depthMask = false;
    @Nonnull
    protected IMaterial material = new TextureMaterial();

    public void pre() {
        this.blendMode.apply();
        if (this.cull) {
            RenderSystem.enableCull();
        } else {
            RenderSystem.disableCull();
        }
        if (this.depthTest) {
            RenderSystem.enableDepthTest();
        } else {
            RenderSystem.disableDepthTest();
        }
        RenderSystem.depthMask((boolean)this.depthMask);
    }

    public void post() {
        if (this.blendMode.getBlendFunc() != BlendMode.BlendFuc.ADD) {
            RenderSystem.blendEquation((int)BlendMode.BlendFuc.ADD.op);
        }
        if (!this.cull) {
            RenderSystem.enableCull();
        }
        if (!this.depthTest) {
            RenderSystem.enableDepthTest();
        }
        if (!this.depthMask) {
            RenderSystem.depthMask((boolean)true);
        }
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        ConfiguratorGroup setting = new ConfiguratorGroup("Setting");
        this.material.buildConfigurator(setting);
        ImageWidget preview = new ImageWidget(0, 0, 50, 50, () -> this.material.preview()).setBorder(2, ColorPattern.T_WHITE.color);
        WrapperConfigurator wrapper = new WrapperConfigurator("preview", (Widget)preview);
        preview.setDraggingConsumer(o -> o instanceof IMaterial, o -> preview.setBorder(2, ColorPattern.GREEN.color), o -> preview.setBorder(2, ColorPattern.T_WHITE.color), o -> {
            if (o instanceof IMaterial) {
                IMaterial mat = (IMaterial)o;
                this.material = mat.copy();
                setting.removeAllConfigurators();
                this.material.buildConfigurator(setting);
                setting.computeLayout();
                preview.setBorder(2, ColorPattern.T_WHITE.color);
            }
        });
        wrapper.setTips(new String[]{"photon.emitter.config.material.preview"});
        father.addConfigurator(0, (Configurator)wrapper);
        father.addConfigurators(new Configurator[]{setting});
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        PersistedParser.serializeNBT((CompoundTag)nbt, this.getClass(), (Object)this);
        nbt.m_128365_("material", (Tag)this.material.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        PersistedParser.deserializeNBT((CompoundTag)nbt, new HashMap(), this.getClass(), (Object)this);
        IMaterial material = IMaterial.deserializeWrapper(nbt.m_128469_("material"));
        this.material = material == null ? new TextureMaterial() : material;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public boolean isCull() {
        return this.cull;
    }

    public boolean isDepthTest() {
        return this.depthTest;
    }

    public boolean isDepthMask() {
        return this.depthMask;
    }

    @Nonnull
    public IMaterial getMaterial() {
        return this.material;
    }

    public void setCull(boolean cull) {
        this.cull = cull;
    }

    public void setDepthTest(boolean depthTest) {
        this.depthTest = depthTest;
    }

    public void setDepthMask(boolean depthMask) {
        this.depthMask = depthMask;
    }

    public void setMaterial(@Nonnull IMaterial material) {
        if (material == null) {
            throw new NullPointerException("material is marked non-null but is null");
        }
        this.material = material;
    }
}

