/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.accessors.TypesAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigAccessor;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorParser;
import com.lowdragmc.lowdraglib.gui.editor.runtime.PersistedParser;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.Constant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.RandomConstant;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.Curve;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.CurveConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.curve.RandomCurve;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EmissionSetting
implements IConfigurable,
ITagSerializable<CompoundTag> {
    @Configurable(tips={"photon.emitter.config.emission.emissionRate"})
    @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, defaultValue=0.5f, curveConfig=@CurveConfig(bound={0.0f, 5.0f}, xAxis="duration", yAxis="emission rate"))
    protected NumberFunction emissionRate = NumberFunction.constant(Float.valueOf(0.5f));
    @Configurable(tips={"photon.emitter.config.emission.emissionMode"})
    protected Mode emissionMode = Mode.Exacting;
    @Configurable(tips={"photon.emitter.config.emission.bursts"}, persisted=false)
    protected List<Burst> bursts = new ArrayList<Burst>();

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        PersistedParser.serializeNBT((CompoundTag)tag, this.getClass(), (Object)this);
        ListTag list = new ListTag();
        for (Burst burst : this.bursts) {
            CompoundTag element = new CompoundTag();
            PersistedParser.serializeNBT((CompoundTag)element, Burst.class, (Object)burst);
            list.add((Object)element);
        }
        tag.m_128365_("bursts", (Tag)list);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        PersistedParser.deserializeNBT((CompoundTag)tag, new HashMap(), this.getClass(), (Object)this);
        this.bursts.clear();
        ListTag list = tag.m_128437_("bursts", 10);
        for (Tag element : list) {
            if (!(element instanceof CompoundTag)) continue;
            CompoundTag nbt = (CompoundTag)element;
            Burst burst = new Burst();
            PersistedParser.deserializeNBT((CompoundTag)nbt, new HashMap(), Burst.class, (Object)burst);
            this.bursts.add(burst);
        }
    }

    public int getEmissionCount(int emitterAge, float t, RandomSource randomSource) {
        Number result = this.emissionRate.get(randomSource, t);
        int number = result.intValue();
        float decimals = result.floatValue() - (float)result.intValue();
        if (this.emissionMode == Mode.Exacting) {
            if (decimals > 0.0f && emitterAge % (int)(1.0f / decimals) == 0) {
                ++number;
            }
        } else if (randomSource.m_188501_() < decimals) {
            ++number;
        }
        for (Burst bust : this.bursts) {
            int realAge = emitterAge - bust.time;
            if (realAge < 0) continue;
            int count = bust.count.get(randomSource, t).intValue();
            if (realAge % bust.interval != 0) continue;
            if (bust.cycles == 0) {
                if (!(randomSource.m_188501_() < bust.probability)) continue;
                number += count;
                continue;
            }
            if (realAge / bust.interval >= bust.cycles || !(randomSource.m_188501_() < bust.probability)) continue;
            number += count;
        }
        return number;
    }

    public void setEmissionRate(NumberFunction emissionRate) {
        this.emissionRate = emissionRate;
    }

    public void setEmissionMode(Mode emissionMode) {
        this.emissionMode = emissionMode;
    }

    public void setBursts(List<Burst> bursts) {
        this.bursts = bursts;
    }

    public NumberFunction getEmissionRate() {
        return this.emissionRate;
    }

    public Mode getEmissionMode() {
        return this.emissionMode;
    }

    public List<Burst> getBursts() {
        return this.bursts;
    }

    public static enum Mode {
        Exacting,
        Random;

    }

    public static class Burst {
        @Configurable(tips={"photon.emitter.config.emission.bursts.time"})
        @NumberRange(range={0.0, 2.147483647E9}, wheel=1.0)
        public int time = 0;
        @Configurable(tips={"photon.emitter.config.emission.bursts.count"})
        @NumberFunctionConfig(types={Constant.class, RandomConstant.class, Curve.class, RandomCurve.class}, min=0.0f, defaultValue=50.0f, curveConfig=@CurveConfig(bound={0.0f, 50.0f}, xAxis="duration", yAxis="emit count"))
        protected NumberFunction count = NumberFunction.constant(50);
        @Configurable(tips={"photon.emitter.config.emission.bursts.cycles"})
        @NumberRange(range={0.0, 2.147483647E9})
        public int cycles = 1;
        @Configurable(tips={"photon.emitter.config.emission.bursts.interval"})
        @NumberRange(range={1.0, 2.147483647E9}, wheel=1.0)
        public int interval = 1;
        @Configurable(tips={"photon.emitter.config.emission.bursts.probability"})
        @NumberRange(range={0.0, 1.0})
        public float probability = 1.0f;

        public void setCount(NumberFunction count) {
            this.count = count;
        }

        public NumberFunction getCount() {
            return this.count;
        }
    }

    @ConfigAccessor
    public static class BurstAccessor
    extends TypesAccessor<Burst> {
        public BurstAccessor() {
            super(new Class[]{Burst.class});
        }

        public Burst defaultValue(Field field, Class<?> type) {
            return new Burst();
        }

        public Configurator create(String name, Supplier<Burst> supplier, Consumer<Burst> consumer, boolean forceUpdate, Field field) {
            ConfiguratorGroup group = new ConfiguratorGroup("burst", true);
            Burst burst = supplier.get();
            burst = burst == null ? new Burst() : burst;
            ConfiguratorParser.createConfigurators((ConfiguratorGroup)group, new HashMap(), Burst.class, (Object)burst);
            return group;
        }
    }
}

