/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.utils.Range;
import com.lowdragmc.photon.client.gameobject.emitter.data.ToggleGroup;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunction;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.NumberFunctionConfig;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.Gradient;
import com.lowdragmc.photon.client.gameobject.emitter.data.number.color.RandomGradient;
import com.lowdragmc.photon.client.gameobject.particle.TileParticle;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class ColorBySpeedSetting
extends ToggleGroup {
    @Configurable(tips={"photon.emitter.config.colorBySpeed.color"})
    @NumberFunctionConfig(types={Gradient.class, RandomGradient.class}, defaultValue=-1.0f)
    protected NumberFunction color = new Gradient();
    @Configurable(tips={"photon.emitter.config.colorBySpeed.speedRange"})
    @NumberRange(range={0.0, 1000.0})
    protected Range speedRange = new Range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f));

    public Vector4f getColor(TileParticle particle) {
        float value = particle.getRealVelocity().length() * 20.0f;
        int c = this.color.get((value - this.speedRange.getA().floatValue()) / (this.speedRange.getB().floatValue() - this.speedRange.getA().floatValue()), () -> Float.valueOf(particle.getMemRandom(this))).intValue();
        return new Vector4f((float)(c >> 16 & 0xFF) / 255.0f, (float)(c >> 8 & 0xFF) / 255.0f, (float)(c & 0xFF) / 255.0f, (float)(c >> 24 & 0xFF) / 255.0f);
    }

    public void setColor(NumberFunction color) {
        this.color = color;
    }

    public void setSpeedRange(Range speedRange) {
        this.speedRange = speedRange;
    }

    public NumberFunction getColor() {
        return this.color;
    }

    public Range getSpeedRange() {
        return this.speedRange;
    }
}

