/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter;

import com.lowdragmc.photon.client.gameobject.emitter.PhotonParticleRenderType;
import com.lowdragmc.photon.client.gameobject.particle.IParticle;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.GameRenderer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ParticleQueueRenderType
extends PhotonParticleRenderType {
    public static final ParticleQueueRenderType INSTANCE = new ParticleQueueRenderType();
    private static final BufferBuilderPool BUILDER_POOL = new BufferBuilderPool();
    protected final Map<PhotonParticleRenderType, Queue<IParticle>> particles = new HashMap<PhotonParticleRenderType, Queue<IParticle>>();
    private Camera camera;
    private float pPartialTicks;
    private boolean isRenderingQueue;

    @Override
    public void begin(BufferBuilder builder) {
        this.particles.clear();
        this.camera = null;
        this.isRenderingQueue = false;
    }

    @Override
    public void end(BufferBuilder builder) {
        this.isRenderingQueue = true;
        for (Map.Entry<PhotonParticleRenderType, Queue<IParticle>> entry : this.particles.entrySet()) {
            PhotonParticleRenderType type = entry.getKey();
            Queue<IParticle> list = entry.getValue();
            if (list.isEmpty()) continue;
            RenderSystem.setShader(GameRenderer::m_172829_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            type.prepareStatus();
            if (type.isParallel()) {
                ForkJoinPool forkJoinPool = ForkJoinPool.commonPool();
                int maxThreads = ForkJoinPool.getCommonPoolParallelism() + 1;
                ForkJoinTask<List<BufferBuilder>> task = forkJoinPool.submit(new ParallelRenderingTask(Math.max(list.size() / maxThreads, 64), type, list.spliterator()));
                try {
                    for (BufferBuilder buffer : task.get()) {
                        type.end(buffer);
                        BUILDER_POOL.release(buffer);
                    }
                }
                catch (Throwable ignored) {
                    ignored.printStackTrace();
                }
            } else {
                type.begin(builder);
                for (IParticle particle : list) {
                    particle.render((VertexConsumer)builder, this.camera, this.pPartialTicks);
                }
                type.end(builder);
            }
            type.releaseStatus();
        }
        this.isRenderingQueue = false;
    }

    public void pipeQueue(@Nonnull PhotonParticleRenderType type, @Nonnull Collection<IParticle> queue, Camera camera, float pPartialTicks) {
        this.particles.computeIfAbsent(type, t -> new ArrayDeque()).addAll(queue);
        if (this.camera == null) {
            this.camera = camera;
            this.pPartialTicks = pPartialTicks;
        }
    }

    public boolean isRenderingQueue() {
        return this.isRenderingQueue;
    }

    class ParallelRenderingTask
    extends RecursiveTask<List<BufferBuilder>> {
        private final int threshold;
        private final PhotonParticleRenderType type;
        private final Spliterator<IParticle> particles;

        public ParallelRenderingTask(int threshold, PhotonParticleRenderType type, Spliterator<IParticle> particles) {
            this.type = type;
            this.particles = particles;
            this.threshold = threshold;
        }

        @Override
        protected List<BufferBuilder> compute() {
            if (this.particles.estimateSize() > (long)this.threshold) {
                Spliterator<IParticle> split = this.particles.trySplit();
                ForkJoinTask task1 = new ParallelRenderingTask(this.threshold, this.type, this.particles).fork();
                ArrayList<BufferBuilder> result = new ArrayList<BufferBuilder>((Collection<BufferBuilder>)(split != null ? new ParallelRenderingTask(this.threshold, this.type, split).compute() : List.of()));
                result.addAll((Collection)task1.join());
                return result;
            }
            BufferBuilder buffer = BUILDER_POOL.acquire();
            this.type.begin(buffer);
            this.particles.forEachRemaining(p -> p.render((VertexConsumer)buffer, ParticleQueueRenderType.this.camera, ParticleQueueRenderType.this.pPartialTicks));
            return List.of(buffer);
        }
    }

    private static class BufferBuilderPool {
        private final ConcurrentLinkedQueue<BufferBuilder> pool = new ConcurrentLinkedQueue();

        private BufferBuilderPool() {
        }

        public BufferBuilder acquire() {
            BufferBuilder buffer = this.pool.poll();
            return buffer != null ? buffer : new BufferBuilder(256);
        }

        public void release(BufferBuilder buffer) {
            this.pool.offer(buffer);
        }
    }
}

