/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject.emitter;

import com.lowdragmc.lowdraglib.utils.DummyWorld;
import com.lowdragmc.photon.client.gameobject.FXObject;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import com.lowdragmc.photon.client.gameobject.emitter.ParticleQueueRenderType;
import com.lowdragmc.photon.client.gameobject.emitter.PhotonParticleRenderType;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public abstract class Emitter
extends FXObject
implements IParticleEmitter {
    protected int delay;
    @Nullable
    protected Vector3f previousPosition;
    protected Vector3f velocity = new Vector3f();
    protected float t;
    private final RandomSource threadSafeRandomSource = RandomSource.m_216337_();
    protected ConcurrentHashMap<Object, Float> memRandom = new ConcurrentHashMap();
    private final ConcurrentHashMap<BlockPos, Integer> lightCache = new ConcurrentHashMap();

    protected Emitter() {
        this.f_172258_ = 1.0f;
    }

    @Override
    public RandomSource getRandomSource() {
        return this.f_107223_;
    }

    @Override
    public final void m_5989_() {
        super.m_5989_();
        if (!this.m_107276_()) {
            return;
        }
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        if (this.previousPosition != null) {
            this.velocity = this.transform.position().sub((Vector3fc)this.previousPosition, new Vector3f());
        }
        this.previousPosition = this.transform.position();
        this.lightCache.clear();
        this.updateOrigin();
        this.update();
    }

    public void m_107264_(double x, double y, double z) {
        if (this.transform == null) {
            return;
        }
        this.transform.position(new Vector3f((float)x, (float)y, (float)z));
    }

    @Override
    public Vector3f getVelocity() {
        return new Vector3f((Vector3fc)this.velocity);
    }

    protected void update() {
        if (this.f_107224_ >= this.m_107273_() && !this.isLooping()) {
            this.remove(false);
        }
        ++this.f_107224_;
        if (this.m_107273_() > 0) {
            this.t = (float)(this.f_107224_ % this.m_107273_()) * 1.0f / (float)this.m_107273_();
        }
    }

    protected void updateOrigin() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107204_ = this.f_107231_;
    }

    @Override
    protected int m_6355_(float partialTick) {
        BlockPos blockPos = new BlockPos((int)this.f_107212_, (int)this.f_107213_, (int)this.f_107214_);
        Level level = this.getLevel();
        if (level != null && (level.m_46805_(blockPos) || level instanceof DummyWorld)) {
            return LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)blockPos);
        }
        return 0;
    }

    @Override
    public float getT(float partialTicks) {
        if (this.f_107225_ > 0) {
            return this.t + partialTicks / (float)this.f_107225_;
        }
        return 0.0f;
    }

    @Override
    public float getMemRandom(Object object) {
        return this.getMemRandom(object, RandomSource::m_188501_);
    }

    @Override
    public float getMemRandom(Object object, Function<RandomSource, Float> randomFunc) {
        Float value = this.memRandom.get(object);
        if (value == null) {
            return this.memRandom.computeIfAbsent(object, o -> (Float)randomFunc.apply(this.f_107223_)).floatValue();
        }
        return value.floatValue();
    }

    @Override
    public void reset() {
        this.f_107224_ = 0;
        this.memRandom.clear();
        this.f_107220_ = false;
        this.f_107218_ = false;
        this.previousPosition = null;
        this.velocity.zero();
        this.t = 0.0f;
    }

    @Nonnull
    public final PhotonParticleRenderType getRenderType() {
        return ParticleQueueRenderType.INSTANCE;
    }

    @Override
    public boolean m_107276_() {
        if (!this.f_107220_ || this.getParticleAmount() != 0) {
            return true;
        }
        return super.m_107276_();
    }

    @Override
    public int getLightColor(BlockPos pos) {
        return this.lightCache.computeIfAbsent(pos, p -> {
            Level level = this.getLevel();
            if (level != null && (level.m_46805_(p) || level instanceof DummyWorld)) {
                return LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)p);
            }
            return 0;
        });
    }

    @Override
    public int getAge() {
        return this.f_107224_;
    }

    @Override
    public void setAge(int age) {
        this.f_107224_ = age;
    }

    @Override
    public boolean isLooping() {
        return false;
    }

    @Override
    public void setRGBAColor(Vector4f color) {
        this.f_107227_ = color.x;
        this.f_107228_ = color.y;
        this.f_107229_ = color.z;
        this.f_107230_ = color.w;
    }

    @Override
    public Vector4f getRGBAColor() {
        return new Vector4f(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_);
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    @Override
    public float getT() {
        return this.t;
    }

    public RandomSource getThreadSafeRandomSource() {
        return this.threadSafeRandomSource;
    }

    public ConcurrentHashMap<Object, Float> getMemRandom() {
        return this.memRandom;
    }
}

