/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject;

import com.lowdragmc.lowdraglib.client.scene.ParticleManager;
import com.lowdragmc.lowdraglib.gui.editor.ILDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneObject;
import com.lowdragmc.lowdraglib.syncdata.IAutoPersistedSerializable;
import com.lowdragmc.lowdraglib.utils.DummyWorld;
import com.lowdragmc.photon.client.fx.IEffect;
import com.lowdragmc.photon.integration.PhotonLDLibPlugin;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface IFXObject
extends ISceneObject,
IAutoPersistedSerializable,
IConfigurable,
ILDLRegisterClient {
    @Nullable
    public static IFXObject deserializeWrapper(CompoundTag tag) {
        AnnotationDetector.Wrapper<LDLRegisterClient, ? extends IFXObject> wrapper = PhotonLDLibPlugin.REGISTER_FX_OBJECTS.get(tag.m_128461_("_type"));
        if (wrapper != null) {
            IFXObject fxObject = (IFXObject)wrapper.creator().get();
            fxObject.deserializeNBT(tag);
            return fxObject;
        }
        return null;
    }

    public String getName();

    public void setName(String var1);

    public Level getLevel();

    public void setLevel(Level var1);

    public boolean m_107276_();

    public boolean isVisible();

    public void setVisible(boolean var1);

    public void setEffect(IEffect var1);

    public IEffect getEffect();

    public void remove(boolean var1);

    default public void reset() {
    }

    default public CompoundTag serializeNBT() {
        return super.serializeNBT();
    }

    default public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
    }

    default public IFXObject deepCopy() {
        return IFXObject.deserializeWrapper(this.serializeNBT());
    }

    default public IFXObject shallowCopy() {
        return this.deepCopy();
    }

    default public IFXObject copy(boolean deep) {
        return deep ? this.deepCopy() : this.shallowCopy();
    }

    default public void emmit(IEffect effect) {
        this.emmit(effect, null, null, null);
    }

    default public void emmit(IEffect effect, @Nullable Vector3f position, @Nullable Quaternionf rotation, @Nullable Vector3f scale) {
        this.setEffect(effect);
        if (position != null) {
            this.updatePos(position);
        }
        if (rotation != null) {
            this.updateRotation(rotation);
        }
        if (scale != null) {
            this.updateScale(scale);
        }
        this.setLevel(effect.getLevel());
        IFXObject iFXObject = this;
        if (iFXObject instanceof Particle) {
            Particle particle = (Particle)iFXObject;
            Level level = effect.getLevel();
            if (level instanceof DummyWorld) {
                DummyWorld dummyWorld = (DummyWorld)level;
                ParticleManager particleManager = dummyWorld.getParticleManager();
                if (particleManager != null) {
                    particleManager.addParticle(particle);
                }
            } else {
                Minecraft.m_91087_().f_91061_.m_107344_(particle);
            }
        }
    }

    default public void updatePos(Vector3f newPos) {
        this.transform().position(newPos);
    }

    default public void updateRotation(Quaternionf newRot) {
        this.transform().rotation(newRot);
    }

    default public void updateRotation(Vector3f newRot) {
        this.transform().rotation(new Quaternionf().rotationXYZ(newRot.x, newRot.y, newRot.z));
    }

    default public void updateScale(Vector3f newScale) {
        this.transform().scale(newScale);
    }

    default public void copyTransformFrom(IFXObject fxObject) {
        this.transform().copyTransformFrom(fxObject.transform(), true, true);
        this.transform()._setInternalID(fxObject.transform().id());
    }
}

