/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.gameobject;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.data.Transform;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.IScene;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.ISceneObject;
import com.lowdragmc.photon.client.fx.IEffect;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class FXObject
extends Particle
implements IFXObject {
    @Configurable(name="photon.fx_object.name")
    public String name = this.name();
    @Nullable
    private IScene scene;
    @Configurable(subConfigurable=true, collapse=false)
    public final Transform transform = new Transform((ISceneObject)this);
    @Nullable
    private Level realLevel;
    protected boolean visible = true;
    @Nullable
    protected IEffect effect;
    public static ParticleRenderType NO_RENDER_RENDER_TYPE = new ParticleRenderType(){

        public void m_6505_(BufferBuilder builder, TextureManager textureManager) {
        }

        public void m_6294_(Tesselator tesselator) {
        }
    };

    protected FXObject() {
        super(null, 0.0, 0.0, 0.0);
        this.f_107219_ = false;
        this.f_172258_ = 1.0f;
    }

    @Override
    public IFXObject deepCopy() {
        CompoundTag data = this.serializeNBT();
        if (data.m_128441_("transform")) {
            data.m_128469_("transform").m_128473_("id");
        }
        return IFXObject.deserializeWrapper(data);
    }

    @Override
    public final IFXObject copy(boolean deep) {
        IFXObject copied = IFXObject.super.copy(deep);
        if (!deep) {
            copied.setName(this.name);
            copied.copyTransformFrom(this);
        }
        return copied;
    }

    public final void setSceneInternal(IScene scene) {
        this.scene = scene;
    }

    @Override
    public boolean m_107276_() {
        for (Transform child : this.transform.children()) {
            FXObject fxObject;
            ISceneObject iSceneObject = child.sceneObject();
            if (!(iSceneObject instanceof FXObject) || !(fxObject = (FXObject)iSceneObject).m_107276_()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        ISceneObject iSceneObject;
        if (!this.visible) {
            return false;
        }
        if (this.transform.parent() != null && (iSceneObject = this.transform.parent().sceneObject()) instanceof IFXObject) {
            IFXObject ifxObject = (IFXObject)iSceneObject;
            return ifxObject.isVisible();
        }
        return true;
    }

    @Override
    @Nullable
    public Level getLevel() {
        return this.realLevel == null ? this.f_107208_ : this.realLevel;
    }

    @Override
    public void setLevel(@Nullable Level level) {
        this.realLevel = level;
    }

    public void m_6257_(double x, double y, double z) {
    }

    protected int m_6355_(float partialTick) {
        if (this.realLevel == null) {
            return 0;
        }
        Vector3f pos = this.transform.position();
        BlockPos blockPos = BlockPos.m_274561_((double)pos.x, (double)pos.y, (double)pos.z);
        return this.realLevel.m_46805_(blockPos) ? LevelRenderer.m_109541_((BlockAndTintGetter)this.realLevel, (BlockPos)blockPos) : 0;
    }

    @Override
    public void remove(boolean force) {
        this.m_107274_();
    }

    public void m_5989_() {
        this.updateTick();
    }

    public void updateTick() {
        if (this.effect != null) {
            this.effect.updateFXObjectTick(this);
        }
    }

    public void m_5744_(@Nonnull VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        this.updateFrame(pPartialTicks);
    }

    public void updateFrame(float partialTicks) {
        if (this.effect != null) {
            this.effect.updateFXObjectFrame(this, partialTicks);
        }
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return NO_RENDER_RENDER_TYPE;
    }

    public boolean shouldCull() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Nullable
    public IScene getScene() {
        return this.scene;
    }

    public Transform transform() {
        return this.transform;
    }

    @Nullable
    public Level getRealLevel() {
        return this.realLevel;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    @Nullable
    public IEffect getEffect() {
        return this.effect;
    }

    @Override
    public void setEffect(@Nullable IEffect effect) {
        this.effect = effect;
    }
}

