/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.fx;

import com.lowdragmc.photon.client.fx.FX;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class FXHelper {
    private static final Map<ResourceLocation, FX> CACHE = new HashMap<ResourceLocation, FX>();
    public static final String FX_PATH = "fx/";

    public static int clearCache() {
        int count = CACHE.size();
        CACHE.clear();
        return count;
    }

    @Nullable
    public static FX getFX(ResourceLocation fxLocation) {
        return CACHE.computeIfAbsent(fxLocation, location -> {
            FX fX;
            block9: {
                ResourceLocation resourceLocation = new ResourceLocation(fxLocation.m_135827_(), FX_PATH + fxLocation.m_135815_() + ".fx");
                InputStream inputStream = Minecraft.m_91087_().m_91098_().m_215595_(resourceLocation);
                try {
                    CompoundTag tag = NbtIo.m_128939_((InputStream)inputStream);
                    int version = tag.m_128441_("_version") ? tag.m_128451_("_version") : 0;
                    FX fx = new FX();
                    fx.setFxLocation(fxLocation);
                    fx.deserializeNBT(tag.m_128469_("fx"));
                    if (version < 1) {
                        CompoundTag emitters = new CompoundTag();
                        emitters.m_128365_("fxObjects", (Tag)tag.m_128437_("emitters", 10));
                        fx.getMainFX().deserializeNBT(emitters);
                    }
                    fX = fx;
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ignored) {
                        return null;
                    }
                }
                inputStream.close();
            }
            return fX;
        });
    }
}

