/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client.fx;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXEffect;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class BlockEffect
extends FXEffect {
    public static Map<BlockPos, List<BlockEffect>> CACHE = new HashMap<BlockPos, List<BlockEffect>>();
    public final BlockPos pos;
    private boolean checkState;
    private BlockState lastState;

    public BlockEffect(FX fx, Level level, BlockPos pos) {
        super(fx, level);
        this.pos = pos;
    }

    @Override
    public void updateFXObjectTick(IFXObject fxObject) {
        if (this.runtime != null && fxObject == this.runtime.root && (!this.level.m_46749_(this.pos) || this.lastState.m_60734_() != this.level.m_8055_(this.pos).m_60734_() || this.checkState && this.level.m_8055_(this.pos) != this.lastState)) {
            this.runtime.destroy(this.forcedDeath);
            CACHE.computeIfAbsent(this.pos, p -> new ArrayList()).remove(this);
        }
    }

    @Override
    public void start() {
        List effects = CACHE.computeIfAbsent(this.pos, p -> new ArrayList());
        if (!this.allowMulti) {
            Iterator iter = effects.iterator();
            while (iter.hasNext()) {
                BlockEffect effect = (BlockEffect)iter.next();
                boolean removed = false;
                if (effect.runtime != null && !effect.runtime.isAlive()) {
                    iter.remove();
                    removed = true;
                }
                if (!effect.fx.equals(this.fx) && !Objects.equals(effect.fx.getFxLocation(), this.fx.getFxLocation()) || removed) continue;
                return;
            }
        }
        this.runtime = this.fx.createRuntime();
        IFXObject root = this.runtime.getRoot();
        root.updatePos(new Vector3f((float)this.pos.m_123341_(), (float)this.pos.m_123342_(), (float)this.pos.m_123343_()).add(this.offset.x + 0.5f, this.offset.y + 0.5f, this.offset.z + 0.5f));
        root.updateRotation(this.rotation);
        root.updateScale(this.scale);
        this.runtime.emmit(this);
        this.lastState = this.level.m_8055_(this.pos);
        effects.add(this);
    }

    public void setCheckState(boolean checkState) {
        this.checkState = checkState;
    }
}

