/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.photon.client;

import com.lowdragmc.lowdraglib.client.scene.ParticleManager;
import com.lowdragmc.photon.client.gameobject.emitter.PhotonParticleRenderType;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import net.minecraft.client.Camera;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PhotonParticleManager
extends ParticleManager {
    private final long[] lastCPUTimes = new long[60];
    private int tickIndex = 0;
    private final long[] lastFrameTimes = new long[60];
    private int frameIndex = 0;

    public void render(PoseStack pMatrixStack, Camera pActiveRenderInfo, float pPartialTicks) {
        long startTime = System.nanoTime();
        super.render(pMatrixStack, pActiveRenderInfo, pPartialTicks);
        PhotonParticleRenderType.finishRender();
        this.lastFrameTimes[this.frameIndex] = System.nanoTime() - startTime;
    }

    public void tick() {
        long startTime = System.nanoTime();
        super.tick();
        this.lastCPUTimes[this.tickIndex] = System.nanoTime() - startTime;
        this.tickIndex = (this.tickIndex + 1) % this.lastCPUTimes.length;
    }

    public long getCPUTime() {
        return (long)Arrays.stream(this.lastCPUTimes).average().orElse(0.0) / 1000L;
    }

    public long getFrameTime() {
        return (long)Arrays.stream(this.lastFrameTimes).average().orElse(0.0) / 1000L;
    }
}

