/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.util;

import com.ibm.asyncutil.locks.AsyncLock;
import com.ibm.asyncutil.locks.AsyncNamedLock;
import com.ishland.c2me.base.common.GlobalExecutors;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.world.level.ChunkPos;

public class AsyncCombinedLock {
    private final AsyncNamedLock<ChunkPos> lock;
    private final ChunkPos[] names;
    private final CompletableFuture<AsyncLock.LockToken> future = new CompletableFuture();

    public AsyncCombinedLock(AsyncNamedLock<ChunkPos> lock, Set<ChunkPos> names) {
        this.lock = lock;
        this.names = (ChunkPos[])names.toArray(ChunkPos[]::new);
        this.tryAcquire();
    }

    private synchronized void tryAcquire() {
        LockEntry[] tryLocks = new LockEntry[this.names.length];
        boolean allAcquired = true;
        for (ChunkPos name : this.names) {
            LockEntry entry;
            tryLocks[i] = entry = new LockEntry(name, this.lock.tryLock((Object)name));
            if (!entry.lockToken.isEmpty()) continue;
            allAcquired = false;
            break;
        }
        if (allAcquired) {
            this.future.complete(() -> {
                for (LockEntry entry : tryLocks) {
                    entry.lockToken.get().releaseLock();
                }
            });
        } else {
            boolean triedRelock = false;
            for (LockEntry entry : tryLocks) {
                if (entry == null) continue;
                entry.lockToken.ifPresent(AsyncLock.LockToken::releaseLock);
                if (triedRelock || !entry.lockToken.isEmpty()) continue;
                this.lock.acquireLock((Object)entry.name).thenCompose(lockToken -> {
                    lockToken.releaseLock();
                    return CompletableFuture.runAsync(this::tryAcquire, GlobalExecutors.executor);
                });
                triedRelock = true;
            }
            if (!triedRelock) {
                System.err.println("Some issue occurred while doing locking, retrying");
                this.tryAcquire();
            }
        }
    }

    public CompletableFuture<AsyncLock.LockToken> getFuture() {
        return this.future.thenApply(Function.identity());
    }

    private record LockEntry(ChunkPos name, Optional<AsyncLock.LockToken> lockToken) {
    }
}

