/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.scheduler;

import com.ishland.c2me.base.common.scheduler.NeighborLockingManager;
import com.ishland.c2me.base.common.scheduler.ScheduledTask;
import com.ishland.c2me.base.common.structs.DynamicPriorityQueue;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.world.level.ChunkPos;

public class SchedulingManager {
    public static final int MAX_LEVEL = ChunkLevel.f_286967_ + 1;
    private final DynamicPriorityQueue<ScheduledTask> queue = new DynamicPriorityQueue(MAX_LEVEL + 1);
    private final Long2ReferenceOpenHashMap<ObjectArraySet<ScheduledTask>> pos2Tasks = new Long2ReferenceOpenHashMap();
    private final Long2IntOpenHashMap prioritiesFromLevel = new Long2IntOpenHashMap();
    private final NeighborLockingManager neighborLockingManager = new NeighborLockingManager();
    private final AtomicInteger scheduledCount = new AtomicInteger(0);
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    private ChunkPos currentSyncLoad = null;
    private final Executor executor;
    private final int maxScheduled;

    public SchedulingManager(Executor executor, int maxScheduled) {
        this.prioritiesFromLevel.defaultReturnValue(MAX_LEVEL);
        this.executor = executor;
        this.maxScheduled = maxScheduled;
    }

    public void enqueue(ScheduledTask task) {
        this.executor.execute(() -> {
            if (task.isAsync()) {
                this.schedule0(task);
            } else {
                this.queue.enqueue(task, this.prioritiesFromLevel.get(task.centerPos()));
                ((ObjectArraySet)this.pos2Tasks.computeIfAbsent(task.centerPos(), unused -> new ObjectArraySet())).add((Object)task);
                this.scheduleExecution();
            }
        });
    }

    public void updatePriorityFromLevel(long pos, int level) {
        this.executor.execute(() -> {
            if (this.prioritiesFromLevel.get(pos) == level) {
                return;
            }
            if (level < MAX_LEVEL) {
                this.prioritiesFromLevel.put(pos, level);
            } else {
                this.prioritiesFromLevel.remove(pos);
            }
            this.updatePriorityInternal(pos);
        });
    }

    private void updatePriorityInternal(long pos) {
        int chebyshevDistance;
        int fromLevel = this.prioritiesFromLevel.get(pos);
        int fromSyncLoad = this.currentSyncLoad != null ? ((chebyshevDistance = SchedulingManager.chebyshev(new ChunkPos(pos), this.currentSyncLoad)) <= 8 ? chebyshevDistance : MAX_LEVEL) : MAX_LEVEL;
        int priority = Math.min(fromLevel, fromSyncLoad);
        ObjectArraySet locks = (ObjectArraySet)this.pos2Tasks.get(pos);
        if (locks != null) {
            for (ScheduledTask lock : locks) {
                this.queue.changePriority(lock, priority);
            }
        }
    }

    public void setCurrentSyncLoad(ChunkPos pos) {
        this.executor.execute(() -> {
            if (this.currentSyncLoad != null) {
                ChunkPos lastSyncLoad = this.currentSyncLoad;
                this.currentSyncLoad = null;
                this.updateSyncLoadInternal(lastSyncLoad);
            }
            if (pos != null) {
                this.currentSyncLoad = pos;
                this.updateSyncLoadInternal(pos);
            }
        });
    }

    public NeighborLockingManager getNeighborLockingManager() {
        return this.neighborLockingManager;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    private void updateSyncLoadInternal(ChunkPos pos) {
        long startTime = System.nanoTime();
        for (int xOff = -8; xOff <= 8; ++xOff) {
            for (int zOff = -8; zOff <= 8; ++zOff) {
                this.updatePriorityInternal(ChunkPos.m_45589_((int)(pos.f_45578_ + xOff), (int)(pos.f_45579_ + zOff)));
            }
        }
        long endTime = System.nanoTime();
    }

    private void scheduleExecution() {
        if (this.scheduledCount.get() < this.maxScheduled && this.scheduled.compareAndSet(false, true)) {
            this.executor.execute(() -> {
                while (this.scheduledCount.get() < this.maxScheduled) {
                    ScheduleStatus status = this.scheduleExecutionInternal();
                    if (!status.success) break;
                    if (status.async) continue;
                    this.scheduledCount.incrementAndGet();
                }
                this.scheduled.set(false);
            });
        }
    }

    private ScheduleStatus scheduleExecutionInternal() {
        ScheduledTask task = this.queue.dequeue();
        if (task != null) {
            ((ObjectArraySet)this.pos2Tasks.get(task.centerPos())).remove((Object)task);
            this.runPos2TasksMaintenance(task.centerPos());
            boolean scheduled1 = this.schedule0(task);
            if (scheduled1) {
                return ScheduleStatus.SCHEDULED;
            }
        }
        return ScheduleStatus.NOT_SCHEDULED;
    }

    private boolean schedule0(ScheduledTask task) {
        if (task.tryPrepare()) {
            task.runTask(() -> {
                this.scheduledCount.decrementAndGet();
                this.scheduleExecution();
            });
            return true;
        }
        return false;
    }

    private static int chebyshev(ChunkPos a, ChunkPos b) {
        return Math.max(Math.abs(a.f_45578_ - b.f_45578_), Math.abs(a.f_45579_ - b.f_45579_));
    }

    private static int chebyshev(long a, long b) {
        return Math.max(Math.abs(ChunkPos.m_45592_((long)a) - ChunkPos.m_45592_((long)b)), Math.abs(ChunkPos.m_45602_((long)a) - ChunkPos.m_45602_((long)b)));
    }

    private void runPos2TasksMaintenance(long pos) {
        ObjectArraySet locks = (ObjectArraySet)this.pos2Tasks.get(pos);
        if (locks != null && locks.isEmpty()) {
            this.pos2Tasks.remove(pos);
        }
    }

    private static enum ScheduleStatus {
        SCHEDULED(true, false),
        SCHEDULED_ASYNC(true, true),
        NOT_SCHEDULED(false, false);

        public final boolean success;
        public final boolean async;

        private ScheduleStatus(boolean success, boolean async) {
            this.success = success;
            this.async = async;
        }
    }
}

