/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.base.common.scheduler;

import com.google.common.base.Preconditions;
import com.ibm.asyncutil.locks.AsyncLock;
import com.ibm.asyncutil.locks.AsyncNamedLock;
import com.ishland.c2me.base.common.GlobalExecutors;
import com.ishland.c2me.base.common.scheduler.ScheduledTask;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.level.ChunkPos;

public class SchedulingAsyncCombinedLock<T>
implements ScheduledTask {
    private final AsyncNamedLock<ChunkPos> lock;
    private final long center;
    private final ChunkPos[] names;
    private final BooleanSupplier isCancelled;
    private final Consumer<SchedulingAsyncCombinedLock<T>> readdForExecution;
    private final Supplier<CompletableFuture<T>> action;
    private final String desc;
    private final CompletableFuture<T> future = new CompletableFuture();
    private final boolean async;
    private AsyncLock.LockToken acquiredToken;

    public SchedulingAsyncCombinedLock(AsyncNamedLock<ChunkPos> lock, long center, Set<ChunkPos> names, BooleanSupplier isCancelled, Consumer<SchedulingAsyncCombinedLock<T>> readdForExecution, Supplier<CompletableFuture<T>> action, String desc, boolean async) {
        this.lock = lock;
        this.center = center;
        this.names = (ChunkPos[])names.toArray(ChunkPos[]::new);
        this.isCancelled = isCancelled;
        this.readdForExecution = readdForExecution;
        this.action = action;
        this.desc = desc;
        this.async = async;
        this.readdForExecution.accept(this);
    }

    @Override
    public boolean tryPrepare() {
        return this.tryAcquire();
    }

    synchronized boolean tryAcquire() {
        LockEntry[] tryLocks = new LockEntry[this.names.length];
        boolean allAcquired = true;
        for (ChunkPos name : this.names) {
            LockEntry entry;
            tryLocks[i] = entry = new LockEntry(name, this.lock.tryLock((Object)name));
            if (!entry.lockToken.isEmpty()) continue;
            allAcquired = false;
            break;
        }
        if (allAcquired) {
            this.acquiredToken = () -> {
                for (LockEntry entry : tryLocks) {
                    entry.lockToken.get().releaseLock();
                }
            };
            return true;
        }
        boolean triedRelock = false;
        for (LockEntry entry : tryLocks) {
            if (entry == null) continue;
            entry.lockToken.ifPresent(AsyncLock.LockToken::releaseLock);
            if (triedRelock || !entry.lockToken.isEmpty()) continue;
            this.lock.acquireLock((Object)entry.name).thenAccept(lockToken -> {
                lockToken.releaseLock();
                this.readdForExecution.accept(this);
            });
            triedRelock = true;
        }
        if (!triedRelock) {
            System.err.println("Some issue occurred while doing locking, retrying");
            return this.tryAcquire();
        }
        return false;
    }

    @Override
    public void runTask(Runnable postAction) {
        Preconditions.checkNotNull((Object)postAction);
        AsyncLock.LockToken token = this.acquiredToken;
        if (token == null) {
            throw new IllegalStateException();
        }
        CompletableFuture<T> future = this.action.get();
        Preconditions.checkNotNull(future, (Object)"future");
        future.handleAsync((result, throwable) -> {
            try {
                token.releaseLock();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                postAction.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (throwable != null) {
                this.future.completeExceptionally((Throwable)throwable);
            } else {
                this.future.complete(result);
            }
            return null;
        }, GlobalExecutors.invokingExecutor);
    }

    @Override
    public long centerPos() {
        return this.center;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    public CompletableFuture<T> getFuture() {
        return this.future.thenApply(Function.identity());
    }

    private record LockEntry(ChunkPos name, Optional<AsyncLock.LockToken> lockToken) {
    }
}

