/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.client.render;

import com.buuz135.industrial.api.transporter.TransporterType;
import com.buuz135.industrial.api.transporter.TransporterTypeFactory;
import com.buuz135.industrial.block.transportstorage.tile.TransporterTile;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TransporterTESR
implements BlockEntityRenderer<TransporterTile> {
    public static ResourceLocation TEXTURE = new ResourceLocation("industrialforegoing", "textures/block/transporters/particle.png");
    public static RenderType TYPE = TransporterTESR.createRenderType();

    public TransporterTESR(BlockEntityRendererProvider.Context context) {
    }

    public static RenderType createRenderType() {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172814_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TEXTURE, false, false)).m_110685_(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        })).m_110691_(true);
        return RenderType.m_173215_((String)"transporter_render", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)state);
    }

    public static Vector3f getPath(Direction from, Direction to, double step, float partialTicks) {
        float totalSteps = 5.0f;
        if (from.m_122424_() == to) {
            totalSteps = 7.0f;
            Vec3 vector3d = new Vec3((double)(to.m_253071_().x() / totalSteps) * step, (double)(to.m_253071_().y() / totalSteps) * step, (double)(to.m_253071_().z() / totalSteps) * step);
            if (from.m_122434_() == Direction.Axis.X) {
                vector3d = vector3d.m_82520_(0.0, 0.5, 0.5);
                if (from.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    vector3d = vector3d.m_82520_(1.0, 0.0, 0.0);
                }
            }
            if (from.m_122434_() == Direction.Axis.Z) {
                vector3d = vector3d.m_82520_(0.5, 0.5, 0.0);
                if (from.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    vector3d = vector3d.m_82520_(0.0, 0.0, 1.0);
                }
            }
            if (from.m_122434_() == Direction.Axis.Y) {
                vector3d = vector3d.m_82520_(0.5, 0.0, 0.5);
                if (from.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    vector3d = vector3d.m_82520_(0.0, 1.0, 0.0);
                }
            }
            float divideSecond = -0.22f;
            vector3d = vector3d.m_82520_((double)(from.m_253071_().x() * divideSecond), (double)(from.m_253071_().y() * divideSecond), (double)(from.m_253071_().z() * divideSecond));
            return new Vector3f((float)vector3d.f_82479_, (float)vector3d.f_82480_, (float)vector3d.f_82481_);
        }
        Vector3f vsrc = from.m_253071_();
        Vector3f vdst = to.m_253071_();
        Vector3f a = new Vector3f((Vector3fc)vsrc);
        a.mul(0.3125f);
        Vector3f b = new Vector3f((Vector3fc)vdst);
        b.mul(0.375f);
        Vector3f c = new Vector3f((Vector3fc)vsrc);
        c.mul(0.1875f);
        float sind = -Mth.m_14031_((float)((float)(step / (double)totalSteps * Math.PI / 2.0)));
        float cosd = -Mth.m_14089_((float)((float)(step / (double)totalSteps * Math.PI / 2.0)));
        a.mul(sind);
        b.mul(cosd);
        a.add((Vector3fc)b);
        a.add((Vector3fc)c);
        float divide = 2.5f;
        a.add(vdst.x() / divide, vdst.y() / divide, vdst.z() / divide);
        a.add(0.5f, 0.5f, 0.5f);
        float divideSecond = 0.15f;
        a.add(vsrc.x() * divideSecond, vsrc.y() * divideSecond, vsrc.z() * divideSecond);
        return a;
    }

    public void render(TransporterTile tile, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Map<Direction, TransporterType> transporters = tile.getTransporterTypeMap();
        for (Direction direction : transporters.keySet()) {
            if (transporters.get(direction).getAction() != TransporterTypeFactory.TransporterAction.EXTRACT) continue;
            for (Direction other : transporters.keySet()) {
                if (direction == other || !transporters.get(direction).getFactory().getName().equals(transporters.get(other).getFactory().getName()) || transporters.get(other).getAction() == TransporterTypeFactory.TransporterAction.EXTRACT) continue;
                for (int i = -1; i < 6; ++i) {
                    stack.m_85836_();
                    Vector3f pos = TransporterTESR.getPath(direction, other, (float)i + partialTicks, partialTicks);
                    stack.m_252880_(pos.x(), pos.y(), pos.z());
                    transporters.get(other).renderTransfer(pos, direction, i + 1, stack, combinedOverlayIn, buffer, partialTicks, tile.m_58904_());
                    stack.m_85849_();
                }
            }
        }
    }
}

