/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Snowball;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import tech.thatgravyboat.winteroverhaul.common.entity.ISnowGolemSnowball;

@Mixin(value={Snowball.class})
public class MixinSnowball
implements ISnowGolemSnowball {
    @Unique
    private boolean golemSnowball = false;
    @Unique
    private int golemMultiplier = 1;
    @Unique
    private final List<MobEffectInstance> hitEffects = new ArrayList<MobEffectInstance>();

    @WrapOperation(method={"m_5790_(Lnet/minecraft/world/phys/EntityHitResult;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;m_6469_(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private boolean onHurt(Entity entity, DamageSource source, float amount, Operation<Boolean> original) {
        if (this.winteroverhaul_isGolemSnowball()) {
            amount = amount == 0.0f ? 1.0f : amount;
            amount *= (float)this.winteroverhaul_getGolemMultiplier();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.hitEffects.forEach(arg_0 -> ((LivingEntity)livingEntity).m_7292_(arg_0));
        }
        return (Boolean)original.call(new Object[]{entity, source, Float.valueOf(amount)});
    }

    @Override
    public void winteroverhaul_setGolemMultiplier(int multiplier) {
        this.golemMultiplier = multiplier;
    }

    @Override
    @Unique
    public int winteroverhaul_getGolemMultiplier() {
        return this.golemMultiplier;
    }

    @Override
    public void winteroverhaul_setGolemSnowball(boolean statement) {
        this.golemSnowball = statement;
    }

    @Override
    public boolean winteroverhaul_isGolemSnowball() {
        return this.golemSnowball;
    }

    @Override
    public void winteroverhaul_addMobEffect(MobEffectInstance effect) {
        this.hitEffects.add(effect);
    }
}

