/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.winteroverhaul.forge;

import dev.architectury.platform.forge.EventBuses;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import tech.thatgravyboat.winteroverhaul.WinterOverhaul;
import tech.thatgravyboat.winteroverhaul.client.ModClient;
import tech.thatgravyboat.winteroverhaul.common.registry.ModItems;
import tech.thatgravyboat.winteroverhaul.common.util.BiomeSpawns;
import tech.thatgravyboat.winteroverhaul.common.util.EntityAttributesBuilder;
import tech.thatgravyboat.winteroverhaul.datagen.WinterOverhaulBlockTagDatagen;
import tech.thatgravyboat.winteroverhaul.datagen.WinterOverhaulLootTableDatagen;
import tech.thatgravyboat.winteroverhaul.datagen.WinterOverhaulRecipeDatagen;

@Mod(value="winteroverhaul")
public class WinterOverhaulForge {
    public static final WinterOverhaul MOD = new WinterOverhaul();
    private static final DeferredRegister<CreativeModeTab> TAB_REGISTER = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"winteroverhaul");
    public static final RegistryObject<CreativeModeTab> TAB = TAB_REGISTER.register("tab", () -> CreativeModeTab.builder().m_257501_((params, output) -> ModItems.registerToCreativeTab(output)).m_257941_((Component)Component.m_237113_((String)"Winter Overhaul")).m_257737_(() -> new ItemStack((ItemLike)ModItems.TOP_HAT.get())).m_257652_());
    private static final BiomeSpawns biomeSpawns = new BiomeSpawns();

    public WinterOverhaulForge(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus modBus = context.getModEventBus();
        modBus.register(WinterOverhaulForge.class);
        EventBuses.registerModEventBus((String)"winteroverhaul", (IEventBus)modBus);
        MOD.register();
        TAB_REGISTER.register(modBus);
    }

    @SubscribeEvent
    public void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        InteractionResult result = MOD.onEntityRightClick(event.getTarget(), event.getItemStack(), event.getEntity());
        if (result != InteractionResult.PASS) {
            event.setCancellationResult(result);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(MobSpawnEvent.PositionCheck event) {
        MOD.onEntitySpawn((LivingEntity)event.getEntity(), (LevelReader)event.getLevel());
    }

    @SubscribeEvent
    public void onAddSpawns(LevelEvent.PotentialSpawns potentialSpawns) {
        if (biomeSpawns.getSpawns().isEmpty()) {
            MOD.addSpawns(biomeSpawns);
        }
        for (BiomeSpawns.SpawnData spawn : biomeSpawns.getSpawns()) {
            if (potentialSpawns.getMobCategory() != spawn.category() || !spawn.selector().test((Holder<Biome>)potentialSpawns.getLevel().m_204166_(potentialSpawns.getPos()))) continue;
            potentialSpawns.addSpawnerData(spawn.spawnerData());
        }
    }

    @SubscribeEvent
    public static void addAttributes(EntityAttributeCreationEvent event) {
        EntityAttributesBuilder builder = new EntityAttributesBuilder();
        MOD.addAttributes(builder);
        builder.getAttributeSupplierMap().forEach((arg_0, arg_1) -> ((EntityAttributeCreationEvent)event).put(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void onComplete(FMLLoadCompleteEvent event) {
        MOD.onComplete();
    }

    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent event) {
        MOD.onMobDrops(event.getEntity(), event.getDrops());
    }

    @SubscribeEvent
    public void onEntityDamage(LivingHurtEvent event) {
        if (MOD.onEntityDamage((Entity)event.getEntity(), event.getSource())) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientSetup(EntityRenderersEvent.RegisterRenderers event) {
        ModClient.setupEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)event).registerEntityRenderer(arg_0, arg_1));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRegisterParticles(RegisterParticleProvidersEvent event) {
        ModClient.setupParticles();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        ModClient.onItemColors();
    }

    @SubscribeEvent
    public static void onDataGeneration(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), WinterOverhaulRecipeDatagen::new);
        event.getGenerator().addProvider(event.includeServer(), WinterOverhaulLootTableDatagen::new);
        event.getGenerator().addProvider(event.includeServer(), output -> new WinterOverhaulBlockTagDatagen(output, event.getLookupProvider()));
    }
}

