/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.crafting;

import com.aizistral.enigmaticlegacy.items.OblivionStone;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class OblivionStoneCombineRecipe
extends CustomRecipe {
    public static final SimpleCraftingRecipeSerializer<OblivionStoneCombineRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(OblivionStoneCombineRecipe::new);

    public OblivionStoneCombineRecipe(ResourceLocation id, CraftingBookCategory ctg) {
        super(id, ctg);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack voidStone = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack checkedItemStack = inv.m_8020_(i);
            if (checkedItemStack.m_41619_()) continue;
            if (checkedItemStack.m_41720_() == EnigmaticItems.VOID_STONE) {
                if (voidStone == null) {
                    voidStone = checkedItemStack;
                    continue;
                }
                return ItemStack.f_41583_;
            }
            stackList.add(checkedItemStack);
        }
        if (voidStone != null && stackList.size() == 1) {
            ItemStack savedStack = ((ItemStack)stackList.get(0)).m_41777_();
            CompoundTag nbt = voidStone.m_41784_();
            ListTag arr = nbt.m_128437_("SupersolidID", 8);
            int counter = 0;
            if (arr.size() >= OblivionStone.itemHardcap.getValue()) {
                return null;
            }
            for (Tag s_uncast : arr) {
                ++counter;
                String s = ((StringTag)s_uncast).m_7916_();
                if (!s.equals(ForgeRegistries.ITEMS.getKey((Object)savedStack.m_41720_()).toString())) continue;
                return ItemStack.f_41583_;
            }
            ListTag arrCopy = arr.m_6426_();
            CompoundTag nbtCopy = nbt.m_6426_();
            arrCopy.add((Object)StringTag.m_129297_((String)ForgeRegistries.ITEMS.getKey((Object)savedStack.m_41720_()).toString()));
            nbtCopy.m_128365_("SupersolidID", (Tag)arrCopy);
            ItemStack returnedStack = voidStone.m_41777_();
            returnedStack.m_41751_(nbtCopy);
            return returnedStack;
        }
        if (voidStone != null && stackList.size() == 0) {
            ItemStack returnedStack = new ItemStack((ItemLike)EnigmaticItems.VOID_STONE, 1);
            returnedStack.m_41751_(voidStone.m_41784_().m_6426_());
            returnedStack.m_41749_("SupersolidID");
            return returnedStack;
        }
        return ItemStack.f_41583_;
    }

    public boolean matches(CraftingContainer inv, Level world) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack voidStone = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack checkedItemStack = inv.m_8020_(i);
            if (checkedItemStack.m_41619_()) continue;
            if (checkedItemStack.m_41720_() == EnigmaticItems.VOID_STONE) {
                if (voidStone == null) {
                    voidStone = checkedItemStack;
                    continue;
                }
                return false;
            }
            stackList.add(checkedItemStack);
        }
        if (voidStone != null && stackList.size() == 1) {
            ItemStack savedStack = ((ItemStack)stackList.get(0)).m_41777_();
            CompoundTag nbt = voidStone.m_41784_();
            ListTag arr = nbt.m_128437_("SupersolidID", 8);
            int counter = 0;
            if (arr.size() >= OblivionStone.itemHardcap.getValue()) {
                return false;
            }
            for (Tag s_uncast : arr) {
                ++counter;
                String s = ((StringTag)s_uncast).m_7916_();
                if (!s.equals(ForgeRegistries.ITEMS.getKey((Object)savedStack.m_41720_()).toString())) continue;
                return false;
            }
            return true;
        }
        return voidStone != null && stackList.size() == 0;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        return nonnulllist;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

