/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.worldgen;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.entity.mobs.ice_spider.IceSpiderEntity;
import io.redspace.ironsspellbooks.registries.EntityRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ModTags;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.ForgeEventFactory;

public class IceSpiderPatrolSpawner
implements CustomSpawner {
    private static final int DELAY_FIXED = 9600;
    private static final int DELAY_VARIABLE = 3600;
    private int tickDelay;

    public int m_7995_(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!spawnEnemies || !((Boolean)ServerConfigs.ICE_SPIDER_PATROLS.get()).booleanValue()) {
            return 0;
        }
        int playercount = level.m_6907_().size();
        if (playercount < 1) {
            return 0;
        }
        RandomSource randomsource = level.f_46441_;
        --this.tickDelay;
        if (this.tickDelay > 0) {
            return 0;
        }
        this.tickDelay = 9600 / IceSpiderPatrolSpawner.getGroupedPlayerCount(level) + randomsource.m_188503_(3600);
        if (!level.m_46471_() || randomsource.m_188499_()) {
            return 0;
        }
        Player player = null;
        for (int i = 0; i < playercount && ((player = (Player)level.m_6907_().get(randomsource.m_188503_(playercount))).m_5833_() || player.m_7500_()); ++i) {
            player = null;
        }
        if (player == null) {
            return 0;
        }
        int k = (24 + randomsource.m_188503_(24)) * (randomsource.m_188499_() ? -1 : 1);
        int l = (24 + randomsource.m_188503_(24)) * (randomsource.m_188499_() ? -1 : 1);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = player.m_20183_().m_122032_().m_122184_(k, 0, l);
        if (!level.m_151572_(blockpos$mutableblockpos.m_123341_() - 10, blockpos$mutableblockpos.m_123343_() - 10, blockpos$mutableblockpos.m_123341_() + 10, blockpos$mutableblockpos.m_123343_() + 10)) {
            return 0;
        }
        Holder holder = level.m_204166_((BlockPos)blockpos$mutableblockpos);
        if (!holder.m_203656_(ModTags.ICE_SPIDER_PATROLS)) {
            return 0;
        }
        blockpos$mutableblockpos.m_142448_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutableblockpos).m_123342_());
        if (IceSpiderPatrolSpawner.createSpider(level, blockpos$mutableblockpos, player)) {
            IronsSpellbooks.LOGGER.debug("spawning patrol ice spider");
            return 1;
        }
        return 0;
    }

    private static int getGroupedPlayerCount(ServerLevel serverLevel) {
        ArrayList<BlockPos> groupPositions = new ArrayList<BlockPos>();
        int count = 0;
        int groupRange = 48;
        for (Player player : serverLevel.m_6907_()) {
            if (!groupPositions.stream().noneMatch(pos -> pos.m_123331_((Vec3i)player.m_20183_()) < (double)(groupRange * groupRange))) continue;
            ++count;
            groupPositions.add(player.m_20183_());
        }
        return count;
    }

    private static boolean createSpider(ServerLevel level, BlockPos.MutableBlockPos pos, Player player) {
        BlockState blockstate = level.m_8055_((BlockPos)pos);
        if (!NaturalSpawner.m_47056_((BlockGetter)level, (BlockPos)pos, (BlockState)blockstate, (FluidState)blockstate.m_60819_(), (EntityType)((EntityType)EntityRegistry.ICE_SPIDER.get()))) {
            return false;
        }
        if (!IceSpiderPatrolSpawner.checkPatrollingMonsterSpawnRules((EntityType<? extends Mob>)((EntityType)EntityRegistry.ICE_SPIDER.get()), (LevelAccessor)level, MobSpawnType.PATROL, (BlockPos)pos, level.f_46441_)) {
            return false;
        }
        IceSpiderEntity iceSpider = new IceSpiderEntity((Level)level);
        iceSpider.m_20035_(pos.m_7949_(), 0.0f, 0.0f);
        iceSpider.m_6710_((LivingEntity)player);
        level.m_5594_(null, iceSpider.m_20183_(), (SoundEvent)SoundRegistry.ICE_SPIDER_HOWL.get(), SoundSource.HOSTILE, 4.0f, 1.0f);
        iceSpider.setEmergeFromGround();
        if (!ForgeEventFactory.checkSpawnPosition((Mob)iceSpider, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.PATROL)) {
            return false;
        }
        level.m_7967_((Entity)iceSpider);
        iceSpider.m_6518_((ServerLevelAccessor)level, level.m_6436_((BlockPos)pos), MobSpawnType.PATROL, null, null);
        return true;
    }

    public static boolean checkPatrollingMonsterSpawnRules(EntityType<? extends Mob> mob, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_45517_(LightLayer.BLOCK, pos) <= 8 && level.m_46791_() != Difficulty.PEACEFUL && Monster.m_217057_(mob, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }
}

