/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.spells;

import io.redspace.ironsspellbooks.api.backwards_compat.CodecHelper;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ISpellContainerMutable;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.spells.SpellSlot;
import io.redspace.ironsspellbooks.capabilities.magic.SpellContainer;
import java.util.List;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public interface ISpellContainer {
    public static final String NBT = "irons_spellbooks:spell_container";
    public static final String LEGACY_NBT = "ISB_Spells";

    @NotNull
    public SpellSlot[] getAllSpells();

    @NotNull
    public List<SpellSlot> getActiveSpells();

    public int getMaxSpellCount();

    public int getActiveSpellCount();

    public int getNextAvailableIndex();

    public boolean mustEquip();

    public boolean isImproved();

    public boolean isSpellWheel();

    @NotNull
    public SpellData getSpellAtIndex(int var1);

    public int getIndexForSpell(AbstractSpell var1);

    public boolean isEmpty();

    public ISpellContainerMutable mutableCopy();

    public static boolean isSpellContainer(ItemStack itemStack) {
        return itemStack != null && !itemStack.m_41619_() && CodecHelper.hasWithLegacy(itemStack, NBT, LEGACY_NBT);
    }

    public static ISpellContainer create(int maxSpells, boolean addsToSpellWheel, boolean mustBeEquipped) {
        return new SpellContainer(maxSpells, addsToSpellWheel, mustBeEquipped);
    }

    public static ISpellContainer createScrollContainer(AbstractSpell spell, int spellLevel, ItemStack itemStack) {
        ISpellContainerMutable spellContainer = ISpellContainer.create(1, false, false).mutableCopy();
        spellContainer.addSpellAtIndex(spell, spellLevel, 0, true);
        ISpellContainer i = spellContainer.toImmutable();
        ISpellContainer.set(itemStack, i);
        return i;
    }

    public static ISpellContainer createImbuedContainer(AbstractSpell spell, int spellLevel, ItemStack itemStack) {
        ISpellContainerMutable spellContainer = ISpellContainer.create(1, true, itemStack.m_41720_() instanceof ArmorItem || itemStack.m_41720_() instanceof ICurioItem).mutableCopy();
        spellContainer.addSpellAtIndex(spell, spellLevel, 0, true);
        ISpellContainer i = spellContainer.toImmutable();
        ISpellContainer.set(itemStack, i);
        return i;
    }

    public static ISpellContainer get(ItemStack itemStack) {
        return CodecHelper.getOrElseWithLegacy(itemStack, NBT, SpellContainer.CODEC, null, LEGACY_NBT, SpellContainer.LEGACY_CODEC);
    }

    public static ISpellContainer getOrCreate(ItemStack itemStack) {
        if (ISpellContainer.isSpellContainer(itemStack)) {
            return ISpellContainer.get(itemStack);
        }
        return new SpellContainer(1, true, false);
    }

    public static void set(ItemStack stack, ISpellContainer container) {
        CodecHelper.set(stack, NBT, SpellContainer.CODEC, container);
    }

    public static void remove(ItemStack stack) {
        stack.m_41749_(NBT);
    }

    @Deprecated(forRemoval=true)
    public boolean addSpell(AbstractSpell var1, int var2, boolean var3, ItemStack var4);

    @Deprecated(forRemoval=true)
    public void save(ItemStack var1);
}

