/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.backwards_compat.blocks.trial_spawner.spawning;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsspellbooks.api.backwards_compat.blocks.trial_spawner.TrialSpawnerBlock;
import io.redspace.ironsspellbooks.api.backwards_compat.blocks.trial_spawner.spawning.PlayerDetector;
import io.redspace.ironsspellbooks.api.backwards_compat.blocks.trial_spawner.spawning.TrialSpawnerConfig;
import io.redspace.ironsspellbooks.api.backwards_compat.blocks.trial_spawner.spawning.TrialSpawnerData;
import io.redspace.ironsspellbooks.api.backwards_compat.blocks.trial_spawner.spawning.TrialSpawnerState;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;

public final class TrialSpawner {
    public static final String NORMAL_CONFIG_TAG_NAME = "normal_config";
    public static final String OMINOUS_CONFIG_TAG_NAME = "ominous_config";
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int DEFAULT_TARGET_COOLDOWN_LENGTH = 36000;
    private static final int DEFAULT_PLAYER_SCAN_RANGE = 14;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = Mth.m_144944_((int)47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    private final TrialSpawnerConfig normalConfig;
    private final TrialSpawnerConfig ominousConfig;
    private final TrialSpawnerData data;
    private final int requiredPlayerRange;
    private final int targetCooldownLength;
    private final StateAccessor stateAccessor;
    private PlayerDetector playerDetector;
    private final PlayerDetector.EntitySelector entitySelector;
    private boolean overridePeacefulAndMobSpawnRule;
    private boolean isOminous;

    public Codec<TrialSpawner> codec() {
        return RecordCodecBuilder.create(p_338040_ -> p_338040_.group((App)TrialSpawnerConfig.CODEC.optionalFieldOf(NORMAL_CONFIG_TAG_NAME, (Object)TrialSpawnerConfig.DEFAULT).forGetter(TrialSpawner::getNormalConfig), (App)TrialSpawnerConfig.CODEC.optionalFieldOf(OMINOUS_CONFIG_TAG_NAME, (Object)TrialSpawnerConfig.DEFAULT).forGetter(TrialSpawner::getOminousConfigForSerialization), (App)TrialSpawnerData.MAP_CODEC.forGetter(TrialSpawner::getData), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(TrialSpawner::getTargetCooldownLength), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(TrialSpawner::getRequiredPlayerRange)).apply((Applicative)p_338040_, (p_338035_, p_338036_, p_338037_, p_338038_, p_338039_) -> new TrialSpawner((TrialSpawnerConfig)p_338035_, (TrialSpawnerConfig)p_338036_, (TrialSpawnerData)p_338037_, (int)p_338038_, (int)p_338039_, this.stateAccessor, this.playerDetector, this.entitySelector)));
    }

    public TrialSpawner(StateAccessor stateAccessor, PlayerDetector playerDetector, PlayerDetector.EntitySelector entitySelector) {
        this(TrialSpawnerConfig.DEFAULT, TrialSpawnerConfig.DEFAULT, new TrialSpawnerData(), 36000, 14, stateAccessor, playerDetector, entitySelector);
    }

    public TrialSpawner(TrialSpawnerConfig normalConfig, TrialSpawnerConfig ominousConfig, TrialSpawnerData data, int targetCooldownLength, int requiredPlayerRange, StateAccessor stateAccessor, PlayerDetector playerDetector, PlayerDetector.EntitySelector entitySelector) {
        this.normalConfig = normalConfig;
        this.ominousConfig = ominousConfig;
        this.data = data;
        this.targetCooldownLength = targetCooldownLength;
        this.requiredPlayerRange = requiredPlayerRange;
        this.stateAccessor = stateAccessor;
        this.playerDetector = playerDetector;
        this.entitySelector = entitySelector;
    }

    public TrialSpawnerConfig getConfig() {
        return this.isOminous ? this.ominousConfig : this.normalConfig;
    }

    @VisibleForTesting
    public TrialSpawnerConfig getNormalConfig() {
        return this.normalConfig;
    }

    @VisibleForTesting
    public TrialSpawnerConfig getOminousConfig() {
        return this.ominousConfig;
    }

    private TrialSpawnerConfig getOminousConfigForSerialization() {
        return !this.ominousConfig.equals(this.normalConfig) ? this.ominousConfig : TrialSpawnerConfig.DEFAULT;
    }

    public void applyOminous(ServerLevel level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)TrialSpawnerBlock.OMINOUS, (Comparable)Boolean.valueOf(true)), 3);
        level.m_46796_(3020, pos, 1);
        this.isOminous = true;
        this.data.resetAfterBecomingOminous(this, level);
    }

    public void removeOminous(ServerLevel level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_((Property)TrialSpawnerBlock.OMINOUS, (Comparable)Boolean.valueOf(false)), 3);
        this.isOminous = false;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public TrialSpawnerData getData() {
        return this.data;
    }

    public int getTargetCooldownLength() {
        return this.targetCooldownLength;
    }

    public int getRequiredPlayerRange() {
        return this.requiredPlayerRange;
    }

    public TrialSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public void setState(Level level, TrialSpawnerState state) {
        this.stateAccessor.setState(level, state);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public PlayerDetector.EntitySelector getEntitySelector() {
        return this.entitySelector;
    }

    public boolean canSpawnInLevel(Level level) {
        if (this.overridePeacefulAndMobSpawnRule) {
            return true;
        }
        return level.m_46791_() == Difficulty.PEACEFUL ? false : level.m_46469_().m_46207_(GameRules.f_46134_);
    }

    public Optional<UUID> spawnMob(ServerLevel level, BlockPos pos) {
        SpawnData.CustomSpawnRules spawndata$customspawnrules;
        double d2;
        RandomSource randomsource = level.m_213780_();
        SpawnData spawndata = this.data.getOrCreateNextSpawnData(this, level.m_213780_());
        CompoundTag compoundtag = spawndata.f_186561_();
        ListTag listtag = compoundtag.m_128437_("Pos", 6);
        Optional optional = EntityType.m_20637_((CompoundTag)compoundtag);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        int i = listtag.size();
        double d0 = i >= 1 ? listtag.m_128772_(0) : (double)pos.m_123341_() + (randomsource.m_188500_() - randomsource.m_188500_()) * (double)this.getConfig().spawnRange() + 0.5;
        double d1 = i >= 2 ? listtag.m_128772_(1) : (double)(pos.m_123342_() + randomsource.m_188503_(3) - 1);
        double d = d2 = i >= 3 ? listtag.m_128772_(2) : (double)pos.m_123343_() + (randomsource.m_188500_() - randomsource.m_188500_()) * (double)this.getConfig().spawnRange() + 0.5;
        if (!level.m_45772_(((EntityType)optional.get()).m_20585_(d0, d1, d2))) {
            return Optional.empty();
        }
        Vec3 vec3 = new Vec3(d0, d1, d2);
        if (!TrialSpawner.inLineOfSight((Level)level, pos.m_252807_(), vec3)) {
            return Optional.empty();
        }
        BlockPos blockpos = BlockPos.m_274446_((Position)vec3);
        if (!SpawnPlacements.m_217074_((EntityType)((EntityType)optional.get()), (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.SPAWNER, (BlockPos)blockpos, (RandomSource)level.m_213780_())) {
            return Optional.empty();
        }
        if (!(!spawndata.m_186574_().isPresent() || (spawndata$customspawnrules = (SpawnData.CustomSpawnRules)spawndata.m_186574_().get()).f_186584_().m_184578_((Comparable)Integer.valueOf(level.m_45517_(LightLayer.BLOCK, pos))) && spawndata$customspawnrules.f_186585_().m_184578_((Comparable)Integer.valueOf(level.m_45517_(LightLayer.SKY, pos))))) {
            return Optional.empty();
        }
        Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)level, p_312375_ -> {
            p_312375_.m_7678_(d0, d1, d2, randomsource.m_188501_() * 360.0f, 0.0f);
            return p_312375_;
        });
        if (entity == null) {
            return Optional.empty();
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (!mob.m_6914_((LevelReader)level)) {
                return Optional.empty();
            }
            boolean flag = spawndata.m_186567_().m_128440_() == 1 && spawndata.m_186567_().m_128425_("id", 8);
            MobSpawnEvent.FinalizeSpawn event = new MobSpawnEvent.FinalizeSpawn(mob, (ServerLevelAccessor)level, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), level.m_6436_(mob.m_20183_()), MobSpawnType.SPAWNER, null, null, null);
            MinecraftForge.EVENT_BUS.post((Event)event);
            mob.m_6518_((ServerLevelAccessor)level, event.getDifficulty(), event.getSpawnType(), event.getSpawnData(), event.getSpawnTag());
            mob.m_21530_();
        }
        if (!level.m_8860_(entity)) {
            return Optional.empty();
        }
        FlameParticle trialspawner$flameparticle = this.isOminous ? FlameParticle.OMINOUS : FlameParticle.NORMAL;
        level.m_247517_(null, pos, (SoundEvent)SoundRegistry.TRIAL_SPAWNER_SPAWN_MOB.get(), SoundSource.BLOCKS);
        MagicManager.spawnParticles((Level)level, (ParticleOptions)trialspawner$flameparticle.particleType, entity.m_20191_().m_82399_().f_82479_, entity.m_20191_().m_82399_().f_82480_, entity.m_20191_().m_82399_().f_82481_, 25, 0.5, 1.0, 0.5, 0.08, false);
        level.m_142346_(entity, GameEvent.f_157810_, blockpos);
        return Optional.of(entity.m_20148_());
    }

    public void ejectReward(ServerLevel level, BlockPos pos, ResourceLocation lootTable) {
        LootParams lootparams;
        LootTable loottable = level.m_7654_().m_278653_().m_278676_(lootTable);
        ObjectArrayList objectarraylist = loottable.m_287195_(lootparams = new LootParams.Builder(level).m_287235_(LootContextParamSets.f_81410_));
        if (!objectarraylist.isEmpty()) {
            for (ItemStack itemstack : objectarraylist) {
                DefaultDispenseItemBehavior.m_123378_((Level)level, (ItemStack)itemstack, (int)2, (Direction)Direction.UP, (Position)Vec3.m_82539_((Vec3i)pos).m_231075_(Direction.UP, 1.2));
            }
            level.m_247517_(null, pos, (SoundEvent)SoundRegistry.TRIAL_SPAWNER_EJECT_ITEM.get(), SoundSource.BLOCKS);
        }
    }

    public void tickClient(Level level, BlockPos pos, boolean isOminous) {
        RandomSource randomsource;
        TrialSpawnerState trialspawnerstate = this.getState();
        trialspawnerstate.emitParticles(level, pos, isOminous);
        if (trialspawnerstate.hasSpinningMob()) {
            double d0 = Math.max(0L, this.data.nextMobSpawnsAt - level.m_46467_());
            this.data.oSpin = this.data.spin;
            this.data.spin = (this.data.spin + trialspawnerstate.spinningMobSpeed() / (d0 + 200.0)) % 360.0;
        }
        if (trialspawnerstate.isCapableOfSpawning() && (randomsource = level.m_213780_()).m_188501_() <= 0.02f) {
            SoundEvent soundevent = isOminous ? (SoundEvent)SoundRegistry.TRIAL_SPAWNER_AMBIENT_OMINOUS.get() : (SoundEvent)SoundRegistry.TRIAL_SPAWNER_AMBIENT.get();
            level.m_245747_(pos, soundevent, SoundSource.BLOCKS, randomsource.m_188501_() * 0.25f + 0.75f, randomsource.m_188501_() + 0.5f, false);
        }
    }

    public void tickServer(ServerLevel level, BlockPos pos, boolean isOminous) {
        TrialSpawnerState trialspawnerstate1;
        this.isOminous = isOminous;
        TrialSpawnerState trialspawnerstate = this.getState();
        if (this.data.currentMobs.removeIf(p_312870_ -> TrialSpawner.shouldMobBeUntracked(level, pos, p_312870_))) {
            this.data.nextMobSpawnsAt = level.m_46467_() + (long)this.getConfig().ticksBetweenSpawn();
        }
        if ((trialspawnerstate1 = trialspawnerstate.tickAndGetNext(pos, this, level)) != trialspawnerstate) {
            this.setState((Level)level, trialspawnerstate1);
        }
    }

    private static boolean shouldMobBeUntracked(ServerLevel level, BlockPos pos, UUID uuid) {
        Entity entity = level.m_8791_(uuid);
        return entity == null || !entity.m_6084_() || !entity.m_9236_().m_46472_().equals((Object)level.m_46472_()) || entity.m_20183_().m_123331_((Vec3i)pos) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(Level level, Vec3 spawnerPos, Vec3 mobPos) {
        BlockHitResult blockhitresult = level.m_45547_(new ClipContext(mobPos, spawnerPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, null));
        return blockhitresult.m_82425_().equals((Object)BlockPos.m_274446_((Position)spawnerPos)) || blockhitresult.m_6662_() == HitResult.Type.MISS;
    }

    public static void addSpawnParticles(Level level, BlockPos pos, RandomSource random, SimpleParticleType particleType) {
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 2.0;
            double d1 = (double)pos.m_123342_() + 0.5 + (random.m_188500_() - 0.5) * 2.0;
            double d2 = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 2.0;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)particleType, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static void addBecomeOminousParticles(Level level, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)pos.m_123341_() + 0.5 + (random.m_188500_() - 0.5) * 2.0;
            double d1 = (double)pos.m_123342_() + 0.5 + (random.m_188500_() - 0.5) * 2.0;
            double d2 = (double)pos.m_123343_() + 0.5 + (random.m_188500_() - 0.5) * 2.0;
            double d3 = random.m_188583_() * 0.02;
            double d4 = random.m_188583_() * 0.02;
            double d5 = random.m_188583_() * 0.02;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, d0, d1, d2, d3, d4, d5);
        }
    }

    public static void addDetectPlayerParticles(Level level, BlockPos pos, RandomSource random, int type, ParticleOptions particle) {
        for (int i = 0; i < 30 + Math.min(type, 10) * 5; ++i) {
            double d0 = (double)(2.0f * random.m_188501_() - 1.0f) * 0.65;
            double d1 = (double)(2.0f * random.m_188501_() - 1.0f) * 0.65;
            double d2 = (double)pos.m_123341_() + 0.5 + d0;
            double d3 = (double)pos.m_123342_() + 0.1 + (double)random.m_188501_() * 0.8;
            double d4 = (double)pos.m_123343_() + 0.5 + d1;
            level.m_7106_(particle, d2, d3, d4, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(Level level, BlockPos pos, RandomSource random) {
        for (int i = 0; i < 20; ++i) {
            double d0 = (double)pos.m_123341_() + 0.4 + random.m_188500_() * 0.2;
            double d1 = (double)pos.m_123342_() + 0.4 + random.m_188500_() * 0.2;
            double d2 = (double)pos.m_123343_() + 0.4 + random.m_188500_() * 0.2;
            double d3 = random.m_188583_() * 0.02;
            double d4 = random.m_188583_() * 0.02;
            double d5 = random.m_188583_() * 0.02;
            level.m_7106_((ParticleOptions)ParticleTypes.f_175834_, d0, d1, d2, d3, d4, d5 * 0.25);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, d3, d4, d5);
        }
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void setPlayerDetector(PlayerDetector playerDetector) {
        this.playerDetector = playerDetector;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void overridePeacefulAndMobSpawnRule() {
        this.overridePeacefulAndMobSpawnRule = true;
    }

    public static interface StateAccessor {
        public void setState(Level var1, TrialSpawnerState var2);

        public TrialSpawnerState getState();

        public void markUpdated();
    }

    public static enum FlameParticle {
        NORMAL(ParticleTypes.f_123744_),
        OMINOUS(ParticleTypes.f_123745_);

        public final SimpleParticleType particleType;

        private FlameParticle(SimpleParticleType particleType) {
            this.particleType = particleType;
        }

        public static FlameParticle decode(int id) {
            FlameParticle[] atrialspawner$flameparticle = FlameParticle.values();
            return id <= atrialspawner$flameparticle.length && id >= 0 ? atrialspawner$flameparticle[id] : NORMAL;
        }

        public int encode() {
            return this.ordinal();
        }
    }
}

