/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util.rituals;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.alshanex.alshanex_familiars.block.entity.FamiliarStatueEntity;
import net.alshanex.alshanex_familiars.block.entity.RitualCorePedestalEntity;
import net.alshanex.alshanex_familiars.compat.ItemMultiSet;
import net.alshanex.alshanex_familiars.recipe_types.RitualRecipeType;
import net.alshanex.alshanex_familiars.registry.RecipeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RitualHelper {
    private static Optional<RitualRecipeType> findMatchingRecipe(Level level, BlockPos centralPos, ItemStack centralStack) {
        if (centralStack == null || centralStack.m_41619_()) {
            return Optional.empty();
        }
        List<BlockEntity> surroundingPedestals = RitualHelper.getSurroundingPedestals(centralPos, level);
        ItemMultiSet pedestalItems = RitualHelper.getItemsFromPedestals(surroundingPedestals);
        RitualRecipeType.RitualContainer recipeInput = new RitualRecipeType.RitualContainer(centralStack, pedestalItems);
        RecipeManager manager = level.m_7465_();
        return manager.m_44013_((RecipeType)RecipeRegistry.RITUAL_RECIPE_TYPE.get()).stream().filter(recipe -> recipe.m_5818_((Container)recipeInput, level)).findFirst();
    }

    public static boolean isValidRecipe(Level level, BlockPos centralPos, ItemStack stack) {
        if (stack == null || level == null) {
            return false;
        }
        List<BlockEntity> surroundingPedestals = RitualHelper.getSurroundingPedestals(centralPos, level);
        if (surroundingPedestals.size() < 4) {
            return false;
        }
        return RitualHelper.findMatchingRecipe(level, centralPos, stack).isPresent();
    }

    public static Item getResultForRecipe(Level level, BlockPos centerPos, ItemStack stack) {
        if (stack == null || level == null) {
            return ItemStack.f_41583_.m_41720_();
        }
        return RitualHelper.findMatchingRecipe(level, centerPos, stack).map(RitualRecipeType::result).map(ItemStack::m_41720_).orElse(ItemStack.f_41583_.m_41720_());
    }

    public static boolean isItemInRecipeRecipe(Level level, ItemStack stack) {
        if (stack == null || level == null) {
            return false;
        }
        RecipeManager manager = level.m_7465_();
        return manager.m_44013_((RecipeType)RecipeRegistry.RITUAL_RECIPE_TYPE.get()).stream().anyMatch(recipe -> recipe.centralItem().test(stack));
    }

    public static ParticleOptions getParticleForRecipe(Level level, BlockPos centerPos, ItemStack stack) {
        if (stack == null || level == null) {
            return ParticleTypes.f_123809_;
        }
        return RitualHelper.findMatchingRecipe(level, centerPos, stack).map(RitualRecipeType::defaultParticle).map(holder -> {
            Object patt3599$temp = holder.m_203334_();
            if (patt3599$temp instanceof SimpleParticleType) {
                SimpleParticleType simple = (SimpleParticleType)patt3599$temp;
                return simple;
            }
            return ParticleTypes.f_123809_;
        }).orElse((ParticleOptions)ParticleTypes.f_123809_);
    }

    public static void clearItemsFromPedestals(Level level, BlockPos pos) {
        Optional<RitualRecipeType> recipeOptional;
        BlockEntity centralEntity = level.m_7702_(pos);
        ItemStack centralStack = ItemStack.f_41583_;
        if (centralEntity instanceof RitualCorePedestalEntity) {
            RitualCorePedestalEntity core = (RitualCorePedestalEntity)centralEntity;
            centralStack = core.getHeldItem();
        }
        if ((recipeOptional = RitualHelper.findMatchingRecipe(level, pos, centralStack)).isPresent()) {
            RitualRecipeType recipe = recipeOptional.get();
            List<BlockEntity> pedestals = RitualHelper.getSurroundingPedestals(pos, level);
            List availablePedestals = pedestals.stream().filter(be -> {
                FamiliarStatueEntity s;
                return be instanceof FamiliarStatueEntity && !(s = (FamiliarStatueEntity)((Object)be)).getHeldItem().m_41619_();
            }).map(be -> (FamiliarStatueEntity)((Object)be)).collect(Collectors.toList());
            block0: for (RitualRecipeType.RitualIngredient ingredient : recipe.inputs()) {
                Iterator iterator = availablePedestals.iterator();
                while (iterator.hasNext()) {
                    FamiliarStatueEntity pedestal = (FamiliarStatueEntity)((Object)iterator.next());
                    ItemStack heldStack = pedestal.getHeldItem();
                    if (heldStack.m_41720_() != ingredient.item() || heldStack.m_41613_() < ingredient.count()) continue;
                    if (ingredient.consume()) {
                        BlockState prevState = pedestal.m_58900_();
                        pedestal.setHeldItem(ItemStack.f_41583_);
                        BlockState nextState = pedestal.m_58900_();
                        level.m_7260_(pedestal.m_58899_(), prevState, nextState, 2);
                    }
                    iterator.remove();
                    continue block0;
                }
            }
        }
    }

    public static List<BlockEntity> getSurroundingPedestals(BlockPos origin, Level level) {
        BlockPos[] offsets = new BlockPos[]{origin.m_122013_(2), origin.m_122020_(2), origin.m_122030_(2), origin.m_122025_(2)};
        ArrayList<BlockEntity> pedestals = new ArrayList<BlockEntity>();
        for (BlockPos pos : offsets) {
            BlockEntity entity = level.m_7702_(pos);
            if (!(entity instanceof FamiliarStatueEntity)) continue;
            pedestals.add(entity);
        }
        return pedestals;
    }

    public static ItemMultiSet getItemsFromPedestals(List<BlockEntity> surroundingPedestals) {
        ItemMultiSet pedestalItems = new ItemMultiSet();
        for (BlockEntity pedestal : surroundingPedestals) {
            FamiliarStatueEntity statue;
            if (!(pedestal instanceof FamiliarStatueEntity) || (statue = (FamiliarStatueEntity)pedestal).getHeldItem().m_41619_()) continue;
            pedestalItems.add(statue.getHeldItem().m_41720_());
        }
        return pedestalItems;
    }

    public static void spawnParticlesAtPedestals(ParticleOptions particles, BlockPos origin, Level pLevel) {
        if (!pLevel.m_5776_()) {
            BlockPos[] offsets = new BlockPos[]{origin.m_122013_(2), origin.m_122020_(2), origin.m_122030_(2), origin.m_122025_(2)};
            MagicManager.spawnParticles((Level)pLevel, (ParticleOptions)particles, (double)origin.m_123341_(), (double)(origin.m_123342_() + 2), (double)origin.m_123343_(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            for (BlockPos pos : offsets) {
                MagicManager.spawnParticles((Level)pLevel, (ParticleOptions)particles, (double)pos.m_123341_(), (double)(pos.m_123342_() + 2), (double)pos.m_123343_(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
            }
        }
    }
}

