/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.util.rituals;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class FlyingItem {
    private ItemStack stack;
    private BlockPos sourcePos;
    private BlockPos targetPos;
    private int ticksRemaining;
    private int totalTicks;
    private boolean isRetrieving;

    public FlyingItem(ItemStack stack, BlockPos source, BlockPos target, int duration, boolean retrieving) {
        this.stack = stack;
        this.sourcePos = source;
        this.targetPos = target;
        this.ticksRemaining = duration;
        this.totalTicks = duration;
        this.isRetrieving = retrieving;
    }

    public FlyingItem() {
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public BlockPos getSourcePos() {
        return this.sourcePos;
    }

    public BlockPos getTargetPos() {
        return this.targetPos;
    }

    public int getTicksRemaining() {
        return this.ticksRemaining;
    }

    public int getTotalTicks() {
        return this.totalTicks;
    }

    public boolean isRetrieving() {
        return this.isRetrieving;
    }

    public void tick() {
        --this.ticksRemaining;
    }

    public boolean hasArrived() {
        return this.ticksRemaining <= 0;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        if (!this.stack.m_41619_()) {
            CompoundTag stackTag = new CompoundTag();
            this.stack.m_41739_(stackTag);
            tag.m_128365_("Stack", (Tag)stackTag);
        }
        tag.m_128356_("Source", this.sourcePos.m_121878_());
        tag.m_128356_("Target", this.targetPos.m_121878_());
        tag.m_128405_("Ticks", this.ticksRemaining);
        tag.m_128405_("Total", this.totalTicks);
        tag.m_128379_("Retrieving", this.isRetrieving);
        return tag;
    }

    public static FlyingItem load(CompoundTag tag) {
        FlyingItem item = new FlyingItem();
        item.stack = tag.m_128441_("Stack") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("Stack")) : ItemStack.f_41583_;
        item.sourcePos = BlockPos.m_122022_((long)tag.m_128454_("Source"));
        item.targetPos = BlockPos.m_122022_((long)tag.m_128454_("Target"));
        item.ticksRemaining = tag.m_128451_("Ticks");
        item.totalTicks = tag.m_128451_("Total");
        item.isRetrieving = tag.m_128471_("Retrieving");
        return item;
    }
}

