/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.spells;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.entity.sound.BlackNoteEntity;
import net.alshanex.alshanex_familiars.entity.sound.DefaultNoteEntity;
import net.alshanex.alshanex_familiars.registry.AFSchoolRegistry;
import net.alshanex.alshanex_familiars.registry.AFSoundRegistry;
import net.alshanex.alshanex_familiars.registry.ParticleRegistry;
import net.alshanex.alshanex_familiars.util.CylinderParticleManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class SonataSpell
extends AbstractSpell {
    SoundEvent playingSound = null;
    private boolean musicPlaying = false;
    private int musicTimer = 0;
    private static final int MUSIC_DURATION = 200;
    private final ResourceLocation spellId = new ResourceLocation("alshanex_familiars", "sonata");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(AFSchoolRegistry.SOUND_RESOURCE).setMaxLevel(5).setCooldownSeconds(40.0).build();

    public SonataSpell() {
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 15;
        this.spellPowerPerLevel = 1;
        this.castTime = 300;
        this.baseManaCost = 5;
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.radius", (Object[])new Object[]{Utils.stringTruncation((double)this.getRadius(spellLevel), (int)1)}), Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.irons_spellbooks.projectile_count", (Object[])new Object[]{this.getCount(spellLevel, caster)}));
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.ANIMATION_CONTINUOUS_OVERHEAD;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (this.musicPlaying) {
            this.stopMinecraftAmbientMusic(world);
            if (this.musicTimer > 0) {
                --this.musicTimer;
            } else {
                this.playMusic(world, entity);
            }
        }
        if (!this.musicPlaying) {
            this.playMusic(world, entity);
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        if (playerMagicData != null && (playerMagicData.getCastDurationRemaining() + 1) % 20 == 0) {
            this.shootNotes(level, spellLevel, entity);
        }
        if (playerMagicData != null && (playerMagicData.getCastDurationRemaining() + 1) % 5 == 0) {
            boolean isBlackParticle;
            boolean bl = isBlackParticle = Utils.random.m_188500_() <= 0.5;
            if (isBlackParticle) {
                CylinderParticleManager.spawnParticlesAtBlockPos(level, entity.m_20182_(), 1, (ParticleOptions)ParticleRegistry.BLACK_NOTE_PARTICLE.get(), CylinderParticleManager.ParticleDirection.UPWARD, 0.1, 0.2, entity.m_20206_());
            } else {
                CylinderParticleManager.spawnParticlesAtBlockPos(level, entity.m_20182_(), 1, (ParticleOptions)ParticleRegistry.MUSICAL_NOTE_PARTICLE.get(), CylinderParticleManager.ParticleDirection.UPWARD, 0.1, 0.2, entity.m_20206_());
            }
        }
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 0.4f;
    }

    private double getRadius(int spellLevel) {
        return 10 + spellLevel * 2;
    }

    private int getCount(int spellLevel, LivingEntity entity) {
        return 3 + spellLevel;
    }

    public void shootNotes(Level world, int spellLevel, LivingEntity entity) {
        int count = this.getCount(spellLevel, entity);
        double radius = this.getRadius(spellLevel);
        double radiusSqr = radius * radius;
        world.m_6443_(LivingEntity.class, new AABB(entity.m_20182_().m_82492_(radius, radius, radius), entity.m_20182_().m_82520_(radius, radius, radius)), livingEntity -> (double)this.horizontalDistanceSqr((LivingEntity)livingEntity, entity.m_20182_()) < radiusSqr && !Utils.shouldHealEntity((Entity)entity, (Entity)livingEntity) && !livingEntity.m_21023_((MobEffect)MobEffectRegistry.GUIDING_BOLT.get())).forEach(livingEntity -> livingEntity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.GUIDING_BOLT.get(), 100, 0, false, false, true)));
        for (int i = 0; i < count; ++i) {
            boolean isBlackNote;
            double angle = Math.toRadians(360 / count * i);
            double x = Math.cos(angle);
            double z = Math.sin(angle);
            Vec3 direction = new Vec3(x, 0.0, z).m_82541_().m_82490_(1.5);
            float xRot = (float)Math.toDegrees(-Math.atan2(direction.f_82480_, Math.sqrt(direction.f_82479_ * direction.f_82479_ + direction.f_82481_ * direction.f_82481_)));
            float yRot = (float)Math.toDegrees(Math.atan2(direction.f_82479_, direction.f_82481_));
            boolean bl = isBlackNote = Utils.random.m_188500_() < 0.3;
            if (isBlackNote) {
                BlackNoteEntity blackNote = new BlackNoteEntity(world, entity);
                blackNote.m_6034_(entity.m_20185_(), entity.m_20188_() - 0.5, entity.m_20189_());
                blackNote.setRotation(xRot, yRot);
                blackNote.setDamage(this.getDamage(spellLevel, entity));
                blackNote.shoot(new Vec3(x * 1.5, 0.0, z * 1.5));
                world.m_7967_((Entity)blackNote);
                continue;
            }
            DefaultNoteEntity defaultNote = new DefaultNoteEntity(world, entity);
            defaultNote.m_6034_(entity.m_20185_(), entity.m_20188_() - 0.5, entity.m_20189_());
            defaultNote.setRotation(xRot, yRot);
            defaultNote.setDamage(this.getDamage(spellLevel, entity));
            defaultNote.shoot(new Vec3(x * 1.5, 0.0, z * 1.5));
            world.m_7967_((Entity)defaultNote);
        }
    }

    public void onServerCastComplete(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData, boolean cancelled) {
        if (this.musicPlaying) {
            this.stopMusic(level);
            this.musicPlaying = false;
            this.musicTimer = 0;
        }
        super.onServerCastComplete(level, spellLevel, entity, playerMagicData, cancelled);
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.m_20185_() - vec3.f_82479_;
        double dz = livingEntity.m_20189_() - vec3.f_82481_;
        return (float)(dx * dx + dz * dz);
    }

    private void stopMinecraftAmbientMusic(Level level) {
        if (!level.f_46443_ && level.m_7654_() != null) {
            for (ServerPlayer player : Objects.requireNonNull(level.m_7654_()).m_6846_().m_11314_()) {
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.game"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.creative"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.menu"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.overworld.day"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.overworld.night"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.overworld.hills"), SoundSource.MUSIC));
                player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(new ResourceLocation("minecraft", "music.overworld.water"), SoundSource.MUSIC));
            }
        }
    }

    private void playMusic(Level level, LivingEntity entity) {
        if (!level.f_46443_ && !this.musicPlaying) {
            this.playingSound = (SoundEvent)AFSoundRegistry.BARD_SONG_2.get();
            this.musicPlaying = true;
            this.musicTimer = 200;
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.playingSound, SoundSource.MUSIC, 1.0f, 1.0f);
        }
    }

    private void stopMusic(Level level) {
        if (!level.f_46443_ && level.m_7654_() != null && this.playingSound != null) {
            Objects.requireNonNull(level.m_7654_()).m_6846_().m_11314_().forEach(player -> player.f_8906_.m_9829_((Packet)new ClientboundStopSoundPacket(this.playingSound.m_11660_(), SoundSource.MUSIC)));
            this.playingSound = null;
        }
    }
}

