/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.item.curios;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.item.curios.SimpleDescriptiveCurio;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import io.redspace.ironsspellbooks.setup.PacketDistributor;
import java.util.List;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.util.CurioUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class HealingCurio
extends SimpleDescriptiveCurio {
    private static final Component DESCRIPTION = Component.m_237115_((String)"item.alshanex_familiars.healing_curio.desc").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});

    public HealingCurio() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.UNCOMMON));
    }

    private void handleHeal(SlotContext slotContext) {
        LivingEntity entity = slotContext.entity();
        if (entity != null && !slotContext.entity().m_9236_().f_46443_ && CurioUtils.isWearingCurio(slotContext.entity(), (Item)ItemRegistry.HEALING_CURIO.get())) {
            this.healPets(slotContext.entity().m_9236_(), slotContext.entity());
        }
    }

    public List<Component> getSlotsTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.add(DESCRIPTION);
        return tooltips;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        if (slotContext.entity().f_19797_ % 10 == 0) {
            this.handleHeal(slotContext);
        }
    }

    private void healPets(Level level, LivingEntity player) {
        List entities = level.m_6249_((Entity)player, player.m_20191_().m_82400_(20.0), entity -> {
            AbstractSpellCastingPet pet;
            return entity instanceof AbstractSpellCastingPet && (pet = (AbstractSpellCastingPet)((Object)entity)).getSummoner() != null && pet.getSummoner().m_7306_((Entity)player);
        });
        for (Entity entity2 : entities) {
            ServerPlayer serverPlayer;
            MagicData magicData;
            AbstractSpellCastingPet pet = (AbstractSpellCastingPet)entity2;
            if (!(pet.m_21223_() < pet.m_21233_()) || !(player instanceof ServerPlayer) || !((magicData = MagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)player))).getMana() >= 5.0f)) continue;
            float newMana = Math.max(magicData.getMana() - 5.0f, 0.0f);
            magicData.setMana(newMana);
            pet.m_5634_(1.0f);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (Object)new SyncManaPacket(magicData));
        }
    }
}

