/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity.generic;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import io.redspace.ironsspellbooks.util.OwnerHelper;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.util.CurioUtils;
import net.alshanex.alshanex_familiars.util.ModTags;
import net.alshanex.alshanex_familiars.util.PetAnimationUtils;
import net.alshanex.alshanex_familiars.util.PetAttributesHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractSpellCastingPet
extends PathfinderMob
implements GeoEntity,
IMagicEntity {
    private static final EntityDataAccessor<Boolean> DATA_CANCEL_CAST = SynchedEntityData.m_135353_(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> DATA_IS_SITTING;
    protected final MagicData playerMagicData = new MagicData(true);
    private static final EntityDataAccessor<Optional<UUID>> DATA_ID_OWNER_UUID;
    private static final EntityDataAccessor<Boolean> DATA_BLOCKING;
    private static final EntityDataAccessor<Integer> DATA_ENRAGED;
    private static final EntityDataAccessor<Integer> DATA_ARMOR;
    private static final EntityDataAccessor<Integer> DATA_HEALTH;
    protected LivingEntity cachedSummoner;
    @org.jetbrains.annotations.Nullable
    protected SpellData castingSpell;
    public boolean hasUsedSingleAttack;
    protected boolean recreateSpell;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected AbstractSpell lastCastSpellType = SpellRegistry.none();
    protected AbstractSpell instantCastSpellType = SpellRegistry.none();
    protected boolean cancelCastAnimation = false;
    protected boolean animatingLegs = false;
    protected final RawAnimation idle = RawAnimation.begin().thenLoop("idle");
    protected final RawAnimation walk = RawAnimation.begin().thenLoop("walk");
    protected final RawAnimation attack = RawAnimation.begin().thenPlay("skill");
    protected final RawAnimation longCast = RawAnimation.begin().thenPlay("long_cast");
    protected final RawAnimation interact = RawAnimation.begin().thenPlay("interact");
    protected final RawAnimation stomp = RawAnimation.begin().thenPlay("stomp");
    protected final RawAnimation spawn = RawAnimation.begin().thenPlay("spawn");
    protected final AnimationController animationControllerInstantCast = new AnimationController((GeoAnimatable)this, "instant_casting", 0, this::instantCastingPredicate);
    protected final AnimationController animationControllerLongCast = new AnimationController((GeoAnimatable)this, "long_casting", 0, this::longCastingPredicate);

    protected AbstractSpellCastingPet(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.playerMagicData.setSyncedData(new SyncedSpellData((LivingEntity)this));
        this.f_21365_ = this.createLookControl();
    }

    public boolean getHasUsedSingleAttack() {
        return this.hasUsedSingleAttack;
    }

    public void setHasUsedSingleAttack(boolean hasUsedSingleAttack) {
        this.hasUsedSingleAttack = hasUsedSingleAttack;
    }

    public void m_6083_() {
        super.m_6083_();
        Entity entity = this.m_20202_();
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfindermob = (PathfinderMob)entity;
            pathfindermob.f_20883_ = this.f_20883_;
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new TeleportToOwnerGoal(this, this::getSummoner, 20.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, this::getSummoner, (double)1.2f, 10.0f, 3.0f, false, Float.MAX_VALUE));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, this::getSummoner));
        this.f_21346_.m_25352_(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, this::getSummoner));
        this.f_21346_.m_25352_(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, this::getSummoner));
        this.f_21346_.m_25352_(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public boolean m_7307_(Entity pEntity) {
        return super.m_7307_(pEntity) || this.isAlliedHelper(pEntity);
    }

    private boolean isAlliedHelper(Entity entity) {
        LivingEntity owner = this.getSummoner();
        if (owner == null) {
            return false;
        }
        if (entity instanceof IMagicSummon) {
            IMagicSummon magicSummon = (IMagicSummon)entity;
            Entity otherOwner = magicSummon.getSummoner();
            return otherOwner != null && (owner == otherOwner || otherOwner.m_7307_(otherOwner));
        }
        if (entity instanceof OwnableEntity) {
            OwnableEntity tamableAnimal = (OwnableEntity)entity;
            LivingEntity otherOwner = tamableAnimal.m_269323_();
            return otherOwner != null && (owner == otherOwner || otherOwner.m_7307_((Entity)otherOwner));
        }
        return false;
    }

    public void setOwnerUUID(@org.jetbrains.annotations.Nullable UUID uuid) {
        this.f_19804_.m_135381_(DATA_ID_OWNER_UUID, Optional.ofNullable(uuid));
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.f_19804_.m_135370_(DATA_ID_OWNER_UUID)).orElseGet(() -> ((Optional)this.f_19804_.m_135370_(DATA_ID_OWNER_UUID)).orElse(null));
    }

    public LivingEntity getSummoner() {
        return OwnerHelper.getAndCacheOwner((Level)this.m_9236_(), (LivingEntity)this.cachedSummoner, (UUID)this.getOwnerUUID());
    }

    public void setEnragedStacks(Integer level) {
        this.f_19804_.m_135381_(DATA_ENRAGED, (Object)level);
    }

    public Integer getEnragedStacks() {
        return (Integer)this.f_19804_.m_135370_(DATA_ENRAGED);
    }

    public void setSitting(Boolean level) {
        if (level.booleanValue()) {
            this.clearMovementGoals();
            this.f_21344_.m_26573_();
            this.m_6710_(null);
        } else {
            this.restoreMovementGoals();
            this.f_21344_.m_26569_();
        }
        this.f_19804_.m_135381_(DATA_IS_SITTING, (Object)level);
    }

    public Boolean getIsSitting() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_SITTING);
    }

    protected void clearMovementGoals() {
        this.f_21345_.m_262460_(goal -> goal instanceof GenericFollowOwnerGoal);
    }

    protected void restoreMovementGoals() {
        this.f_21345_.m_25352_(7, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, this::getSummoner, (double)1.2f, 10.0f, 3.0f, false, Float.MAX_VALUE));
    }

    public void setArmorStacks(Integer level) {
        this.f_19804_.m_135381_(DATA_ARMOR, (Object)level);
    }

    public Integer getArmorStacks() {
        return (Integer)this.f_19804_.m_135370_(DATA_ARMOR);
    }

    public void setHealthStacks(Integer level) {
        this.f_19804_.m_135381_(DATA_HEALTH, (Object)level);
    }

    public Integer getHealthStacks() {
        return (Integer)this.f_19804_.m_135370_(DATA_HEALTH);
    }

    public void setIsBlocking(Boolean level) {
        this.f_19804_.m_135381_(DATA_BLOCKING, (Object)level);
    }

    public Boolean getIsBlocking() {
        return (Boolean)this.f_19804_.m_135370_(DATA_BLOCKING);
    }

    public void m_6667_(DamageSource pDamageSource) {
        if (this.getSummoner() != null) {
            this.onDeathHelper();
        }
        super.m_6667_(pDamageSource);
    }

    private void onDeathHelper() {
        LivingEntity livingEntity;
        Level level = this.m_9236_();
        Component deathMessage = this.m_21231_().m_19293_();
        if (!level.f_46443_ && level.m_46469_().m_46207_(GameRules.f_46142_) && (livingEntity = this.getSummoner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            player.m_213846_(deathMessage);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.setSitting(false);
        }
        return super.m_6469_(pSource, pAmount);
    }

    protected LookControl createLookControl() {
        return new LookControl((Mob)this){

            protected boolean m_8106_() {
                return AbstractSpellCastingPet.this.m_5448_() == null;
            }
        };
    }

    protected MoveControl createMoveControl() {
        return new MoveControl((Mob)this){

            protected float m_24991_(float pSourceAngle, float pTargetAngle, float pMaximumChange) {
                double d1;
                double d0 = this.f_24975_ - this.f_24974_.m_20185_();
                if (d0 * d0 + (d1 = this.f_24977_ - this.f_24974_.m_20189_()) * d1 < 0.5) {
                    return pSourceAngle;
                }
                return super.m_24991_(pSourceAngle, pTargetAngle, pMaximumChange * 0.25f);
            }
        };
    }

    public MagicData getMagicData() {
        return this.playerMagicData;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.f_19811_ = this.isAnimating();
        }
        if (this.getSummoner() != null && this.f_19797_ % 10 == 0) {
            if (CurioUtils.isWearingCurio(this.getSummoner(), (Item)ItemRegistry.FAMILIAR_SPELLBOOK.get())) {
                PetAttributesHelper.applyAttributes(this);
            } else {
                PetAttributesHelper.removeAttributes(this);
            }
        }
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(DATA_BLOCKING, (Object)false);
        this.f_19804_.m_135372_(DATA_ENRAGED, (Object)0);
        this.f_19804_.m_135372_(DATA_ARMOR, (Object)0);
        this.f_19804_.m_135372_(DATA_HEALTH, (Object)0);
        this.f_19804_.m_135372_(DATA_CANCEL_CAST, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_SITTING, (Object)false);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (!this.m_9236_().f_46443_) {
            return;
        }
        if (pKey.m_135015_() == DATA_CANCEL_CAST.m_135015_()) {
            this.cancelCast();
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.playerMagicData.getSyncedData().saveNBTData(pCompound, (HolderLookup.Provider)this.m_9236_().m_9598_());
        pCompound.m_128379_("usedSpecial", this.hasUsedSingleAttack);
        if (this.getOwnerUUID() != null) {
            pCompound.m_128362_("ownerUUID", this.getOwnerUUID());
        } else {
            pCompound.m_128359_("ownerUUID", "null");
        }
        pCompound.m_128405_("enragedStacks", this.getEnragedStacks().intValue());
        pCompound.m_128379_("isBlocking", this.getIsBlocking().booleanValue());
        pCompound.m_128405_("armorStacks", this.getArmorStacks().intValue());
        pCompound.m_128405_("healthStacks", this.getHealthStacks().intValue());
        pCompound.m_128379_("Sitting", this.getIsSitting().booleanValue());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        SyncedSpellData syncedSpellData = new SyncedSpellData((LivingEntity)this);
        syncedSpellData.loadNBTData(pCompound, (HolderLookup.Provider)this.m_9236_().m_9598_());
        if (syncedSpellData.isCasting()) {
            this.recreateSpell = true;
        }
        this.playerMagicData.setSyncedData(syncedSpellData);
        this.hasUsedSingleAttack = pCompound.m_128471_("usedSpecial");
        if (pCompound.m_128441_("ownerUUID")) {
            String ownerUUIDString = pCompound.m_128461_("ownerUUID");
            if (!"null".equals(ownerUUIDString)) {
                this.setOwnerUUID(pCompound.m_128342_("ownerUUID"));
            } else {
                this.setOwnerUUID(null);
            }
        }
        if (pCompound.m_128441_("enragedStacks")) {
            this.setEnragedStacks(pCompound.m_128451_("enragedStacks"));
        }
        if (pCompound.m_128441_("isBlocking")) {
            this.setIsBlocking(pCompound.m_128471_("isBlocking"));
        }
        if (pCompound.m_128441_("armorStacks")) {
            this.setArmorStacks(pCompound.m_128451_("armorStacks"));
        }
        if (pCompound.m_128441_("healthStacks")) {
            this.setHealthStacks(pCompound.m_128451_("healthStacks"));
        }
        if (pCompound.m_128441_("Sitting")) {
            this.setSitting(pCompound.m_128471_("Sitting"));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.getSummoner() != null && this.getSummoner().m_7306_((Entity)player) && itemstack.m_150930_(Items.f_42398_)) {
            this.setSitting(this.getIsSitting() == false);
            return InteractionResult.SUCCESS;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.getOwnerUUID() != null) {
                if (this.getOwnerUUID().equals(player.m_20148_())) {
                    this.triggerAnim("interact_controller", "interact");
                    if (itemstack.m_150930_((Item)ItemRegistry.BLUEBERRY.get())) {
                        itemstack.m_41774_(1);
                        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.MEMORY_FRAGMENT.get());
                        this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
                        if (this.m_21223_() < this.m_21233_()) {
                            this.m_5634_(4.0f);
                            this.m_146850_(GameEvent.f_157806_);
                        }
                        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                    }
                    if (this.isFood(itemstack) && this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(4.0f);
                        itemstack.m_41774_(1);
                        this.spawnEatingParticles();
                        this.m_146850_(GameEvent.f_157806_);
                        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                    }
                }
            } else if (itemstack.m_204117_(ModTags.FAMILIAR_TAMING)) {
                itemstack.m_41774_(1);
                this.tryToTame(player);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    protected boolean isFood(ItemStack item) {
        return item.m_150930_(Items.f_42410_);
    }

    protected void tryToTame(Player player) {
        if (this.f_19796_.m_188503_(10) == 0) {
            this.spawnTamingParticles(true);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.setOwnerUUID(player.m_20148_());
        } else {
            this.spawnTamingParticles(false);
        }
    }

    protected void spawnTamingParticles(boolean tamed) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!tamed) {
            particleoptions = ParticleTypes.f_123762_;
        }
        int count = 16;
        float radius = 1.25f;
        for (int i = 0; i < count; ++i) {
            double theta = Math.toRadians(360 / count) * (double)i;
            double x = Math.cos(theta) * (double)radius;
            double z = Math.sin(theta) * (double)radius;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)particleoptions, (double)(this.m_20182_().f_82479_ + x), (double)this.m_20182_().f_82480_, (double)(this.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.triggerAnim("spawn_controller", "spawn");
    }

    protected void spawnEatingParticles() {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        int count = 3;
        float radius = 0.5f;
        for (int i = 0; i < count; ++i) {
            double theta = Math.toRadians(360 / count) * (double)i;
            double x = Math.cos(theta) * (double)radius;
            double z = Math.sin(theta) * (double)radius;
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)particleoptions, (double)(this.m_20182_().f_82479_ + x), (double)this.m_20182_().f_82480_, (double)(this.m_20182_().f_82481_ + z), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (boolean)false);
        }
    }

    public void cancelCast() {
        if (this.isCasting()) {
            if (this.m_9236_().f_46443_) {
                this.cancelCastAnimation = true;
            } else {
                this.f_19804_.m_135381_(DATA_CANCEL_CAST, (Object)((Boolean)this.f_19804_.m_135370_(DATA_CANCEL_CAST) == false ? 1 : 0));
            }
            this.castComplete();
        }
    }

    public void castComplete() {
        if (!this.m_9236_().f_46443_) {
            if (this.castingSpell != null) {
                this.castingSpell.getSpell().onServerCastComplete(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData, false);
            }
        } else {
            this.playerMagicData.resetCastingState();
        }
        this.castingSpell = null;
    }

    public void setSyncedSpellData(SyncedSpellData syncedSpellData) {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        boolean isCasting = this.playerMagicData.isCasting();
        this.playerMagicData.setSyncedData(syncedSpellData);
        this.castingSpell = this.playerMagicData.getCastingSpell();
        if (this.castingSpell == null) {
            return;
        }
        if (!this.playerMagicData.isCasting() && isCasting) {
            this.castComplete();
        } else if (this.playerMagicData.isCasting() && !isCasting) {
            AbstractSpell spell = this.playerMagicData.getCastingSpell().getSpell();
            this.initiateCastSpell(spell, this.playerMagicData.getCastingSpellLevel());
            if (this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                this.instantCastSpellType = this.castingSpell.getSpell();
                this.castingSpell.getSpell().onClientPreCast(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this, InteractionHand.MAIN_HAND, this.playerMagicData);
                this.castComplete();
            }
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.recreateSpell) {
            this.recreateSpell = false;
            SyncedSpellData syncedSpellData = this.playerMagicData.getSyncedData();
            this.setSyncedSpellData(syncedSpellData);
        }
        if (this.castingSpell == null) {
            return;
        }
        this.playerMagicData.handleCastDuration();
        if (this.playerMagicData.isCasting()) {
            this.castingSpell.getSpell().onServerCastTick(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
        }
        this.forceLookAtTarget(this.m_5448_());
        if (this.playerMagicData.getCastDurationRemaining() <= 0) {
            if (this.castingSpell.getSpell().getCastType() == CastType.LONG || this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                this.castingSpell.getSpell().onCast(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this, CastSource.MOB, this.playerMagicData);
            }
            this.castComplete();
        } else if (this.castingSpell.getSpell().getCastType() == CastType.CONTINUOUS && (this.playerMagicData.getCastDurationRemaining() + 1) % 10 == 0) {
            this.castingSpell.getSpell().onCast(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this, CastSource.MOB, this.playerMagicData);
        }
    }

    public void initiateCastSpell(AbstractSpell spell, int spellLevel) {
        if (spell == SpellRegistry.none()) {
            this.castingSpell = null;
            return;
        }
        if (this.m_9236_().f_46443_) {
            this.cancelCastAnimation = false;
        }
        this.castingSpell = new SpellData(spell, spellLevel);
        if (this.m_5448_() != null) {
            this.forceLookAtTarget(this.m_5448_());
        }
        if (!this.m_9236_().f_46443_ && !this.castingSpell.getSpell().checkPreCastConditions(this.m_9236_(), spellLevel, (LivingEntity)this, this.playerMagicData)) {
            this.castingSpell = null;
            return;
        }
        if (spell == SpellRegistry.TELEPORT_SPELL.get() || spell == SpellRegistry.FROST_STEP_SPELL.get()) {
            this.setTeleportLocationBehindTarget(10);
        } else if (spell == SpellRegistry.BLOOD_STEP_SPELL.get()) {
            this.setTeleportLocationBehindTarget(3);
        } else if (spell == SpellRegistry.BURNING_DASH_SPELL.get()) {
            this.setBurningDashDirectionData();
        }
        this.playerMagicData.initiateCast(this.castingSpell.getSpell(), this.castingSpell.getLevel(), this.castingSpell.getSpell().getEffectiveCastTime(this.castingSpell.getLevel(), (LivingEntity)this), CastSource.MOB, SpellSelectionManager.MAINHAND);
        if (!this.m_9236_().f_46443_) {
            this.castingSpell.getSpell().onServerPreCast(this.m_9236_(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
        }
    }

    public void notifyDangerousProjectile(Projectile projectile) {
    }

    public boolean isCasting() {
        return this.playerMagicData.isCasting();
    }

    public boolean setTeleportLocationBehindTarget(int distance) {
        LivingEntity target = this.m_5448_();
        boolean valid = false;
        if (target != null) {
            Vec3 rotation = target.m_20154_().m_82541_().m_82490_((double)(-distance));
            Vec3 pos = target.m_20182_();
            Vec3 teleportPos = rotation.m_82549_(pos);
            for (int i = 0; i < 24; ++i) {
                Vec3 randomness = Utils.getRandomVec3((double)(0.15f * (float)i)).m_82542_(1.0, 0.0, 1.0);
                teleportPos = Utils.moveToRelativeGroundLevel((Level)this.m_9236_(), (Vec3)target.m_20182_().m_82546_(new Vec3(0.0, 0.0, (double)((float)distance / (float)(i / 7 + 1))).m_82524_(-(target.m_146908_() + (float)(i * 45)) * ((float)Math.PI / 180))).m_82549_(randomness), (int)5);
                teleportPos = new Vec3(teleportPos.f_82479_, teleportPos.f_82480_ + (double)0.1f, teleportPos.f_82481_);
                AABB reposBB = this.m_20191_().m_82383_(teleportPos.m_82546_(this.m_20182_()));
                if (this.m_9236_().m_186437_((Entity)this, reposBB.m_82400_((double)-0.05f))) continue;
                valid = true;
                break;
            }
            if (valid) {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(teleportPos));
            } else {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.m_20182_()));
            }
        } else {
            this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.m_20182_()));
        }
        return valid;
    }

    public void setBurningDashDirectionData() {
        this.playerMagicData.setAdditionalCastData((ICastData)new BurningDashSpell.BurningDashDirectionOverrideCastData());
    }

    protected void forceLookAtTarget(LivingEntity target) {
        if (target != null) {
            double d0 = target.m_20185_() - this.m_20185_();
            double d2 = target.m_20189_() - this.m_20189_();
            double d1 = target.m_20188_() - this.m_20188_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
            this.m_146926_(f1 % 360.0f);
            this.m_146922_(f % 360.0f);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{this.animationControllerInstantCast});
        controllerRegistrar.add(new AnimationController[]{this.animationControllerLongCast});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle", 0, this::idlePredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "interact_controller", state -> PlayState.STOP).triggerableAnim("interact", this.interact)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "spawn_controller", state -> PlayState.STOP).triggerableAnim("spawn", this.spawn)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "block_controller", state -> PlayState.STOP).triggerableAnim("block", this.attack)});
    }

    protected PlayState idlePredicate(AnimationState event) {
        if (this.isAnimating()) {
            return PlayState.STOP;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(this.walk);
            return PlayState.CONTINUE;
        }
        if (!event.isMoving()) {
            event.getController().setAnimation(this.idle);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected PlayState instantCastingPredicate(AnimationState event) {
        if (this.cancelCastAnimation) {
            return PlayState.STOP;
        }
        AnimationController controller = event.getController();
        if (this.instantCastSpellType != SpellRegistry.none() && controller.getAnimationState() == AnimationController.State.STOPPED) {
            this.setStartAnimationFromSpell(controller, this.instantCastSpellType);
            this.instantCastSpellType = SpellRegistry.none();
        }
        return PlayState.CONTINUE;
    }

    protected PlayState longCastingPredicate(AnimationState event) {
        AnimationController controller = event.getController();
        if (this.cancelCastAnimation || controller.getAnimationState() == AnimationController.State.STOPPED && (!this.isCasting() || this.castingSpell == null || this.castingSpell.getSpell().getCastType() != CastType.LONG)) {
            return PlayState.STOP;
        }
        if (this.isCasting() && controller.getAnimationState() == AnimationController.State.STOPPED) {
            this.setStartAnimationFromSpell(controller, this.castingSpell.getSpell());
        }
        return PlayState.CONTINUE;
    }

    protected void setStartAnimationFromSpell(AnimationController controller, AbstractSpell spell) {
        spell.getCastStartAnimation().getForMob().ifPresentOrElse(animationBuilder -> {
            controller.forceAnimationReset();
            if (PetAnimationUtils.isLongAnimCast(spell)) {
                controller.setAnimation(this.longCast);
            } else if (spell == SpellRegistry.STOMP_SPELL.get()) {
                controller.setAnimation(this.stomp);
            } else {
                controller.setAnimation(this.attack);
            }
            this.lastCastSpellType = spell;
            this.cancelCastAnimation = false;
            this.animatingLegs = false;
        }, () -> {
            this.cancelCastAnimation = true;
        });
    }

    public boolean isAnimating() {
        return this.isCasting() || this.animationControllerLongCast.getAnimationState() != AnimationController.State.STOPPED || this.animationControllerInstantCast.getAnimationState() != AnimationController.State.STOPPED;
    }

    public boolean shouldAlwaysAnimateHead() {
        return false;
    }

    public boolean shouldPointArmsWhileCasting() {
        return false;
    }

    public boolean shouldBeExtraAnimated() {
        return true;
    }

    public boolean shouldAlwaysAnimateLegs() {
        return !this.animatingLegs;
    }

    public boolean bobBodyWhileWalking() {
        return true;
    }

    public boolean shouldSheathSword() {
        return false;
    }

    static {
        DATA_ID_OWNER_UUID = SynchedEntityData.m_135353_(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
        DATA_BLOCKING = SynchedEntityData.m_135353_(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        DATA_ENRAGED = SynchedEntityData.m_135353_(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_ARMOR = SynchedEntityData.m_135353_(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_HEALTH = SynchedEntityData.m_135353_(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        DATA_IS_SITTING = SynchedEntityData.m_135353_(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }

    public class TeleportToOwnerGoal
    extends Goal {
        private final AbstractSpellCastingPet mob;
        @Nullable
        private LivingEntity owner;
        private Supplier<LivingEntity> ownerGetter;
        private float teleportDistance;

        public TeleportToOwnerGoal(AbstractSpellCastingPet pTamable, Supplier<LivingEntity> ownerGetter, float teleportDistance) {
            this.mob = pTamable;
            this.ownerGetter = ownerGetter;
            this.teleportDistance = teleportDistance;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.ownerGetter.get();
            if (livingentity == null) {
                return false;
            }
            if (this.mob.m_20280_((Entity)livingentity) < (double)(this.teleportDistance * this.teleportDistance)) {
                return false;
            }
            if (this.mob.getIsSitting().booleanValue()) {
                return false;
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8037_() {
            this.teleportToOwner();
        }

        private void teleportToOwner() {
            BlockPos blockpos = this.owner.m_20183_();
            for (int i = 0; i < 10; ++i) {
                int j = this.randomIntInclusive(-3, 3);
                int k = this.randomIntInclusive(-1, 1);
                int l = this.randomIntInclusive(-3, 3);
                boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
                if (!flag) continue;
                return;
            }
        }

        private boolean maybeTeleportTo(int pX, int pY, int pZ) {
            if (Math.abs((double)pX - this.owner.m_20185_()) < 2.0 && Math.abs((double)pZ - this.owner.m_20189_()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new BlockPos(pX, pY, pZ))) {
                return false;
            }
            this.mob.m_7678_((double)pX + 0.5, (double)pY + (double)(!this.mob.m_20096_() ? 3 : 0), (double)pZ + 0.5, this.mob.m_146908_(), this.mob.m_146909_());
            return true;
        }

        private boolean canTeleportTo(BlockPos pPos) {
            BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.mob.m_9236_(), (BlockPos.MutableBlockPos)pPos.m_122032_());
            if (blockpathtypes != BlockPathTypes.WALKABLE) {
                return false;
            }
            BlockState blockstate = this.mob.m_9236_().m_8055_(pPos.m_7495_());
            if (blockstate.m_60734_() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockpos = pPos.m_121996_((Vec3i)this.mob.m_20183_());
            return this.mob.m_9236_().m_45756_((Entity)this.mob, this.mob.m_20191_().m_82338_(blockpos));
        }

        private int randomIntInclusive(int pMin, int pMax) {
            return this.mob.m_217043_().m_188503_(pMax - pMin + 1) + pMin;
        }
    }

    protected class ApplyRandomEffectGoal
    extends Goal {
        private final AbstractSpellCastingPet entity;
        private Entity owner;
        private final Supplier<Entity> ownerGetter;
        private final List<MobEffectInstance> effectHolders;
        private final int interval;
        private int tickCounter;

        public ApplyRandomEffectGoal(AbstractSpellCastingPet entity, Supplier<Entity> owner, List<MobEffectInstance> effectHolders, int interval) {
            this.entity = entity;
            this.ownerGetter = owner;
            this.effectHolders = effectHolders;
            this.interval = interval;
            this.tickCounter = 0;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            Entity livingentity = this.ownerGetter.get();
            if (livingentity == null) {
                return false;
            }
            if (this.entity.m_20280_(livingentity) > 400.0) {
                return false;
            }
            this.owner = livingentity;
            return ++this.tickCounter >= this.interval;
        }

        public void m_8056_() {
            this.tickCounter = 0;
            AbstractSpellCastingPet.this.triggerAnim("interact_controller", "interact");
            int randomIndex = ThreadLocalRandom.current().nextInt(this.effectHolders.size());
            AbstractSpellCastingPet.this.triggerAnim("interact_controller", "interact");
            Entity entity = this.owner;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(this.effectHolders.get(randomIndex));
            }
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }
    }
}

