/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.misc.IllusionistDecoy;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class IllusionistPetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/illusionist_pet.png");

    public IllusionistPetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 40, 60).setSpells(List.of((AbstractSpell)SpellRegistry.FANG_STRIKE_SPELL.get(), (AbstractSpell)SpellRegistry.GUST_SPELL.get(), (AbstractSpell)SpellRegistry.LOB_CREEPER_SPELL.get(), (AbstractSpell)SpellRegistry.FIRECRACKER_SPELL.get()), List.of((AbstractSpell)SpellRegistry.FANG_WARD_SPELL.get(), (AbstractSpell)SpellRegistry.CHAIN_CREEPER_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.INVISIBILITY_SPELL.get(), (AbstractSpell)SpellRegistry.SLOW_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.SUMMON_VEX_SPELL.get(), 2000, 3000, 1, 4));
        this.f_21345_.m_25352_(2, (Goal)new DecoyGoal(this, 200));
    }

    @Override
    protected void clearMovementGoals() {
        super.clearMovementGoals();
        this.f_21345_.m_262460_(goal -> goal instanceof WizardAttackGoal || goal instanceof DecoyGoal);
    }

    @Override
    protected void restoreMovementGoals() {
        super.restoreMovementGoals();
        this.f_21345_.m_25352_(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 40, 60).setSpells(List.of((AbstractSpell)SpellRegistry.FANG_STRIKE_SPELL.get(), (AbstractSpell)SpellRegistry.GUST_SPELL.get(), (AbstractSpell)SpellRegistry.LOB_CREEPER_SPELL.get(), (AbstractSpell)SpellRegistry.FIRECRACKER_SPELL.get()), List.of((AbstractSpell)SpellRegistry.FANG_WARD_SPELL.get(), (AbstractSpell)SpellRegistry.CHAIN_CREEPER_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.INVISIBILITY_SPELL.get(), (AbstractSpell)SpellRegistry.SLOW_SPELL.get())).setSingleUseSpell((AbstractSpell)SpellRegistry.SUMMON_VEX_SPELL.get(), 2000, 3000, 1, 4));
        this.f_21345_.m_25352_(2, (Goal)new DecoyGoal(this, 200));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.3);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.m_150930_(Items.f_42587_);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getSummoner() != null && this.f_19797_ % 5 == 0 && (double)this.getSummoner().m_21223_() < (double)this.getSummoner().m_21233_() * 0.25 && this.horizontalDistanceSqr(this.getSummoner(), this.m_20182_()) < 400.0f) {
            if (this.getSummoner().m_21023_((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get())) {
                if (this.getSummoner().m_21124_((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get()).m_19557_() < 500) {
                    this.getSummoner().m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get(), 500 - this.getSummoner().m_21124_((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get()).m_19557_(), 0, false, false, true));
                }
            } else {
                this.getSummoner().m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get(), 500, 0, false, false, true));
            }
        }
    }

    private float horizontalDistanceSqr(LivingEntity livingEntity, Vec3 vec3) {
        double dx = livingEntity.m_20185_() - vec3.f_82479_;
        double dz = livingEntity.m_20189_() - vec3.f_82481_;
        return (float)(dx * dx + dz * dz);
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.EVOCATION.get()).getTargetingColor(), 2.0f), (double)this.m_20185_(), (double)(this.m_20186_() + (double)0.165f), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    protected class DecoyGoal
    extends Goal {
        private final AbstractSpellCastingPet pet;
        private final int interval;
        private int tickCounter;

        public DecoyGoal(AbstractSpellCastingPet pet, int interval) {
            this.pet = pet;
            this.interval = interval;
            this.tickCounter = 0;
        }

        public boolean m_8036_() {
            return ++this.tickCounter >= this.interval && this.pet.m_21223_() <= this.pet.m_21233_() / 2.0f;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            this.tickCounter = 0;
            IllusionistPetEntity.this.triggerAnim("interact_controller", "interact");
            Level level = this.pet.m_9236_();
            if (level.f_46443_) {
                return;
            }
            this.pet.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get(), 100, 0, false, false, true));
            this.pet.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 5, false, false, true));
            IllusionistDecoy decoy = new IllusionistDecoy(this.pet.m_9236_(), (LivingEntity)this.pet);
            decoy.m_20219_(this.pet.m_20182_());
            decoy.m_146922_(this.pet.m_146908_());
            this.pet.m_9236_().m_7967_((Entity)decoy);
        }
    }
}

