/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import net.alshanex.alshanex_familiars.entity.generic.AbstractSpellCastingPet;
import net.alshanex.alshanex_familiars.entity.generic.AbstractTerrestrianSpellCastingPet;
import net.alshanex.alshanex_familiars.registry.ItemRegistry;
import net.alshanex.alshanex_familiars.util.ModTags;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;

public class HunterPetEntity
extends AbstractTerrestrianSpellCastingPet {
    public static final ResourceLocation textureResource = new ResourceLocation("alshanex_familiars", "textures/entity/hunter_pet.png");

    public HunterPetEntity(EntityType<? extends AbstractTerrestrianSpellCastingPet> pEntityType, Level pLevel) {
        super((EntityType<? extends AbstractSpellCastingPet>)pEntityType, pLevel);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 30, 40).setSpells(List.of((AbstractSpell)SpellRegistry.MAGIC_ARROW_SPELL.get(), (AbstractSpell)SpellRegistry.STOMP_SPELL.get(), (AbstractSpell)SpellRegistry.FIRECRACKER_SPELL.get(), (AbstractSpell)SpellRegistry.FIREBOLT_SPELL.get(), (AbstractSpell)SpellRegistry.POISON_ARROW_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get()), List.of()).setSingleUseSpell((AbstractSpell)SpellRegistry.ARROW_VOLLEY_SPELL.get(), 150, 300, 3, 6));
        this.f_21346_.m_25352_(4, (Goal)new TargetAttackerOfPlayersGoal(this, this::getSummoner));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.4);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
    }

    @Override
    protected boolean isFood(ItemStack item) {
        return item.getFoodProperties((LivingEntity)this) != null && item.getFoodProperties((LivingEntity)this).m_38746_();
    }

    @Override
    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.getSummoner() != null) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.EVOCATION.get()).getTargetingColor(), 2.0f), (double)this.m_20185_(), (double)(this.m_20186_() + (double)0.165f), (double)this.m_20189_(), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
        }
    }

    @Override
    protected void clearMovementGoals() {
        super.clearMovementGoals();
        this.f_21345_.m_262460_(goal -> goal instanceof WizardAttackGoal || goal instanceof TargetAttackerOfPlayersGoal || goal instanceof NearestAttackableTargetGoal);
    }

    @Override
    protected void restoreMovementGoals() {
        super.restoreMovementGoals();
        this.f_21345_.m_25352_(2, (Goal)new WizardAttackGoal((IMagicEntity)this, 1.0, 30, 40).setSpells(List.of((AbstractSpell)SpellRegistry.MAGIC_ARROW_SPELL.get(), (AbstractSpell)SpellRegistry.STOMP_SPELL.get(), (AbstractSpell)SpellRegistry.FIRECRACKER_SPELL.get(), (AbstractSpell)SpellRegistry.FIREBOLT_SPELL.get(), (AbstractSpell)SpellRegistry.POISON_ARROW_SPELL.get()), List.of(), List.of((AbstractSpell)SpellRegistry.BLOOD_STEP_SPELL.get()), List.of()).setSingleUseSpell((AbstractSpell)SpellRegistry.ARROW_VOLLEY_SPELL.get(), 150, 300, 3, 6));
        this.f_21346_.m_25352_(4, (Goal)new TargetAttackerOfPlayersGoal(this, this::getSummoner));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.getSummoner() != null && this.getSummoner().m_7306_((Entity)player) && itemstack.m_150930_(Items.f_42398_)) {
            this.setSitting(this.getIsSitting() == false);
            return InteractionResult.SUCCESS;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.getOwnerUUID() != null) {
                if (this.getOwnerUUID().equals(player.m_20148_())) {
                    this.triggerAnim("interact_controller", "interact");
                    if (itemstack.m_150930_((Item)ItemRegistry.BLUEBERRY.get())) {
                        itemstack.m_41774_(1);
                        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.MEMORY_FRAGMENT.get());
                        this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), stack));
                        if (this.m_21223_() < this.m_21233_()) {
                            this.m_5634_(4.0f);
                            this.m_146850_(GameEvent.f_157806_);
                        }
                        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                    }
                    if (this.isFood(itemstack) && this.m_21223_() < this.m_21233_()) {
                        this.m_5634_(4.0f);
                        itemstack.m_41774_(1);
                        this.spawnEatingParticles();
                        this.m_146850_(GameEvent.f_157806_);
                        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                    }
                    if (itemstack != ItemStack.f_41583_) {
                        Item heldItem = itemstack.m_41720_();
                        AABB searchArea = this.m_20191_().m_82400_(20.0);
                        List nearbyEntities = this.m_9236_().m_6249_((Entity)this, searchArea, entity -> entity instanceof LivingEntity && this.canDropItem((ServerLevel)this.m_9236_(), (Entity)entity, heldItem));
                        for (Entity entity2 : nearbyEntities) {
                            if (!(entity2 instanceof LivingEntity)) continue;
                            LivingEntity livingEntity = (LivingEntity)entity2;
                            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 200, 0, false, true));
                        }
                        return super.m_6071_(player, hand);
                    }
                }
            } else if (itemstack.m_204117_(ModTags.FAMILIAR_TAMING)) {
                itemstack.m_41774_(1);
                this.tryToTame(player);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    private boolean canDropItem(ServerLevel level, Entity entity, Item searchItem) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ResourceLocation lootTableId = livingEntity.m_5743_();
        if (lootTableId == null) {
            return false;
        }
        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(lootTableId);
        LootParams params = new LootParams.Builder(level).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)level.m_269111_().m_269264_()).m_287235_(LootContextParamSets.f_81415_);
        ObjectArrayList generatedItems = lootTable.m_287195_(params);
        return generatedItems.stream().anyMatch(stack -> stack.m_41720_() == searchItem);
    }

    public class TargetAttackerOfPlayersGoal
    extends TargetGoal {
        private final AbstractSpellCastingPet pet;
        private final Supplier<LivingEntity> owner;
        private LivingEntity target;

        public TargetAttackerOfPlayersGoal(AbstractSpellCastingPet pet, Supplier<LivingEntity> owner) {
            super((Mob)pet, true);
            this.pet = pet;
            this.owner = owner;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            LivingEntity getOwner = this.owner.get();
            if (getOwner == null) {
                return false;
            }
            Level level = this.pet.m_9236_();
            List nearbyEntities = level.m_6443_(LivingEntity.class, this.pet.m_20191_().m_82400_(15.0), entity -> {
                Mob mob;
                return entity instanceof Mob && (mob = (Mob)entity).m_5448_() == getOwner;
            });
            if (!nearbyEntities.isEmpty()) {
                this.target = nearbyEntities.stream().findFirst().orElse(null);
                return true;
            }
            return false;
        }

        public void m_8056_() {
            this.pet.m_6710_(this.target);
            this.pet.m_6274_().m_21882_(MemoryModuleType.f_26372_, (Object)this.target, 200L);
            super.m_8056_();
        }
    }
}

