/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.alshanex_familiars.compat;

import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.alshanex.alshanex_familiars.compat.RitualRecipeJei;
import net.alshanex.alshanex_familiars.recipe_types.RitualRecipeType;
import net.alshanex.alshanex_familiars.registry.BlockRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import oshi.util.tuples.Pair;

public class RitualRecipeCategory
implements IRecipeCategory<RitualRecipeJei> {
    public static final ResourceLocation UID = new ResourceLocation("alshanex_familiars", "ritual_casting");
    public static final ResourceLocation TEXTURE = new ResourceLocation("alshanex_familiars", "textures/gui/ritual_recipe_gui.png");
    public static final RecipeType<RitualRecipeJei> RITUAL_RECIPE_TYPE = RecipeType.create((String)"alshanex_familiars", (String)"ritual_recipe", RitualRecipeJei.class);
    private final IDrawable background;
    private final IDrawable icon;
    private static final List<Pair<Integer, Integer>> INPUT_COORDINATES = List.of(new Pair((Object)80, (Object)11), new Pair((Object)50, (Object)41), new Pair((Object)110, (Object)41), new Pair((Object)80, (Object)71));
    private static final Pair<Integer, Integer> CENTER_COORDINATES = new Pair((Object)80, (Object)41);
    private static final Pair<Integer, Integer> OUTPUT_COORDINATES = new Pair((Object)80, (Object)116);

    public RitualRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 146);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.RITUAL_CORE.get()));
    }

    public RecipeType<RitualRecipeJei> getRecipeType() {
        return RITUAL_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"ui.alshanex_familiars.ritual_recipe_jei");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RitualRecipeJei recipe, IFocusGroup focusGroup) {
        List<RitualRecipeType.RitualIngredient> inputs = recipe.inputItems();
        int ingredientsToShow = Math.min(inputs.size(), INPUT_COORDINATES.size());
        for (int i = 0; i < ingredientsToShow; ++i) {
            RitualRecipeType.RitualIngredient input = inputs.get(i);
            Pair<Integer, Integer> coordinates = INPUT_COORDINATES.get(i);
            IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, ((Integer)coordinates.getA()).intValue(), ((Integer)coordinates.getB()).intValue()).addItemStack(new ItemStack((ItemLike)input.item(), input.count()));
            if (input.consume()) continue;
            slot.addTooltipCallback((view, tooltip) -> tooltip.add(Component.m_237115_((String)"tooltip.alshanex_familiars.not_consumed").m_130940_(ChatFormatting.RED)));
        }
        builder.addSlot(RecipeIngredientRole.INPUT, ((Integer)CENTER_COORDINATES.getA()).intValue(), ((Integer)CENTER_COORDINATES.getB()).intValue()).addIngredients(recipe.centralItem());
        builder.addSlot(RecipeIngredientRole.OUTPUT, ((Integer)OUTPUT_COORDINATES.getA()).intValue(), ((Integer)OUTPUT_COORDINATES.getB()).intValue()).addItemStack(recipe.result());
    }
}

