/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me;

import com.ibm.asyncutil.util.Combinators;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.api.ModInitializer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class C2MEMod
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"C2ME");

    public void onInitialize() {
        if (Boolean.getBoolean("com.ishland.c2me.runCompressionBenchmark")) {
            LOGGER.info("Benchmarking chunk stream speed");
            LOGGER.info("Warming up");
            for (int i = 0; i < 3; ++i) {
                this.runBenchmark("GZIP", RegionFileVersion.f_63743_, true);
                this.runBenchmark("DEFLATE", RegionFileVersion.f_63744_, true);
                this.runBenchmark("UNCOMPRESSED", RegionFileVersion.f_63745_, true);
            }
            this.runBenchmark("GZIP", RegionFileVersion.f_63743_, false);
            this.runBenchmark("DEFLATE", RegionFileVersion.f_63744_, false);
            this.runBenchmark("UNCOMPRESSED", RegionFileVersion.f_63745_, false);
        }
        if (Boolean.getBoolean("com.ishland.c2me.runConsistencyTest")) {
            this.consistencyTest();
        }
    }

    private void runBenchmark(String name, RegionFileVersion version, boolean suppressLog) {
        try {
            DecimalFormat decimalFormat = new DecimalFormat("0.###");
            if (!suppressLog) {
                LOGGER.info("Generating 128MB random data");
            }
            byte[] bytes = new byte[0x8000000];
            new Random().nextBytes(bytes);
            if (!suppressLog) {
                LOGGER.info("Starting benchmark for {}", (Object)name);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            OutputStream wrappedOutputStream = version.m_63762_((OutputStream)outputStream);
            long startTime = System.nanoTime();
            wrappedOutputStream.write(bytes);
            wrappedOutputStream.close();
            long endTime = System.nanoTime();
            if (!suppressLog) {
                LOGGER.info("{} write speed: {} MB/s ({} MB/s compressed)", new Object[]{name, decimalFormat.format((double)bytes.length / 1024.0 / 1024.0 / ((double)(endTime - startTime) / 1.0E9)), decimalFormat.format((double)outputStream.size() / 1024.0 / 1024.0 / ((double)(endTime - startTime) / 1.0E9))});
            }
            if (!suppressLog) {
                LOGGER.info("{} compression ratio: {} %", (Object)name, (Object)decimalFormat.format((double)outputStream.size() / (double)bytes.length * 100.0));
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            InputStream wrappedInputStream = version.m_63760_((InputStream)inputStream);
            long startTime2 = System.nanoTime();
            byte[] readAllBytes = wrappedInputStream.readAllBytes();
            wrappedInputStream.close();
            long endTime2 = System.nanoTime();
            if (!suppressLog) {
                LOGGER.info("{} read speed: {} MB/s ({} MB/s compressed)", new Object[]{name, decimalFormat.format((double)readAllBytes.length / 1024.0 / 1024.0 / ((double)(endTime2 - startTime2) / 1.0E9)), decimalFormat.format((double)outputStream.size() / 1024.0 / 1024.0 / ((double)(endTime2 - startTime2) / 1.0E9))});
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void consistencyTest() {
        int taskSize = 512;
        AtomicIntegerArray array = new AtomicIntegerArray(taskSize);
        List<CompletableFuture> futures = IntStream.range(0, taskSize).mapToObj(value -> CompletableFuture.supplyAsync(() -> {
            WorldgenRandom chunkRandom = new WorldgenRandom((RandomSource)new SingleThreadedRandomSource(System.nanoTime()));
            chunkRandom.m_190110_(4096);
            int i = chunkRandom.m_188502_();
            array.set(value, i);
            return i;
        })).toList();
        List join = (List)Combinators.collect(futures, Collectors.toList()).toCompletableFuture().join();
        for (int i = 0; i < taskSize; ++i) {
            if (array.get(i) == ((Integer)join.get(i)).intValue()) continue;
            throw new IllegalArgumentException("Mismatch at index " + i);
        }
    }
}

