/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.infoScreen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.faewulf.lib.util.config.Config;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;
import xyz.faewulf.lib.util.config.infoScreen.rainITem;

public class ModInfoScreen
extends Screen {
    private final String MOD_ID;
    private final ResourceLocation MAIN_IMAGE;
    private final ResourceLocation LIGHT_RAYS;
    private final Screen parent;
    private final Minecraft client;
    private final List<rainITem> fallingEntities = new ArrayList<rainITem>();
    public final ResourceLocation ATLAS_TEXTURE;
    private final int ATLAS_SIZE = 96;
    private final int TILE_SIZE = 32;
    private int[][] tileMap;
    private int tilesX;
    private int tilesY;
    private final float logo_offset_Y = 20.0f;
    private final ResourceLocation ICON_DISCORD;
    private final ResourceLocation ICON_KOFI;
    private final ResourceLocation ICON_GITHUB;
    private String URL_GITHUB = "https://github.com/FaeWulf";
    private String URL_WEBSITE = "https://faewulf.xyz/";
    private String URL_DONATE = "https://ko-fi.com/faewulf";
    private String URL_DISCORD = "https://faewulf.xyz/discord";
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 100, 60);
    private GridLayout contentLayout;
    private GridLayout footerLayout;
    private Button settingButton;
    private float time = 0.0f;

    protected ModInfoScreen(Screen parent, String MOD_ID) {
        super((Component)Component.m_237113_((String)"Info"));
        this.parent = parent;
        this.client = Minecraft.m_91087_();
        this.tilesX = (int)Math.ceil((float)this.f_96543_ * 1.0f / 32.0f);
        this.tilesY = (int)Math.ceil((float)this.f_96544_ * 1.0f / 32.0f);
        this.tileMap = new int[this.tilesX][this.tilesY];
        this.MOD_ID = MOD_ID;
        this.MAIN_IMAGE = ResourceLocation.m_214293_((String)MOD_ID, (String)"textures/gui/d.png");
        this.LIGHT_RAYS = ResourceLocation.m_214293_((String)MOD_ID, (String)"textures/gui/light_rays.png");
        this.ATLAS_TEXTURE = ResourceLocation.m_214293_((String)MOD_ID, (String)"textures/gui/atlas_background.png");
        this.ICON_DISCORD = ResourceLocation.m_214293_((String)MOD_ID, (String)"textures/gui/sprites/icon/discord.png");
        this.ICON_KOFI = ResourceLocation.m_214293_((String)MOD_ID, (String)"textures/gui/sprites/icon/kofi.png");
        this.ICON_GITHUB = ResourceLocation.m_214293_((String)MOD_ID, (String)"textures/gui/sprites/icon/github.png");
    }

    public static ModInfoScreen getScreen(Screen parent, String MOD_ID) {
        return new ModInfoScreen(parent, MOD_ID);
    }

    public void setUrls(@Nullable String discord, @Nullable String website, @Nullable String donate, @Nullable String sourcecode) {
        if (discord != null) {
            this.URL_DISCORD = discord;
        }
        if (sourcecode != null) {
            this.URL_GITHUB = sourcecode;
        }
        if (website != null) {
            this.URL_WEBSITE = website;
        }
        if (donate != null) {
            this.URL_DONATE = donate;
        }
    }

    protected void m_7856_() {
        this.generateRandomTileMap();
        Config.reloadConfig(this.MOD_ID);
        for (int i = 0; i < 25; ++i) {
            int texture = i % 9;
            float x = (float)(Math.random() * (double)this.f_96543_);
            float y = (float)(Math.random() * (double)this.f_96544_);
            float velocityX = (float)(Math.random() * 1.0) - 0.5f;
            float velocityY = 1.0f + (float)(Math.random() * 1.0);
            float rotationSpeed = (float)(Math.random() * 14.0 - 7.0);
            this.fallingEntities.add(new rainITem(texture, x, y, velocityX, velocityY, rotationSpeed, this.f_96543_, this.f_96544_));
        }
        this.contentLayout = new GridLayout();
        this.footerLayout = new GridLayout();
        GridLayout.RowHelper rowHelper = this.contentLayout.m_264606_(1);
        rowHelper.m_264502_().m_264174_(4).m_264356_();
        this.settingButton = (Button)rowHelper.m_264139_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)(this.MOD_ID + ".info.configurations")), button -> this.client.m_91152_(ConfigScreen.getScreen(this, this.MOD_ID))).m_253136_());
        if (ConfigLoaderFromAnnotation.loadConfig(this.MOD_ID).isEmpty()) {
            this.settingButton.f_93623_ = false;
        }
        GridLayout.RowHelper rowHelperFooterLayout = this.footerLayout.m_264606_(5);
        rowHelperFooterLayout.m_264502_().m_264356_().m_264174_(2);
        rowHelperFooterLayout.m_264139_((LayoutElement)Button.m_253074_((Component)Component.m_237113_((String)"\ud83c\udf10"), button -> this.openWebLink(this.URL_WEBSITE)).m_252780_(20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.MOD_ID + ".info.website.tooltip")))).m_253136_());
        ImageButton iconButton = new ImageButton(20, 20, 20, 20, 0, 0, 20, this.ICON_KOFI, 32, 64, button -> this.openWebLink(this.URL_DONATE));
        iconButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.MOD_ID + ".info.kofi.tooltip"))));
        rowHelperFooterLayout.m_264108_((LayoutElement)iconButton, 1);
        rowHelperFooterLayout.m_264108_((LayoutElement)Button.m_253074_((Component)Component.m_237113_((String)"Close"), button -> this.m_7379_()).m_252780_(100).m_253136_(), 1);
        iconButton = new ImageButton(20, 20, 20, 20, 0, 0, 20, this.ICON_DISCORD, 32, 64, button -> this.openWebLink(this.URL_DISCORD));
        iconButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.MOD_ID + ".info.discord.tooltip"))));
        rowHelperFooterLayout.m_264108_((LayoutElement)iconButton, 1);
        iconButton = new ImageButton(20, 20, 20, 20, 0, 0, 20, this.ICON_GITHUB, 32, 64, button -> this.openWebLink(this.URL_GITHUB));
        iconButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.MOD_ID + ".info.github.tooltip"))));
        rowHelperFooterLayout.m_264108_((LayoutElement)iconButton, 1);
        this.layout.m_268999_((LayoutElement)this.contentLayout);
        this.layout.m_269281_((LayoutElement)this.footerLayout);
        this.layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.m_267719_();
    }

    public void m_86600_() {
        super.m_86600_();
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        this.randomShtShowering(guiGraphics, delta);
        guiGraphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1442840576, Integer.MIN_VALUE);
        this.time += delta * 0.05f;
        this.drawLightRays(guiGraphics);
        this.drawWobblingImage(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        this.drawRandomTiledBackground(guiGraphics);
    }

    private void drawLightRays(GuiGraphics guiGraphics) {
        int centerX = this.f_96543_ / 2;
        int centerY = (int)(((float)this.layout.m_269355_() + 20.0f) / 2.0f);
        int size = 128;
        float rotationAngle = this.time * 20.0f;
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        float wobbleOffsetY = (float)Math.sin(this.time) * 5.0f;
        matrixStack.m_252880_((float)centerX, (float)centerY + wobbleOffsetY, 0.0f);
        matrixStack.m_252781_(Axis.f_252403_.m_252977_(rotationAngle));
        guiGraphics.m_280168_().m_252880_((float)(-size) / 2.0f, (float)(-size) / 2.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(this.LIGHT_RAYS, 0, 0, 0.0f, 0.0f, size, size, size, size);
        RenderSystem.disableBlend();
        matrixStack.m_85849_();
    }

    private void drawWobblingImage(GuiGraphics guiGraphics) {
        int imageSize = 64;
        int centerX = this.f_96543_ / 2;
        int centerY = (int)(((float)this.layout.m_269355_() + 20.0f) / 2.0f);
        float wobbleOffsetY = (float)Math.sin(this.time) * 5.0f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)centerX, (float)centerY + wobbleOffsetY, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(this.MAIN_IMAGE, -imageSize / 2, -imageSize / 2, 0.0f, 0.0f, imageSize, imageSize, imageSize, imageSize);
        RenderSystem.disableBlend();
        guiGraphics.m_280168_().m_85849_();
    }

    protected void m_267719_() {
        this.tilesX = (int)Math.ceil((float)this.f_96543_ * 1.0f / 32.0f);
        this.tilesY = (int)Math.ceil((float)this.f_96544_ * 1.0f / 32.0f);
        this.tileMap = new int[this.tilesX][this.tilesY];
        this.generateRandomTileMap();
        this.layout.m_264036_();
        this.fallingEntities.forEach(rainITem2 -> rainITem2.updateScreenSize(this.f_96543_, this.f_96544_));
    }

    public void m_7379_() {
        if (this.client != null) {
            this.client.m_91152_(this.parent);
        } else {
            super.m_7379_();
        }
    }

    private void randomShtShowering(GuiGraphics guiGraphics, float delta) {
        for (rainITem entity : this.fallingEntities) {
            entity.update(delta);
            entity.render(guiGraphics, delta);
        }
    }

    private void drawRandomTiledBackground(GuiGraphics guiGraphics) {
        int tilesPerRow = 3;
        for (int y = 0; y < this.tilesY; ++y) {
            for (int x = 0; x < this.tilesX; ++x) {
                int tileIndex = this.tileMap[x][y];
                int tileX = tileIndex % tilesPerRow * 32;
                int tileY = tileIndex / tilesPerRow * 32;
                guiGraphics.m_280163_(this.ATLAS_TEXTURE, x * 32, y * 32, (float)tileX, (float)tileY, 32, 32, 96, 96);
            }
        }
    }

    private void generateRandomTileMap() {
        Random random = new Random();
        int tilesPerRow = 3;
        for (int y = 0; y < this.tilesY; ++y) {
            for (int x = 0; x < this.tilesX; ++x) {
                int tileX = random.nextInt(tilesPerRow);
                int tileY = random.nextInt(tilesPerRow);
                this.tileMap[x][y] = tileY * tilesPerRow + tileX;
            }
        }
    }

    private void openWebLink(String url) {
        this.client.m_91152_((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                Util.m_137581_().m_137646_(url);
            }
            this.client.m_91152_((Screen)this);
        }, url, true));
    }
}

