/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.tabs.TabNavigationBar;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.faewulf.lib.util.config.Config;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigTab;
import xyz.faewulf.lib.util.config.ConfigScreen.ScrollableListWidget;

public class ConfigScreen
extends Screen {
    private final String MOD_ID;
    private final ResourceLocation ATLAS_TEXTURE;
    private final int ATLAS_SIZE = 96;
    private final int TILE_SIZE = 32;
    private int[][] tileMap;
    private int tilesX;
    private int tilesY;
    private final Screen parent;
    private final Minecraft client;
    private static final int RIGHT_TAB_PADDING = 2;
    private Boolean isChanged = false;
    public static Map<String, Object> CONFIG_VALUES = new LinkedHashMap<String, Object>();
    public static List<ConfigLoaderFromAnnotation.EntryInfo> CONFIG_ENTRIES = new ArrayList<ConfigLoaderFromAnnotation.EntryInfo>();
    private final TabManager tabManager = new TabManager(x$0 -> {
        AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
    }, x$0 -> this.m_169411_((GuiEventListener)x$0));
    @Nullable
    private TabNavigationBar tabNavigationBar;
    @Nullable
    private ScrollableListWidget slw;
    @Nullable
    private Tab selectedTab;
    @Nullable
    private GridLayout rightTab;
    public static GridLayout infoTab;
    public static String currentInfo;
    public static boolean updateCall;
    @Nullable
    private EditBox searchBar;
    @Nullable
    private Button ButtonReset_Cancel;
    @Nullable
    private Button ButtonUndo;
    @Nullable
    private Button ButtonDone_Save;
    public static MultiLineTextWidget infoTab_Title;
    public static MultiLineTextWidget infoTab_Info;

    protected ConfigScreen(Screen parent, String MOD_ID) {
        super((Component)Component.m_237115_((String)(MOD_ID + ".config.title")));
        this.parent = parent;
        this.client = Minecraft.m_91087_();
        this.tilesX = (int)Math.ceil((float)this.f_96543_ * 1.0f / 32.0f);
        this.tilesY = (int)Math.ceil((float)this.f_96544_ * 1.0f / 32.0f);
        this.tileMap = new int[this.tilesX][this.tilesY];
        this.MOD_ID = MOD_ID;
        this.ATLAS_TEXTURE = ResourceLocation.m_214293_((String)MOD_ID, (String)"textures/gui/atlas_background.png");
    }

    public static Screen getScreen(Screen parent, String MOD_ID) {
        return new ConfigScreen(parent, MOD_ID);
    }

    protected void m_7856_() {
        CONFIG_ENTRIES.clear();
        CONFIG_VALUES.clear();
        this.generateRandomTileMap();
        Map<String, Map<String, ConfigLoaderFromAnnotation.EntryInfo>> configMap = ConfigLoaderFromAnnotation.loadConfig(this.MOD_ID);
        TabNavigationBar.Builder tabBuilder = TabNavigationBar.m_267630_((TabManager)this.tabManager, (int)this.f_96543_);
        configMap.forEach((s, stringEntryTypeMap) -> {
            ConfigTab configTab = new ConfigTab(this.MOD_ID, (String)s, (Map<String, ConfigLoaderFromAnnotation.EntryInfo>)stringEntryTypeMap);
            if (!configTab.isShouldHideFromConfigScreen()) {
                tabBuilder.m_267824_(new Tab[]{configTab});
            }
        });
        this.tabNavigationBar = tabBuilder.m_267625_();
        this.rightTab = new GridLayout();
        GridLayout.RowHelper rightTabRowHelper = this.rightTab.m_264606_(2);
        rightTabRowHelper.m_264502_().m_264356_().m_264524_().m_264174_(1);
        this.searchBar = (EditBox)rightTabRowHelper.m_264108_((LayoutElement)new EditBox(this.f_96547_, 0, 0, 150, 20, (Component)Component.m_237115_((String)(this.MOD_ID + ".config.searchbar.hint"))), 2);
        this.searchBar.m_257771_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.searchbar.hint")));
        this.searchBar.m_94151_(this::pushList);
        this.ButtonReset_Cancel = (Button)rightTabRowHelper.m_264139_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.reset")), button -> {
            if (this.isChanged.booleanValue()) {
                this.undoConfig();
                this.m_7379_();
                return;
            }
            Map<String, Object> defaultValue = ConfigLoaderFromAnnotation.getAllDefaultValues(this.MOD_ID);
            CONFIG_ENTRIES.forEach(entryInfo -> {
                try {
                    entryInfo.targetField.set(null, defaultValue.get(entryInfo.name));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }).m_252780_(75).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.reset.tooltip")))).m_253136_());
        this.ButtonUndo = (Button)rightTabRowHelper.m_264139_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.undo")), button -> this.undoConfig()).m_252780_(75).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.undo.tooltip")))).m_253136_());
        this.ButtonUndo.f_93623_ = false;
        this.ButtonDone_Save = (Button)rightTabRowHelper.m_264108_((LayoutElement)Button.m_253074_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.exit")), button -> {
            if (this.isChanged.booleanValue()) {
                Config.save(this.MOD_ID);
                this.updateConfig();
            } else {
                this.undoConfig();
                this.m_7379_();
            }
        }).m_252780_(154).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.exit.tooltip")))).m_253136_(), 2);
        infoTab = new GridLayout();
        GridLayout.RowHelper infoTabRowHelper = infoTab.m_264606_(1);
        infoTabRowHelper.m_264502_().m_264174_(4);
        infoTab_Title = (MultiLineTextWidget)infoTabRowHelper.m_264139_((LayoutElement)new MultiLineTextWidget((Component)Component.m_237113_((String)""), this.f_96547_));
        infoTab_Info = (MultiLineTextWidget)infoTabRowHelper.m_264139_((LayoutElement)new MultiLineTextWidget((Component)Component.m_237113_((String)""), this.f_96547_));
        infoTab_Title.m_269098_(154);
        infoTab_Info.m_269098_(154);
        ScreenRectangle screenRectangle = new ScreenRectangle(0, this.tabNavigationBar.m_264198_().m_274349_(), this.f_96543_ - this.rightTab.m_5711_(), this.f_96544_ - this.tabNavigationBar.m_264198_().m_274349_());
        this.slw = new ScrollableListWidget(this.MOD_ID, this.client, screenRectangle.f_263770_(), screenRectangle.f_263800_(), 24, screenRectangle.f_263800_(), 20);
        this.tabNavigationBar.m_276089_(0, false);
        this.selectedTab = null;
        this.m_142416_((GuiEventListener)this.slw);
        infoTab.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.rightTab.m_264134_(abstractWidget -> {
            abstractWidget.m_267708_(1);
            this.m_142416_((GuiEventListener)abstractWidget);
        });
        this.m_142416_((GuiEventListener)this.tabNavigationBar);
        this.m_267719_();
    }

    protected void m_267719_() {
        this.tilesX = (int)Math.ceil((float)this.f_96543_ * 1.0f / 32.0f);
        this.tilesY = (int)Math.ceil((float)this.f_96544_ * 1.0f / 32.0f);
        this.tileMap = new int[this.tilesX][this.tilesY];
        this.generateRandomTileMap();
        if (this.tabNavigationBar != null && this.rightTab != null && this.slw != null) {
            this.tabNavigationBar.m_267604_(this.f_96543_);
            this.tabNavigationBar.m_267766_();
            this.rightTab.m_264036_();
            infoTab.m_264036_();
            int i = this.tabNavigationBar.m_264198_().m_274349_();
            FrameLayout.m_264159_((LayoutElement)this.rightTab, (int)(this.f_96543_ - this.rightTab.m_5711_() - 2), (int)(this.f_96544_ - this.rightTab.m_93694_() - 2), (int)(this.rightTab.m_5711_() + 2), (int)(this.rightTab.m_93694_() + 2));
            FrameLayout.m_264460_((LayoutElement)infoTab, (int)(this.f_96543_ - this.rightTab.m_5711_() - 2), (int)i, (int)(this.rightTab.m_5711_() + 2), (int)(this.f_96544_ - i - this.rightTab.m_93694_()), (float)0.0f, (float)0.0f);
            ScreenRectangle screenRectangle = new ScreenRectangle(0, i, this.f_96543_ - this.rightTab.m_5711_() - 2, this.f_96544_);
            this.slw.m_93437_(screenRectangle.f_263770_(), screenRectangle.f_263800_(), screenRectangle.m_274449_(), screenRectangle.f_263800_());
            this.tabManager.m_267817_(screenRectangle);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.slw != null && this.searchBar != null && this.selectedTab != this.tabManager.m_267695_()) {
            this.pushList(this.searchBar.m_94155_());
        }
        if (updateCall) {
            updateCall = false;
            this.pushListWithoutSetScroll(this.searchBar == null ? null : this.searchBar.m_94155_());
        }
        Map<String, ConfigLoaderFromAnnotation.EntryInfo> current_config_data = ConfigLoaderFromAnnotation.loadConfig_EntryOnly(this.MOD_ID);
        this.isChanged = false;
        current_config_data.forEach((s, entryInfo) -> {
            try {
                Object pastValue = CONFIG_VALUES.get(entryInfo.name);
                Object currentValue = entryInfo.targetField.get(null);
                if (pastValue != null && !pastValue.equals(currentValue)) {
                    this.isChanged = true;
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        });
        if (this.ButtonUndo != null && this.ButtonDone_Save != null && this.ButtonReset_Cancel != null && this.isChanged.booleanValue()) {
            this.ButtonDone_Save.m_93666_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.save")).m_130940_(ChatFormatting.GREEN));
            this.ButtonDone_Save.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.save.tooltip"))));
            this.ButtonReset_Cancel.m_93666_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.cancel")).m_130940_(ChatFormatting.RED));
            this.ButtonReset_Cancel.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.cancel.tooltip"))));
            this.ButtonUndo.f_93623_ = true;
        } else {
            this.ButtonReset_Cancel.m_93666_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.reset")));
            this.ButtonReset_Cancel.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.reset.tooltip"))));
            this.ButtonDone_Save.m_93666_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.exit")));
            this.ButtonDone_Save.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.exit.tooltip"))));
            this.ButtonUndo.f_93623_ = false;
        }
    }

    private void updateConfig() {
        for (ConfigLoaderFromAnnotation.EntryInfo configEntry : CONFIG_ENTRIES) {
            try {
                CONFIG_VALUES.put(configEntry.name, configEntry.targetField.get(null));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void undoConfig() {
        for (ConfigLoaderFromAnnotation.EntryInfo configEntry : CONFIG_ENTRIES) {
            try {
                Object value = CONFIG_VALUES.get(configEntry.name);
                configEntry.targetField.set(null, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void pushList(String filter) {
        if (this.slw == null) {
            return;
        }
        this.pushListWithoutSetScroll(filter);
        this.slw.m_93410_(0.0);
    }

    private void pushListWithoutSetScroll(@Nullable String filter) {
        if (this.slw == null || this.searchBar == null) {
            return;
        }
        this.selectedTab = this.tabManager.m_267695_();
        this.slw.clear();
        Tab tab = this.selectedTab;
        if (tab instanceof ConfigTab) {
            ConfigTab configTab = (ConfigTab)tab;
            configTab.tabEntries.forEach((entryType, buttons) -> {
                if (!entryType.visibleInConfig) {
                    return;
                }
                if (entryType.pseudoEntry) {
                    this.slw.addRow((ConfigLoaderFromAnnotation.EntryInfo)entryType, buttons.toArray(new AbstractWidget[0]));
                } else if (filter == null || filter.isEmpty()) {
                    this.slw.addRow((ConfigLoaderFromAnnotation.EntryInfo)entryType, buttons.toArray(new AbstractWidget[0]));
                } else if (entryType.name.contains(filter.toLowerCase())) {
                    this.slw.addRow((ConfigLoaderFromAnnotation.EntryInfo)entryType, buttons.toArray(new AbstractWidget[0]));
                }
            });
        }
    }

    public void m_7379_() {
        if (this.client != null) {
            this.client.m_91152_(this.parent);
        } else {
            super.m_7379_();
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int $$1, int $$2, float $$3) {
        this.m_280273_(guiGraphics);
        this.drawRandomTiledBackground(guiGraphics);
        guiGraphics.m_280024_(this.rightTab.m_252754_() - 2, this.tabNavigationBar.m_264198_().m_274349_(), this.f_96543_, this.f_96544_, -1157627904, -1157627904);
        super.m_88315_(guiGraphics, $$1, $$2, $$3);
    }

    private void drawRandomTiledBackground(GuiGraphics guiGraphics) {
        int tilesPerRow = 3;
        for (int y = 0; y < this.tilesY; ++y) {
            for (int x = 0; x < this.tilesX; ++x) {
                int tileIndex = this.tileMap[x][y];
                int tileX = tileIndex % tilesPerRow * 32;
                int tileY = tileIndex / tilesPerRow * 32;
                guiGraphics.m_280163_(this.ATLAS_TEXTURE, x * 32, y * 32, (float)tileX, (float)tileY, 32, 32, 96, 96);
            }
        }
    }

    private void generateRandomTileMap() {
        Random random = new Random();
        int tilesPerRow = 3;
        for (int y = 0; y < this.tilesY; ++y) {
            for (int x = 0; x < this.tilesX; ++x) {
                int tileX = random.nextInt(tilesPerRow);
                int tileY = random.nextInt(tilesPerRow);
                this.tileMap[x][y] = tileY * tilesPerRow + tileX;
            }
        }
    }

    static {
        updateCall = false;
    }
}

