/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen.Components;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;

public class OptionButton
extends Button {
    private final ConfigLoaderFromAnnotation.EntryInfo entryInfo;
    private long lastTime;
    private int scrollOffset;
    private boolean reverse = false;
    private int effectCooldown = 0;
    private final String MOD_ID;

    public OptionButton(String MOD_ID, int x, int y, int width, int height, Component message, Component tooltip, Button.OnPress onPress, ConfigLoaderFromAnnotation.EntryInfo entryInfo) {
        super(x, y, width, height, message, onPress, f_252438_);
        this.entryInfo = entryInfo;
        if (tooltip != null) {
            this.m_257544_(Tooltip.m_257550_((Component)tooltip));
        }
        this.lastTime = System.currentTimeMillis();
        this.scrollOffset = 0;
        this.MOD_ID = MOD_ID;
    }

    public OptionButton(String MOD_ID, int x, int y, int width, int height, Component message, Button.OnPress onPress, ConfigLoaderFromAnnotation.EntryInfo entryInfo) {
        this(MOD_ID, x, y, width, height, message, null, onPress, entryInfo);
    }

    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_87963_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (this.m_5953_(pMouseX, pMouseY) && !Objects.equals(this.entryInfo.name, ConfigScreen.currentInfo)) {
            ConfigScreen.infoTab_Title.m_93666_((Component)Component.m_237113_((String)this.entryInfo.humanizeName).m_130940_(ChatFormatting.BOLD));
            MutableComponent info = Component.m_237115_((String)(this.MOD_ID + ".config." + this.entryInfo.name + ".tooltip"));
            if (this.entryInfo.require_restart) {
                info.m_7220_((Component)Component.m_237113_((String)"\n\n").m_7220_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.require_restart")).m_130940_(ChatFormatting.GOLD)));
            }
            ConfigScreen.infoTab_Info.m_93666_((Component)info);
            ConfigScreen.infoTab.m_264036_();
            ConfigScreen.currentInfo = this.entryInfo.name;
        }
    }

    public void m_280139_(GuiGraphics graphics, @NotNull Font textRenderer, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        String leftValue = this.m_6035_().getString();
        String rightValue = "";
        try {
            Object object = this.entryInfo.targetField.get(null);
            rightValue = object.toString();
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("[backpack] Something went wrong with the Option button...");
            e.printStackTrace();
        }
        MutableComponent component = Component.m_237113_((String)rightValue);
        if (rightValue.equalsIgnoreCase("true")) {
            component = Component.m_237113_((String)"\u2714").m_130940_(ChatFormatting.GREEN);
            rightValue = "\u2714";
        }
        if (rightValue.equalsIgnoreCase("false")) {
            component = Component.m_237113_((String)"\u274c").m_130940_(ChatFormatting.RED);
            rightValue = "\u274c";
        }
        int leftTextX = this.m_252754_() + 4;
        int rightTextX = this.m_252754_() + this.f_93618_ - textRenderer.m_92895_(rightValue) - 4;
        float f = this.m_252907_();
        Objects.requireNonNull(textRenderer);
        int textY = (int)(f + (float)(this.f_93619_ - 9) * 1.1f / 2.0f);
        graphics.m_280430_(font, (Component)component, rightTextX, textY, 0xFFFFFF);
        String displayedLeftValue = this.trimTextWithEllipsis(leftValue, (int)((double)(this.f_93618_ - 4) * 0.7), font);
        MutableComponent leftTextComp = Component.m_237113_((String)displayedLeftValue);
        if (this.isChanging()) {
            leftTextComp = Component.m_237113_((String)displayedLeftValue).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW});
        }
        graphics.m_280430_(font, (Component)leftTextComp, leftTextX, textY, 0xFFFFFF);
    }

    private boolean isChanging() {
        Object value;
        try {
            value = this.entryInfo.targetField.get(null);
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("[backpack] Something went wrong with the Option button...");
            e.printStackTrace();
            return false;
        }
        Object lastValue = ConfigScreen.CONFIG_VALUES.get(this.entryInfo.name);
        return !value.equals(lastValue);
    }

    private String trimTextWithEllipsis(String text, int maxWidth, Font textRenderer) {
        if (textRenderer.m_92895_(text) <= maxWidth) {
            return text;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTime > 150L) {
            if (this.effectCooldown > 0) {
                --this.effectCooldown;
                String scrollingText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
                return textRenderer.m_92834_(scrollingText, maxWidth - textRenderer.m_92895_("...")) + "...";
            }
            this.scrollOffset = !this.reverse ? (this.scrollOffset + 1) % text.length() : (this.scrollOffset - 1) % text.length();
            String checkText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
            if (textRenderer.m_92895_(checkText) + 6 < maxWidth || this.scrollOffset < 1) {
                this.reverse = !this.reverse;
                this.effectCooldown = 90;
            }
            this.lastTime = currentTime;
        }
        String scrollingText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
        return textRenderer.m_92834_(scrollingText, maxWidth - textRenderer.m_92895_("...")) + "...";
    }

    private String getScrollingText(String text, int scrollOffset, int maxWidth, Font textRenderer) {
        String visiblePart;
        if (scrollOffset < 0) {
            scrollOffset = 0;
        }
        if (scrollOffset > text.length()) {
            scrollOffset = text.length();
        }
        if (textRenderer.m_92895_(visiblePart = text.substring(scrollOffset)) > maxWidth) {
            visiblePart = textRenderer.m_92834_(visiblePart, maxWidth);
        }
        return visiblePart;
    }
}

