/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen.Components;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;

public class NumberButtonInfo
extends StringWidget {
    private final ConfigLoaderFromAnnotation.EntryInfo entryInfo;
    private final Component initMessage;
    private final String MOD_ID;
    private long lastTime;
    private int scrollOffset;
    private boolean reverse = false;
    private int effectCooldown = 0;

    public NumberButtonInfo(String MOD_ID, int width, int height, Component message, Font font, ConfigLoaderFromAnnotation.EntryInfo info) {
        super(width, height, message, font);
        this.entryInfo = info;
        this.initMessage = message;
        this.MOD_ID = MOD_ID;
        this.lastTime = System.currentTimeMillis();
        this.scrollOffset = 0;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Font font = Minecraft.m_91087_().f_91062_;
        String scrollingText = this.trimTextWithEllipsis(this.initMessage.getString(), this.f_93618_, font);
        MutableComponent valueStatusIndicator = Component.m_237113_((String)scrollingText);
        if (this.isChanging()) {
            valueStatusIndicator = Component.m_237113_((String)scrollingText).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.YELLOW});
        }
        this.m_93666_((Component)valueStatusIndicator);
        if (this.m_5953_(mouseX, mouseY) && !Objects.equals(this.entryInfo.name, ConfigScreen.currentInfo)) {
            ConfigScreen.infoTab_Title.m_93666_((Component)Component.m_237113_((String)this.entryInfo.humanizeName).m_130940_(ChatFormatting.BOLD));
            MutableComponent info = Component.m_237115_((String)(this.MOD_ID + ".config." + this.entryInfo.name + ".tooltip"));
            if (this.entryInfo.require_restart) {
                info.m_7220_((Component)Component.m_237113_((String)"\n\n").m_7220_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.require_restart")).m_130940_(ChatFormatting.GOLD)));
            }
            ConfigScreen.infoTab_Info.m_93666_((Component)info);
            ConfigScreen.infoTab.m_264036_();
            ConfigScreen.currentInfo = this.entryInfo.name;
        }
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private boolean isChanging() {
        Object value;
        try {
            value = this.entryInfo.targetField.get(null);
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("[backpack] Something went wrong with the Option button...");
            e.printStackTrace();
            return false;
        }
        Object lastValue = ConfigScreen.CONFIG_VALUES.get(this.entryInfo.name);
        return !value.equals(lastValue);
    }

    private String trimTextWithEllipsis(String text, int maxWidth, Font textRenderer) {
        if (textRenderer.m_92895_(text) <= maxWidth) {
            return text;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTime > 150L) {
            if (this.effectCooldown > 0) {
                --this.effectCooldown;
                String scrollingText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
                return textRenderer.m_92834_(scrollingText, maxWidth - textRenderer.m_92895_("...")) + "...";
            }
            this.scrollOffset = !this.reverse ? (this.scrollOffset + 1) % text.length() : (this.scrollOffset - 1) % text.length();
            String checkText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
            if (textRenderer.m_92895_(checkText) + 6 < maxWidth || this.scrollOffset < 1) {
                this.reverse = !this.reverse;
                this.effectCooldown = 90;
            }
            this.lastTime = currentTime;
        }
        String scrollingText = this.getScrollingText(text, this.scrollOffset, maxWidth, textRenderer);
        return textRenderer.m_92834_(scrollingText, maxWidth - textRenderer.m_92895_("...")) + "...";
    }

    private String getScrollingText(String text, int scrollOffset, int maxWidth, Font textRenderer) {
        String visiblePart;
        if (scrollOffset < 0) {
            scrollOffset = 0;
        }
        if (scrollOffset > text.length()) {
            scrollOffset = text.length();
        }
        if (textRenderer.m_92895_(visiblePart = text.substring(scrollOffset)) > maxWidth) {
            visiblePart = textRenderer.m_92834_(visiblePart, maxWidth);
        }
        return visiblePart;
    }
}

