/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config.ConfigScreen.Components;

import java.lang.reflect.Field;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigScreen.ConfigScreen;

public class IntSliderButton
extends AbstractSliderButton {
    String MOD_ID;
    ConfigLoaderFromAnnotation.EntryInfo entryInfo = null;
    ConfigLoaderFromAnnotation.SliderInfo sliderInfo = null;

    public IntSliderButton(String MOD_ID, int width, int height, Component message, ConfigLoaderFromAnnotation.EntryInfo entryInfo) {
        super(0, 0, width, height, message, IntSliderButton.normalizeValue(entryInfo));
        this.MOD_ID = MOD_ID;
        this.sliderInfo = entryInfo.slider;
        this.entryInfo = entryInfo;
        this.m_5695_();
    }

    private static double normalizeValue(ConfigLoaderFromAnnotation.EntryInfo entryInfo) {
        int value = 0;
        try {
            value = (Integer)entryInfo.targetField.get(null);
        }
        catch (IllegalAccessException e) {
            Constants.LOG.error("[backpack] Something went wrong with the Number button...");
            e.printStackTrace();
        }
        return (double)(value - entryInfo.slider.min) / (double)(entryInfo.slider.max - entryInfo.slider.min);
    }

    private int denormalizeValue(double sliderValue) {
        int range = this.sliderInfo.max - this.sliderInfo.min;
        int rawValue = (int)(sliderValue * (double)range) + this.sliderInfo.min;
        int stepped = (rawValue - this.sliderInfo.min) / this.sliderInfo.step * this.sliderInfo.step + this.sliderInfo.min;
        return Math.max(this.sliderInfo.min, Math.min(this.sliderInfo.max, stepped));
    }

    protected void m_5695_() {
        this.m_93666_((Component)Component.m_237113_((String)("Value: " + this.denormalizeValue(this.f_93577_))));
    }

    protected void m_5697_() {
        int currentValue = this.denormalizeValue(this.f_93577_);
        Field field = this.entryInfo.targetField;
        try {
            field.set(null, currentValue);
        }
        catch (IllegalAccessException | NumberFormatException e) {
            Constants.LOG.error(" Something went wrong with the config system...");
            e.printStackTrace();
        }
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        double newValue = IntSliderButton.normalizeValue(this.entryInfo);
        if (Math.abs(newValue - this.f_93577_) > 1.0E-9) {
            this.f_93577_ = newValue;
            this.m_5695_();
        }
        if (this.m_5953_(mouseX, mouseY) && !Objects.equals(this.entryInfo.name, ConfigScreen.currentInfo)) {
            ConfigScreen.infoTab_Title.m_93666_((Component)Component.m_237113_((String)this.entryInfo.humanizeName).m_130940_(ChatFormatting.BOLD));
            MutableComponent info = Component.m_237115_((String)(this.MOD_ID + ".config." + this.entryInfo.name + ".tooltip"));
            if (this.entryInfo.require_restart) {
                info.m_7220_((Component)Component.m_237113_((String)"\n\n").m_7220_((Component)Component.m_237115_((String)(this.MOD_ID + ".config.require_restart")).m_130940_(ChatFormatting.GOLD)));
            }
            ConfigScreen.infoTab_Info.m_93666_((Component)info);
            ConfigScreen.infoTab.m_264036_();
            ConfigScreen.currentInfo = this.entryInfo.name;
        }
        super.m_87963_(guiGraphics, mouseX, mouseY, partialTick);
    }
}

