/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.config;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.platform.Services;
import xyz.faewulf.lib.util.config.ConfigLoaderFromAnnotation;
import xyz.faewulf.lib.util.config.ConfigRecord;
import xyz.faewulf.lib.util.config.Entry;
import xyz.faewulf.lib.util.config.ModConfigs;

public class Config {
    private static boolean alreadyInit = false;
    public static final Map<String, ConfigRecord> LIST_OF_CONFIG = new HashMap<String, ConfigRecord>();
    private static final Map<String, Boolean> LIST_OF_LOADED_CONFIGS = new HashMap<String, Boolean>();

    public static void init() {
        if (alreadyInit) {
            return;
        }
        if (Services.PLATFORM.isDevelopmentEnvironment()) {
            Config.registerConfig("faewulf_lib", ModConfigs.class);
        }
        alreadyInit = true;
    }

    private static void init(String MOD_ID) {
        if (!LIST_OF_LOADED_CONFIGS.containsKey(MOD_ID)) {
            return;
        }
        if (LIST_OF_LOADED_CONFIGS.get(MOD_ID).booleanValue()) {
            return;
        }
        ConfigRecord configRecord = LIST_OF_CONFIG.get(MOD_ID);
        if (configRecord == null) {
            return;
        }
        ConfigLoaderFromAnnotation.initializeDefaults(configRecord);
        Config.loadFromFile(configRecord);
        Config.saveConfig(configRecord);
        LIST_OF_LOADED_CONFIGS.put(MOD_ID, true);
    }

    public static void preLoad(String MOD_ID, Class<?> modClass) {
        Config.registerConfig(MOD_ID, modClass);
    }

    public static void registerConfig(String MOD_ID, Class<?> ModClass) {
        if (LIST_OF_CONFIG.containsKey(MOD_ID)) {
            return;
        }
        LIST_OF_CONFIG.put(MOD_ID, new ConfigRecord(MOD_ID, ModClass));
        LIST_OF_LOADED_CONFIGS.put(MOD_ID, false);
        Config.init(MOD_ID);
    }

    public static void save(String MOD_ID) {
        ConfigRecord configRecord = LIST_OF_CONFIG.get(MOD_ID);
        if (configRecord == null) {
            Constants.LOG.warn("Config of " + MOD_ID + " could not be found.");
            return;
        }
        Config.saveConfig(configRecord);
    }

    public static void reloadConfig(String modId) {
        if (!LIST_OF_CONFIG.containsKey(modId)) {
            Constants.LOG.error("{} not valid/not found.", (Object)modId);
            return;
        }
        Config.loadFromFile(LIST_OF_CONFIG.get(modId));
        Constants.LOG.info("Reloaded {} config file.", (Object)modId);
    }

    public static void reloadAllConfig() {
        LIST_OF_CONFIG.forEach((s, configRecord) -> {
            Config.loadFromFile(configRecord);
            Constants.LOG.info("Reloaded {} config file.", (Object)configRecord.getName());
        });
        Constants.LOG.info("Total config reloaded: {}", (Object)LIST_OF_CONFIG.size());
    }

    private static void saveConfig(ConfigRecord configRecord) {
        try (FileWriter writer = new FileWriter(configRecord.getCONFIG_PATH());){
            Map<String, Map<String, ConfigLoaderFromAnnotation.EntryInfo>> configMap = ConfigLoaderFromAnnotation.loadConfig(configRecord.getName());
            for (Map.Entry<String, Map<String, ConfigLoaderFromAnnotation.EntryInfo>> entry : configMap.entrySet()) {
                writer.write("[" + entry.getKey() + "]\n");
                ArrayList<String> groupAppeared = new ArrayList<String>();
                for (Map.Entry<String, ConfigLoaderFromAnnotation.EntryInfo> subEntry : entry.getValue().entrySet()) {
                    if (!groupAppeared.contains(subEntry.getValue().group)) {
                        groupAppeared.add(subEntry.getValue().group);
                        writer.write("\n# Group: " + subEntry.getValue().group + "\n");
                    }
                    writer.write("\"" + subEntry.getKey() + "\" = " + Config.toTomlValue(subEntry.getValue().value));
                    if (!subEntry.getValue().info.isEmpty()) {
                        writer.write("\t\t\t# " + subEntry.getValue().info);
                    }
                    writer.write("\n");
                }
                writer.write("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String toTomlValue(Object value) {
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        if (value instanceof Boolean || value instanceof Number) {
            return value.toString();
        }
        if (value.getClass().isEnum()) {
            return "\"" + value + "\"";
        }
        return "";
    }

    private static void loadFromFile(ConfigRecord configRecord) {
        if (Files.exists(Path.of(configRecord.getCONFIG_PATH_OLD(), new String[0]), new LinkOption[0])) {
            Constants.LOG.warn("Detected the old configuration file '{}'. The mod {} has transitioned to using '{}' for configuration. Sorry for the inconvenient!", new Object[]{configRecord.getCONFIG_PATH_OLD(), configRecord.getName(), configRecord.getCONFIG_PATH()});
        }
        try (FileConfig reader = FileConfig.of((String)configRecord.getCONFIG_PATH());){
            File dir = new File("config");
            if (!dir.exists()) {
                dir.mkdir();
            }
            reader.load();
            for (Field field : configRecord.getConfigClass().getDeclaredFields()) {
                String name;
                if (!field.isAnnotationPresent(Entry.class)) continue;
                Entry entry = field.getAnnotation(Entry.class);
                String category = entry.category();
                Object value = reader.get(category + "." + (name = entry.name()));
                if (value != null && Config.isValidType(field, value)) {
                    field.set(null, Config.convertValue(field.getType(), value));
                    continue;
                }
                Constants.LOG.warn("Invalid type for config '{}' in category '{}'. Override with default value...", (Object)name, (Object)category);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isValidType(Field field, Object value) {
        Class<?> fieldType = field.getType();
        if (fieldType.isAssignableFrom(value.getClass())) {
            return true;
        }
        if (fieldType == Integer.TYPE && value instanceof Number) {
            return true;
        }
        if (fieldType == Boolean.TYPE && value instanceof Boolean) {
            return true;
        }
        if (fieldType.isEnum() && value instanceof String) {
            try {
                Enum.valueOf(fieldType, (String)value);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    private static Object convertValue(Class<?> fieldType, Object value) {
        if (fieldType == Integer.TYPE && value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (fieldType == Boolean.TYPE && value instanceof Boolean) {
            return value;
        }
        if (fieldType.isEnum() && value instanceof String) {
            return Enum.valueOf(fieldType, (String)value);
        }
        return value;
    }
}

