/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.Nullable;

public class BlockStateUtils {
    private static final List<Block> blackListBlock = new ArrayList<Block>(){
        {
            this.add(Blocks.f_50262_);
            this.add(Blocks.f_50258_);
            this.add(Blocks.f_50188_);
            this.add(Blocks.f_50187_);
            this.add(Blocks.f_50040_);
            this.add(Blocks.f_50110_);
            this.add(Blocks.f_50191_);
            this.add(Blocks.f_50025_);
            this.add(Blocks.f_50029_);
            this.add(Blocks.f_50023_);
            this.add(Blocks.f_50026_);
            this.add(Blocks.f_50021_);
            this.add(Blocks.f_50027_);
            this.add(Blocks.f_50017_);
            this.add(Blocks.f_50022_);
            this.add(Blocks.f_50019_);
            this.add(Blocks.f_50068_);
            this.add(Blocks.f_50067_);
            this.add(Blocks.f_50020_);
            this.add(Blocks.f_50024_);
            this.add(Blocks.f_50028_);
            this.add(Blocks.f_50066_);
            this.add(Blocks.f_50018_);
        }
    };

    @Nullable
    public static BlockState getNextState(BlockState state) {
        BlockState newState = null;
        if ((state.m_60734_() == Blocks.f_50087_ || state.m_60734_() == Blocks.f_50325_) && state.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
            return null;
        }
        if ((state.m_60734_() == Blocks.f_50039_ || state.m_60734_() == Blocks.f_50032_) && ((Boolean)state.m_61143_((Property)PistonBaseBlock.f_60153_)).booleanValue()) {
            return null;
        }
        if (blackListBlock.contains(state.m_60734_())) {
            return null;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61397_)) {
            SlabType slabType = switch ((SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_)) {
                case SlabType.TOP -> SlabType.BOTTOM;
                case SlabType.BOTTOM -> SlabType.TOP;
                default -> (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_);
            };
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61397_, (Comparable)slabType);
        } else if (state.m_61138_((Property)BlockStateProperties.f_61390_)) {
            int rot = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_) + 1;
            if (rot == 16) {
                rot = 0;
            }
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(rot));
        } else if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            Direction.Axis axis = switch ((Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_)) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> Direction.Axis.Y;
                case Direction.Axis.Y -> Direction.Axis.Z;
                case Direction.Axis.Z -> Direction.Axis.X;
            };
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis);
        } else if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            Direction direction = switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.UP -> Direction.NORTH;
                case Direction.NORTH -> Direction.EAST;
                case Direction.EAST -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.WEST;
                case Direction.WEST -> Direction.DOWN;
                case Direction.DOWN -> Direction.UP;
            };
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)direction);
        } else if (state.m_61138_((Property)BlockStateProperties.f_61373_)) {
            Direction direction = switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61373_)) {
                case Direction.DOWN -> Direction.NORTH;
                case Direction.NORTH -> Direction.EAST;
                case Direction.EAST -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.WEST;
                case Direction.WEST -> Direction.DOWN;
                default -> (Direction)state.m_61143_((Property)BlockStateProperties.f_61373_);
            };
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61373_, (Comparable)direction);
        } else if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            Direction direction = switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
                case Direction.NORTH -> Direction.EAST;
                case Direction.EAST -> Direction.SOUTH;
                case Direction.SOUTH -> Direction.WEST;
                case Direction.WEST -> Direction.NORTH;
                default -> (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            };
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction);
            if (state.m_61138_((Property)BlockStateProperties.f_61402_) && state.m_61143_((Property)BlockStateProperties.f_61374_) == Direction.NORTH) {
                Half blockHalf = (Half)state.m_61143_((Property)BlockStateProperties.f_61402_);
                newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)(blockHalf == Half.TOP ? Half.BOTTOM : Half.TOP));
            }
        } else if (state.m_61138_((Property)BlockStateProperties.f_61404_)) {
            RailShape railShape = switch ((RailShape)state.m_61143_((Property)BlockStateProperties.f_61404_)) {
                case RailShape.NORTH_SOUTH -> RailShape.EAST_WEST;
                case RailShape.EAST_WEST -> RailShape.NORTH_SOUTH;
                default -> (RailShape)state.m_61143_((Property)BlockStateProperties.f_61404_);
            };
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61404_, (Comparable)railShape);
        } else if (state.m_61138_((Property)BlockStateProperties.f_61403_)) {
            RailShape railShape = switch ((RailShape)state.m_61143_((Property)BlockStateProperties.f_61403_)) {
                case RailShape.NORTH_SOUTH -> RailShape.EAST_WEST;
                case RailShape.EAST_WEST -> RailShape.NORTH_EAST;
                case RailShape.NORTH_EAST -> RailShape.SOUTH_EAST;
                case RailShape.SOUTH_EAST -> RailShape.SOUTH_WEST;
                case RailShape.SOUTH_WEST -> RailShape.NORTH_WEST;
                case RailShape.NORTH_WEST -> RailShape.NORTH_SOUTH;
                default -> (RailShape)state.m_61143_((Property)BlockStateProperties.f_61403_);
            };
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61403_, (Comparable)railShape);
        } else if (state.m_61138_((Property)BlockStateProperties.f_61435_)) {
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)BlockStateProperties.f_61435_) == false));
        }
        return newState;
    }
}

