/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.util;

import org.jetbrains.annotations.NotNull;

public class Converter {
    public static String getNoteCharacter(int note) {
        return switch (note) {
            case 0 -> "F#";
            case 1 -> "G";
            case 2 -> "G#";
            case 3 -> "A";
            case 4 -> "A#";
            case 5 -> "B";
            case 6 -> "C";
            case 7 -> "C#";
            case 8 -> "D";
            case 9 -> "D#";
            case 10 -> "E";
            case 11 -> "F";
            case 12 -> "F#";
            case 13 -> "G";
            case 14 -> "G#";
            case 15 -> "A";
            case 16 -> "A#";
            case 17 -> "B";
            case 18 -> "C";
            case 19 -> "C#";
            case 20 -> "D";
            case 21 -> "D#";
            case 22 -> "E";
            case 23 -> "F";
            case 24 -> "F#";
            default -> "Unknown";
        };
    }

    public static String tick2Time(long ticks) {
        long seconds = ticks / 20L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        seconds %= 60L;
        minutes %= 60L;
        if (hours > 0L) {
            return String.format("%02dh%02dm%02ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%02dm%02ds", minutes, seconds);
        }
        return String.format("%02ds", seconds);
    }

    public static String tick2MinecraftTime(long ticks) {
        long dayTime = ticks % 24000L;
        long hours = (dayTime / 1000L + 6L) % 24L;
        long minutes = dayTime % 1000L * 60L / 1000L;
        long seconds = dayTime % 1000L * 60L % 1000L * 60L / 1000L;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }

    public static double horseJumpStrength2JumpHeight(double strength) {
        double height = 0.0;
        double velocity = strength;
        while (velocity > 0.0) {
            height += velocity;
            velocity = (velocity - 0.08) * 0.98 * 0.98;
        }
        return height;
    }

    public static double genericSpeed2BlockPerSecond(double speed) {
        return 42.157796 * speed;
    }

    public static String UppercaseFirstLetter(@NotNull String input) {
        if (input.isBlank() || input.isEmpty()) {
            return "";
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }
}

