/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.lib.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import xyz.faewulf.lib.Constants;
import xyz.faewulf.lib.util.Compare;

public class ItemTagRegistry {
    private static final List<String> BASE_PATHS = new ArrayList<String>();
    private static final Map<String, List<Item>> TYPE_TO_ITEMS_MAP = new HashMap<String, List<Item>>();

    public static void add(String path) {
        BASE_PATHS.add(path);
    }

    public static void loadAllItemTags() {
        TYPE_TO_ITEMS_MAP.clear();
        try {
            for (String basePath : BASE_PATHS) {
                Minecraft.m_91087_().m_91098_().m_214159_(basePath, path -> path.toString().endsWith(".json")).forEach((location, resource) -> {
                    try {
                        InputStreamReader reader = new InputStreamReader(resource.m_215507_());
                        JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                        reader.close();
                        String type = basePath + ":" + json.get("type").getAsString();
                        JsonArray itemsArray = json.getAsJsonArray("items");
                        List<Item> itemList = ItemTagRegistry.parseItemsArray(itemsArray);
                        TYPE_TO_ITEMS_MAP.putIfAbsent(type, new ArrayList());
                        TYPE_TO_ITEMS_MAP.get(type).addAll(itemList);
                    }
                    catch (Exception e) {
                        Constants.LOG.error("Opps something went wrong!");
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (Exception e) {
            Constants.LOG.error("Opps something went wrong!");
            e.printStackTrace();
        }
    }

    private static List<Item> parseItemsArray(JsonArray itemsArray) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (JsonElement element : itemsArray) {
            Item item2;
            String itemString = element.getAsString();
            if (itemString.startsWith("#")) {
                String tagId = itemString.substring(1);
                BuiltInRegistries.f_257033_.m_123024_().forEach(item -> {
                    if (Compare.isHasTag(item, tagId)) {
                        itemList.add((Item)item);
                    }
                });
                continue;
            }
            ResourceLocation itemResource = ResourceLocation.m_135820_((String)itemString);
            if (itemResource == null || (item2 = (Item)BuiltInRegistries.f_257033_.m_7745_(itemResource)) == Items.f_41852_) continue;
            itemList.add(item2);
        }
        return itemList;
    }

    public static Map<String, List<Item>> getTypeToItemsMap() {
        return TYPE_TO_ITEMS_MAP;
    }
}

