/*
 * Decompiled with CFR 0.152.
 */
package malfu.bc_particle.particle.custom;

import com.mojang.blaze3d.vertex.VertexConsumer;
import malfu.bc_particle.BetterCombatParticleMods;
import malfu.bc_particle.particle.parameters.SlashParticleEffect;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class BotSlashParticle180
extends TextureSheetParticle {
    private final SpriteSet spriteProvider;
    private final String color;
    public final float modelOffset;
    private final float pitch;
    private final float yaw;
    private final float localYaw;
    private final float roll;
    private final boolean light;

    BotSlashParticle180(ClientLevel world, double x, double y, double z, float scale, float pitch, float yaw, float localYaw, float roll, boolean light, String colorHex, SpriteSet spriteProvider) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.spriteProvider = spriteProvider;
        this.color = colorHex;
        this.light = light;
        this.pitch = pitch;
        this.yaw = yaw;
        this.roll = roll;
        this.localYaw = localYaw;
        this.f_107230_ = this.getAlpha();
        this.f_107225_ = 6;
        this.modelOffset = this.setModelOffset();
        this.f_107663_ = scale;
        this.m_108339_(spriteProvider);
    }

    public void m_5989_() {
        this.m_107253_(this.getRed(), this.getGreen(), this.getBlue());
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.spriteProvider);
        }
    }

    public float getAlpha() {
        if (this.color.equals("remove")) {
            this.f_107230_ = 0.0f;
            return 0.0f;
        }
        if (this.light) {
            this.f_107230_ = BetterCombatParticleMods.config.light_particle_alpha;
            return this.f_107230_;
        }
        this.f_107230_ = BetterCombatParticleMods.config.particle_alpha;
        return this.f_107230_;
    }

    public float getRed() {
        return (float)this.parseHexColor(this.color, 16) / 255.0f;
    }

    public float getGreen() {
        return (float)this.parseHexColor(this.color, 8) / 255.0f;
    }

    public float getBlue() {
        return (float)this.parseHexColor(this.color, 0) / 255.0f;
    }

    private int parseHexColor(String hex, int shift) {
        String cleanHex = hex.startsWith("#") ? hex.substring(1) : hex;
        try {
            int color = Integer.parseInt(cleanHex, 16);
            return color >> shift & 0xFF;
        }
        catch (NumberFormatException e) {
            return 255;
        }
    }

    protected int m_6355_(float tint) {
        BlockPos blockPos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        if (this.light) {
            return 0xF000F0;
        }
        return this.f_107208_.m_46805_(blockPos) ? LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)blockPos) : 0;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public Particle m_6569_(float scale) {
        this.f_107663_ = scale;
        return super.m_6569_(scale);
    }

    public float setModelOffset() {
        return 0.0f;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float tickDelta) {
        Vector4f[] corners;
        Vec3 cameraPos = camera.m_90583_();
        float x = (float)(this.f_107209_ - cameraPos.m_7096_());
        float y = (float)(this.f_107210_ - cameraPos.m_7098_());
        float z = (float)(this.f_107211_ - cameraPos.m_7094_());
        float size = this.m_5902_(tickDelta);
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        Matrix4f rotationMatrix = new Matrix4f();
        rotationMatrix.identity();
        rotationMatrix.rotate((float)Math.toRadians(-this.yaw), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        rotationMatrix.rotate((float)Math.toRadians(this.pitch), (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f));
        rotationMatrix.rotate((float)Math.toRadians(this.roll), (Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f));
        rotationMatrix.rotate((float)Math.toRadians(-this.localYaw), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        for (Vector4f corner : corners = new Vector4f[]{new Vector4f(-size, this.modelOffset, -size, 1.0f), new Vector4f(-size, this.modelOffset, size, 1.0f), new Vector4f(size, this.modelOffset, size, 1.0f), new Vector4f(size, this.modelOffset, -size, 1.0f)}) {
            rotationMatrix.transform(corner);
            corner.add(x, y, z, 0.0f);
        }
        vertexConsumer.m_5483_((double)corners[0].x(), (double)corners[0].y(), (double)corners[0].z()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(tickDelta)).m_5752_();
        vertexConsumer.m_5483_((double)corners[1].x(), (double)corners[1].y(), (double)corners[1].z()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(tickDelta)).m_5752_();
        vertexConsumer.m_5483_((double)corners[2].x(), (double)corners[2].y(), (double)corners[2].z()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(tickDelta)).m_5752_();
        vertexConsumer.m_5483_((double)corners[3].x(), (double)corners[3].y(), (double)corners[3].z()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(tickDelta)).m_5752_();
        vertexConsumer.m_5483_((double)corners[3].x(), (double)corners[3].y(), (double)corners[3].z()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(tickDelta)).m_5752_();
        vertexConsumer.m_5483_((double)corners[2].x(), (double)corners[2].y(), (double)corners[2].z()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(tickDelta)).m_5752_();
        vertexConsumer.m_5483_((double)corners[1].x(), (double)corners[1].y(), (double)corners[1].z()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(tickDelta)).m_5752_();
        vertexConsumer.m_5483_((double)corners[0].x(), (double)corners[0].y(), (double)corners[0].z()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(this.m_6355_(tickDelta)).m_5752_();
    }

    @Environment(value=EnvType.CLIENT)
    public static class Provider
    implements ParticleProvider<SlashParticleEffect> {
        private final SpriteSet spriteProvider;

        public Provider(SpriteSet spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        public Particle createParticle(SlashParticleEffect settings, ClientLevel clientWorld, double d, double e, double f, double g, double h, double i) {
            return new BotSlashParticle180(clientWorld, d, e, f, settings.getScale(), settings.getPitch(), settings.getYaw(), settings.getLocalYaw(), settings.getRoll(), settings.getLight(), settings.getColorHex(), this.spriteProvider);
        }
    }
}

