/*
 * Decompiled with CFR 0.152.
 */
package malfu.bc_particle.config;

import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import malfu.bc_particle.config.ColorLightSettings;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;

public class EnchantmentSettingsLoader
implements SimpleSynchronousResourceReloadListener {
    public static final EnchantmentSettingsLoader INSTANCE = new EnchantmentSettingsLoader();
    private Map<String, ColorLightSettings> settingsMap = new HashMap<String, ColorLightSettings>();

    public void m_6213_(ResourceManager resourceManager) {
        HashMap<String, ColorLightSettings> combinedMap = new HashMap<String, ColorLightSettings>();
        Map resourceMap = resourceManager.m_214159_("bc_particle", path -> path.m_135815_().endsWith(".json"));
        for (ResourceLocation resourceId : resourceMap.keySet()) {
            String path2 = resourceId.m_135815_();
            if (!path2.endsWith("enchantment_settings.json")) continue;
            try {
                Resource resource = (Resource)resourceMap.get(resourceId);
                try {
                    InputStream stream = resource.m_215507_();
                    try (InputStreamReader reader = new InputStreamReader(stream);){
                        JsonObject rootObject = GsonHelper.m_13859_((Reader)reader);
                        JsonObject valuesObject = GsonHelper.m_13930_((JsonObject)rootObject, (String)"values");
                        for (String enchantmentId : valuesObject.keySet()) {
                            JsonObject settingsObject = GsonHelper.m_13930_((JsonObject)valuesObject, (String)enchantmentId);
                            ColorLightSettings settings = this.parseSettings(settingsObject);
                            combinedMap.put(enchantmentId, settings);
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to parse enchantment settings from: " + String.valueOf(resourceId));
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                System.err.println("Failed to load enchantment settings from: " + String.valueOf(resourceId));
                e.printStackTrace();
            }
        }
        this.settingsMap = combinedMap;
        System.out.println("[BC Particles] Loaded enchantment settings for " + combinedMap.size() + " enchantments from client");
    }

    private ColorLightSettings parseSettings(JsonObject json) {
        return new ColorLightSettings(GsonHelper.m_13851_((JsonObject)json, (String)"color_hex", (String)"FFFFFF"), GsonHelper.m_13851_((JsonObject)json, (String)"color_hex_sec", (String)"D9D9D9"), GsonHelper.m_13855_((JsonObject)json, (String)"light", (boolean)true));
    }

    public ResourceLocation getFabricId() {
        return new ResourceLocation("bc_particle", "enchantment_settings_loader");
    }

    public ColorLightSettings getSettings(String enchantmentId) {
        return this.settingsMap.getOrDefault(enchantmentId, null);
    }

    public static void loadNow() {
        Minecraft client = Minecraft.m_91087_();
        if (client != null && client.m_91098_() != null) {
            INSTANCE.m_6213_(client.m_91098_());
        }
    }
}

