/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.smsn.mixin;

import dev.aika.smsn.SMSN;
import dev.aika.smsn.api.ModPlatform;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class ModMixinInfo
implements Comparable<ModMixinInfo> {
    private final String modId;
    private final List<String> mixinClasses;
    private final boolean isModLoaded;

    public ModMixinInfo(String modId, List<String> mixinClasses) {
        this.modId = modId;
        this.mixinClasses = mixinClasses;
        this.isModLoaded = ModPlatform.isModLoaded(modId);
    }

    public ModMixinInfo(String modId, String ... mixinClasses) {
        this(modId, List.of(mixinClasses));
    }

    @Override
    public int compareTo(@NotNull ModMixinInfo o) {
        if (this.modId.hashCode() < o.modId.hashCode()) {
            return -1;
        }
        if (this.modId.hashCode() == o.modId.hashCode()) {
            return 0;
        }
        return 1;
    }

    public boolean shouldApply(String mixinClassName) {
        return this.isModLoaded && !SMSN.CONFIG.disabledMixins.contains(mixinClassName);
    }

    @Generated
    public String getModId() {
        return this.modId;
    }

    @Generated
    public List<String> getMixinClasses() {
        return this.mixinClasses;
    }

    @Generated
    public boolean isModLoaded() {
        return this.isModLoaded;
    }
}

