/*
 * Decompiled with CFR 0.152.
 */
package dev.aika.smsn.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.aika.smsn.SMSN;
import dev.aika.smsn.SMSNPlatform;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ModConfig {
    private static final Logger log = SMSN.LOGGER;
    private static final Marker marker = MarkerFactory.getMarker((String)"ModConfig");
    protected static final File CONFIG_FILE = new File(SMSNPlatform.getConfigDir().toFile(), "smsn.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static <T> T load(Class<T> clazz) {
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            Object object = GSON.fromJson((Reader)reader, clazz);
            return (T)object;
        }
        catch (IOException e) {
            log.error(marker, "Failed to parse config file: {}", (Object)CONFIG_FILE, (Object)e);
            return null;
        }
    }

    public void save() {
        String configStr = GSON.toJson((Object)this);
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            writer.write(configStr);
        }
        catch (IOException e) {
            log.error(marker, "Failed to write config file {}", (Object)CONFIG_FILE, (Object)e);
        }
    }
}

