/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.cataclysm_custscenes.entities.maledictus;

import com.finderfeed.cataclysm_custscenes.CatCutUtil;
import com.finderfeed.cataclysm_custscenes.CataclysmCutscenes;
import com.finderfeed.fdlib.init.FDScreenEffects;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.cutscenes.CameraPos;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneData;
import com.finderfeed.fdlib.systems.cutscenes.EasingType;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectData;
import com.finderfeed.fdlib.systems.screen.screen_effect.instances.datas.ScreenColorData;
import com.finderfeed.fdlib.util.ProjectileMovementPath;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.Maledictus.Maledictus_Entity;
import com.github.L_Ender.cataclysm.entity.effect.Cm_Falling_Block_Entity;
import com.github.L_Ender.cataclysm.init.ModBlocks;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModSounds;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

public class MaledictusCutsceneEntity
extends Maledictus_Entity
implements AutoSerializable {
    public static final int IDLE = 0;
    public static final int MACE_STRIKE = 1;
    public static final int BOW_PULL_1 = 2;
    public static final int BOW_PULL_2 = 3;
    public static final int AIR_IDLE_FALLING = 4;
    public static final int END_FLY = 5;
    public static final int DEATH = 6;
    public static final int BIG_STRIKE_FLAME = 7;
    public static final int START_FLYING_HANDS_UP = 8;
    public static final int STRIKE_WITH_BLOCKS = 9;
    @SerializableField
    private ProjectileMovementPath movementPath;
    private int afterPathTicks = 0;

    public static MaledictusCutsceneEntity summon(Level level, Vec3 pos, Vec3 direction, BlockPos homeAndTombstonePos, Direction tombstoneDirection) {
        MaledictusCutsceneEntity maledictus = new MaledictusCutsceneEntity(CataclysmCutscenes.MALEDICTUS_CUTSCENE.get(), level);
        direction = direction.m_82542_(1.0, 0.0, 1.0).m_82541_();
        maledictus.setHomePos(homeAndTombstonePos);
        maledictus.setTombstonePos(homeAndTombstonePos);
        maledictus.setTombstoneDirection(tombstoneDirection);
        ResourceLocation dimLoc = level.m_46472_().m_135782_();
        maledictus.setDimensionType(dimLoc.toString());
        maledictus.movementPath = MaledictusCutsceneEntity.createMovementPath(pos, direction);
        maledictus.m_146884_((Vec3)maledictus.movementPath.getPositions().get(0));
        maledictus.m_7618_(EntityAnchorArgument.Anchor.FEET, pos.m_82549_(direction.m_82490_(200.0)));
        level.m_7967_((Entity)maledictus);
        float cutsceneStartRadius = 50.0f;
        List<ServerPlayer> affected = CatCutUtil.startCutsceneForPlayers((ServerLevel)level, pos, cutsceneStartRadius, 200, MaledictusCutsceneEntity.createCutsceneData(pos, direction));
        List<ServerPlayer> inSurvival = affected.stream().filter(player -> !player.m_7500_() && !player.m_5833_()).toList();
        for (int i = 0; i < inSurvival.size(); ++i) {
            int foffset = i / 4;
            int soffset = i % 4;
            int md = soffset % 2 == 0 ? 1 : -1;
            Vec3 offs = direction.m_82490_((double)(30 + foffset)).m_82549_(direction.m_82524_(1.5707964f).m_82490_((double)((soffset + 3) / 2 * md)));
            Vec3 tppos = pos.m_82549_(offs);
            ServerPlayer serverPlayer = inSurvival.get(i);
            serverPlayer.m_6021_(tppos.f_82479_, tppos.f_82480_, tppos.f_82481_);
            serverPlayer.m_7618_(EntityAnchorArgument.Anchor.FEET, pos);
        }
        for (int x = -5; x <= 5; ++x) {
            for (int y = -5; y <= 5; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    BlockPos p = homeAndTombstonePos.m_7918_(x, 18 + y, z);
                    if (!level.m_8055_(p).m_60713_((Block)ModBlocks.POINTED_ICICLE.get())) continue;
                    level.m_46961_(p, false);
                }
            }
        }
        return maledictus;
    }

    private static CutsceneData createCutsceneData(Vec3 pos, Vec3 direction) {
        Vec3 initPos = pos.m_82520_(0.0, 18.0, 0.0).m_82549_(direction.m_82490_(3.0));
        CutsceneData cutsceneData = CutsceneData.create();
        cutsceneData.addScreenEffect(0, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 0, 0, 10);
        cutsceneData.addCameraPos(new CameraPos(initPos, direction.m_82548_()));
        CameraPos lastCamera = new CameraPos(initPos.m_82549_(direction.m_82490_(5.0)), direction.m_82548_());
        cutsceneData.addCameraPos(lastCamera);
        cutsceneData.timeEasing(EasingType.EASE_IN_OUT);
        cutsceneData.time(30);
        Vec3 lookAtBoss1Dir = direction.m_82548_().m_82520_(0.0, -0.5, 0.0);
        CutsceneData cutsceneData1 = CutsceneData.create();
        Vec3 moveToPos1 = lastCamera.getPos().m_82549_(direction.m_82490_(15.0)).m_82520_(0.0, -17.0, 0.0);
        cutsceneData1.addCameraPos(lastCamera);
        cutsceneData1.addCameraPos(new CameraPos(moveToPos1, direction.m_82548_().m_82520_(0.0, 2.0, 0.0)));
        lastCamera = new CameraPos(moveToPos1.m_82549_(direction), lookAtBoss1Dir);
        cutsceneData1.addCameraPos(lastCamera);
        cutsceneData1.timeEasing(EasingType.EASE_IN_OUT);
        cutsceneData1.lookEasing(EasingType.EASE_IN_OUT);
        cutsceneData1.time(35);
        CutsceneData cutsceneData2 = CutsceneData.create().addCameraPos(lastCamera).time(4);
        CutsceneData cutsceneData3 = CutsceneData.create();
        cutsceneData3.addCameraPos(lastCamera);
        lastCamera = new CameraPos(lastCamera.getPos().m_82549_(lookAtBoss1Dir.m_82548_().m_82490_(2.0)), lookAtBoss1Dir);
        cutsceneData3.addCameraPos(lastCamera);
        cutsceneData3.time(5);
        cutsceneData3.timeEasing(EasingType.EASE_OUT);
        CutsceneData cutsceneData4 = CutsceneData.create().addCameraPos(lastCamera).time(22);
        CutsceneData cutsceneData5 = CutsceneData.create();
        cutsceneData5.addCameraPos(lastCamera);
        lastCamera = new CameraPos(lastCamera.getPos().m_82549_(lookAtBoss1Dir.m_82548_().m_82490_(2.0)), lookAtBoss1Dir);
        cutsceneData5.addCameraPos(lastCamera);
        cutsceneData5.time(5);
        cutsceneData5.timeEasing(EasingType.EASE_OUT);
        CutsceneData cutsceneData6 = CutsceneData.create().addCameraPos(lastCamera).time(20);
        CutsceneData cutsceneData7 = CutsceneData.create();
        cutsceneData7.addCameraPos(lastCamera);
        lastCamera = new CameraPos(lastCamera.getPos().m_82549_(lookAtBoss1Dir.m_82490_(6.0)), direction.m_82548_());
        cutsceneData7.addCameraPos(lastCamera);
        cutsceneData7.time(20);
        cutsceneData7.timeEasing(EasingType.EASE_IN_OUT);
        CutsceneData cutsceneData8 = CutsceneData.create().addCameraPos(lastCamera).time(20);
        cutsceneData8.addScreenEffect(0, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 20, 20, 20);
        cutsceneData.nextCutscene(cutsceneData1.nextCutscene(cutsceneData2.nextCutscene(cutsceneData3.nextCutscene(cutsceneData4.nextCutscene(cutsceneData5.nextCutscene(cutsceneData6.nextCutscene(cutsceneData7.nextCutscene(cutsceneData8))))))));
        return cutsceneData;
    }

    private static ProjectileMovementPath createMovementPath(Vec3 pos, Vec3 direction) {
        ProjectileMovementPath path = new ProjectileMovementPath(20, false);
        Vec3 initPos = pos.m_82520_(0.0, 16.0, 0.0);
        Vec3 hOffset = direction.m_82490_(20.0);
        Vec3 betweenPos = initPos.m_82549_(direction.m_82490_(12.0)).m_82520_(0.0, 5.0, 0.0);
        Vec3 endPos = pos.m_82549_(hOffset).m_82520_(0.0, -2.0, 0.0);
        path.addPos(initPos);
        path.addPos(betweenPos);
        path.addPos(endPos);
        return path;
    }

    public MaledictusCutsceneEntity(EntityType entity, Level world) {
        super(entity, world);
        this.m_20242_(true);
        this.f_19794_ = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.serverTick();
        } else {
            this.clientTick();
        }
        this.m_20242_(true);
        this.f_19794_ = true;
    }

    private void serverTick() {
        if (this.movementPath == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        int startFlyAfterTick = 31;
        int afterStartFlyTick = this.f_19797_ - startFlyAfterTick;
        if (afterStartFlyTick >= 0) {
            if (afterStartFlyTick >= 22 && afterStartFlyTick <= 25) {
                if (afterStartFlyTick == 22) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 2.0f, 0.75f + this.m_217043_().m_188501_() * 0.1f);
                }
                this.smashEffect(2.0f, afterStartFlyTick - 21, 2.5f);
            }
            if (afterStartFlyTick != 0) {
                if (afterStartFlyTick == 10) {
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.MALEDICTUS_BATTLE_CRY.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
                    this.setAttackState(19);
                } else if (afterStartFlyTick == 20) {
                    this.setAttackState(25);
                } else if (afterStartFlyTick == 100) {
                    this.setAttackState(0);
                } else if (afterStartFlyTick >= 140) {
                    Maledictus_Entity maledictus = (Maledictus_Entity)((EntityType)ModEntities.MALEDICTUS.get()).m_20615_(this.m_9236_());
                    maledictus.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    maledictus.setHomePos(this.getHomePos());
                    maledictus.setTombstonePos(this.getHomePos());
                    maledictus.setTombstoneDirection(this.getTombstoneDirection());
                    ResourceLocation dimLoc = this.m_9236_().m_46472_().m_135782_();
                    maledictus.setDimensionType(dimLoc.toString());
                    this.m_9236_().m_7967_((Entity)maledictus);
                    this.m_142467_(Entity.RemovalReason.DISCARDED);
                }
            }
        } else {
            if (this.f_19797_ == 30) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.MALEDICTUS_MACE_SWING.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
            }
            this.setAttackState(24);
        }
        Vec3 first = (Vec3)this.movementPath.getPositions().get(0);
        Vec3 last = (Vec3)this.movementPath.getPositions().get(this.movementPath.getPositions().size() - 1);
        Vec3 b = last.m_82546_(first).m_82542_(1.0, 0.0, 1.0);
        Vec3 lookAt = last.m_82549_(b.m_82490_(200.0));
        this.m_7618_(EntityAnchorArgument.Anchor.EYES, lookAt);
        if (this.f_19797_ > startFlyAfterTick) {
            this.movementPath.tick((Entity)this);
            if (this.movementPath.isFinished()) {
                if (!this.m_20184_().equals((Object)Vec3.f_82478_)) {
                    Vec3 lastPos = (Vec3)this.movementPath.getPositions().get(this.movementPath.getPositions().size() - 1);
                    this.m_6021_(lastPos.f_82479_, lastPos.f_82480_, lastPos.f_82481_);
                }
                this.m_20256_(Vec3.f_82478_);
            }
        }
    }

    private void clientTick() {
    }

    protected void m_8099_() {
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public void m_6457_(ServerPlayer player) {
    }

    public void m_6452_(ServerPlayer player) {
    }

    public void m_7334_(Entity entityIn) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    protected void m_6138_() {
    }

    public boolean m_6469_(DamageSource source, float damage) {
        return (source.m_276093_(DamageTypes.f_286979_) || source.m_276093_(DamageTypes.f_268724_)) && super.m_6469_(source, damage);
    }

    protected void m_6153_() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent m_5501_() {
        return null;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.autoLoad(compound);
    }

    protected void AfterDefeatBoss(@Nullable LivingEntity living) {
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.autoSave(compound);
    }

    protected void ReturnToHome() {
    }

    public void smashEffect(float spreadarc, int distance, float vec) {
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * (double)spreadarc;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance + (double)vec * Math.cos((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            double pz = this.m_20189_() + vz * (double)distance + (double)vec * Math.sin((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos pos = new BlockPos(hitX, hitY, hitZ);
            BlockState block = this.m_9236_().m_8055_(pos);
            int maxDepth = 30;
            for (int depthCount = 0; depthCount < maxDepth && block.m_60799_() != RenderShape.MODEL; ++depthCount) {
                pos = pos.m_7495_();
                block = this.m_9236_().m_8055_(pos);
            }
            if (block.m_60799_() != RenderShape.MODEL) {
                block = Blocks.f_50016_.m_49966_();
            }
            if (this.m_9236_().f_46443_) continue;
            Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.m_9236_(), (double)hitX + 0.5, (double)hitY + 1.0, (double)hitZ + 0.5, block, 10);
            fallingBlockEntity.m_5997_(0.0, 0.2 + this.m_217043_().m_188583_() * 0.15, 0.0);
            this.m_9236_().m_7967_((Entity)fallingBlockEntity);
        }
    }

    @Mod.EventBusSubscriber(modid="cinematiccataclysm", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void livingDestroyBlockEvent(LivingDestroyBlockEvent event) {
            if (event.getEntity() instanceof MaledictusCutsceneEntity) {
                event.setCanceled(true);
            }
        }
    }
}

