/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.cataclysm_custscenes.entities.leviathan;

import com.finderfeed.cataclysm_custscenes.CatCutUtil;
import com.finderfeed.cataclysm_custscenes.CataclysmCutscenes;
import com.finderfeed.fdlib.init.FDScreenEffects;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.systems.cutscenes.CameraPos;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneData;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectData;
import com.finderfeed.fdlib.systems.screen.screen_effect.instances.datas.ScreenColorData;
import com.finderfeed.fdlib.util.math.FDMathUtil;
import com.github.L_Ender.cataclysm.entity.AnimationMonster.BossMonsters.The_Leviathan.The_Leviathan_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.lionfishapi.server.animation.AnimationHandler;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class LeviathanCutsceneEntity
extends The_Leviathan_Entity
implements AutoSerializable {
    @SerializableField
    private Vec3 summonedPos;
    private BlockPos homepos;

    public static void summon(Level level, Vec3 pos, BlockPos homePos) {
        pos = pos.m_82520_(0.0, 4.0, 0.0);
        LeviathanCutsceneEntity leviathanCutsceneEntity = new LeviathanCutsceneEntity(CataclysmCutscenes.LEVIATHAN_CUTSCENE.get(), level);
        leviathanCutsceneEntity.summonedPos = pos;
        leviathanCutsceneEntity.homepos = homePos;
        leviathanCutsceneEntity.setHomePos(homePos);
        leviathanCutsceneEntity.setDimensionType(level.m_46472_().m_135782_().toString());
        Vec3 cutsceneEntityPos = leviathanCutsceneEntity.calculateSwimmingPos(0, 220);
        leviathanCutsceneEntity.m_146884_(cutsceneEntityPos);
        CutsceneData cutsceneData = LeviathanCutsceneEntity.cutsceneData(pos);
        List<ServerPlayer> affected = CatCutUtil.startCutsceneForPlayersCylinder((ServerLevel)level, pos.m_82520_(0.0, -10.0, 0.0), 30.0f, 60.0f, 170, cutsceneData);
        List<ServerPlayer> inSurvival = affected.stream().filter(player -> !player.m_7500_() && !player.m_5833_()).toList();
        for (int i = 0; i < inSurvival.size(); ++i) {
            float p = (float)i / (float)inSurvival.size();
            float angle = (float)Math.PI * 2 * p;
            Vec3 optimalPos = leviathanCutsceneEntity.findOptimalPlayerTpPos(pos, angle + 0.7853982f);
            ServerPlayer serverPlayer = inSurvival.get(i);
            serverPlayer.m_6021_(optimalPos.f_82479_, optimalPos.f_82480_, optimalPos.f_82481_);
            serverPlayer.m_7618_(EntityAnchorArgument.Anchor.FEET, pos);
        }
        level.m_7967_((Entity)leviathanCutsceneEntity);
    }

    private Vec3 findOptimalPlayerTpPos(Vec3 summonedPos, float angle) {
        Vec3 v = new Vec3(25.0, 0.0, 0.0).m_82524_(angle);
        for (int i = 0; i < 10; ++i) {
            Vec3 startCheck = summonedPos.m_82549_(v).m_82520_(0.0, (double)i, 0.0);
            Vec3 endCheck = startCheck.m_82520_(0.0, -40.0, 0.0);
            ClipContext clipContext = new ClipContext(startCheck, endCheck, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
            BlockHitResult result = this.m_9236_().m_45547_(clipContext);
            Vec3 location = result.m_82450_();
            if (!(location.m_82554_(startCheck) > 2.0)) continue;
            return location;
        }
        return summonedPos.m_82549_(v.m_82490_(0.5));
    }

    public static CutsceneData cutsceneData(Vec3 summonedPos) {
        CameraPos last = null;
        CutsceneData data = CutsceneData.create().addScreenEffect(0, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 0, 20, 10).addScreenEffect(30, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 10, 15, 10).addScreenEffect(60, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 10, 20, 10).addScreenEffect(100, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 20, 23, 3).time(140);
        int c = 12;
        for (int i = 0; i <= c; ++i) {
            float p = (float)i / (float)c;
            Vec3 lookAngle = new Vec3(1.0, 0.0, 0.0).m_82524_(p * (float)Math.PI * 2.0f);
            last = new CameraPos(summonedPos, lookAngle);
            data.addCameraPos(last);
        }
        CutsceneData data1 = CutsceneData.create().time(40).addScreenEffect(15, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 0, 30, 20).addCameraPos(last);
        return data.nextCutscene(data1);
    }

    public LeviathanCutsceneEntity(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public void m_8119_() {
        this.m_20242_(true);
        this.f_19794_ = true;
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.summonedPos == null || this.homepos == null) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            this.tickCutscene();
        }
    }

    private void tickCutscene() {
        int swimmingAroundTime = 140;
        int swimmingToCameraTime = 10;
        if (this.f_19797_ == swimmingAroundTime - 20) {
            AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, LEVIATHAN_GRAB);
        } else if (this.f_19797_ == swimmingAroundTime - 5) {
            this.m_9236_().m_6263_(null, this.summonedPos.f_82479_, this.summonedPos.f_82480_, this.summonedPos.f_82481_, (SoundEvent)ModSounds.LEVIATHAN_ROAR.get(), SoundSource.HOSTILE, 5.0f, 1.0f);
        }
        if (this.f_19797_ < swimmingAroundTime) {
            Vec3 currentSwimPos = this.calculateSwimmingPos(this.f_19797_, swimmingAroundTime);
            Vec3 nextSwimPos = this.calculateSwimmingPos(this.f_19797_ + 1, swimmingAroundTime);
            Vec3 deltaMovement = nextSwimPos.m_82546_(currentSwimPos);
            this.m_20256_(deltaMovement);
            this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.m_20182_().m_82549_(deltaMovement.m_82490_(100.0)));
        } else if (this.f_19797_ != swimmingAroundTime) {
            if (this.f_19797_ - swimmingAroundTime <= swimmingToCameraTime) {
                Vec3 currentSwimPos = this.calculateSwimmingPos(0, swimmingAroundTime);
                float p = (float)(this.f_19797_ - swimmingAroundTime) / (float)swimmingToCameraTime;
                float p2 = (float)(this.f_19797_ - swimmingAroundTime + 1) / (float)swimmingToCameraTime;
                Vec3 targetPos = FDMathUtil.interpolateVectors((Vec3)currentSwimPos, (Vec3)this.summonedPos, (float)(p * 0.9f));
                Vec3 targetPos2 = FDMathUtil.interpolateVectors((Vec3)currentSwimPos, (Vec3)this.summonedPos, (float)(p2 * 0.9f));
                Vec3 deltaMovement = targetPos2.m_82546_(targetPos);
                this.m_20256_(deltaMovement);
                this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.m_20182_().m_82549_(deltaMovement.m_82490_(100.0)));
            } else if (this.f_19797_ >= swimmingAroundTime + swimmingToCameraTime + 20) {
                this.removeAndSpawn();
            } else {
                this.m_20256_(Vec3.f_82478_);
            }
        }
        if (this.f_19797_ > 300) {
            this.removeAndSpawn();
        }
    }

    private void removeAndSpawn() {
        The_Leviathan_Entity leviathanEntity = (The_Leviathan_Entity)((EntityType)ModEntities.THE_LEVIATHAN.get()).m_20615_(this.m_9236_());
        leviathanEntity.setHomePos(this.homepos);
        leviathanEntity.m_146884_(this.summonedPos);
        leviathanEntity.setDimensionType(this.m_9236_().m_46472_().m_135782_().toString());
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        this.m_9236_().m_7967_((Entity)leviathanEntity);
    }

    private Vec3 calculateSwimmingPos(int swimmingTick, int fullSwimTime) {
        float currentAngle = (float)Math.PI * 2 * ((float)swimmingTick / (float)fullSwimTime);
        Vec3 currentPos = new Vec3(28.0, 0.0, 0.0).m_82524_(currentAngle);
        Vec3 pos = this.summonedPos.m_82549_(currentPos);
        return pos;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    protected void m_8099_() {
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_6457_(ServerPlayer player) {
    }

    public void m_6452_(ServerPlayer player) {
    }

    public void m_7334_(Entity entityIn) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    protected void m_6138_() {
    }

    public boolean m_6469_(DamageSource source, float damage) {
        return (source.m_276093_(DamageTypes.f_286979_) || source.m_276093_(DamageTypes.f_268724_)) && super.m_6469_(source, damage);
    }

    protected void m_6153_() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent m_5501_() {
        return null;
    }

    protected void ReturnToHome() {
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.autoLoad(compound);
        this.homepos = new BlockPos(compound.m_128451_("chomePosX"), compound.m_128451_("chomePosY"), compound.m_128451_("chomePosZ"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.autoSave(compound);
        compound.m_128405_("chomePosX", this.homepos.m_123341_());
        compound.m_128405_("chomePosY", this.homepos.m_123342_());
        compound.m_128405_("chomePosZ", this.homepos.m_123343_());
    }

    @Mod.EventBusSubscriber(modid="cinematiccataclysm")
    public static class Events {
        @SubscribeEvent
        public static void livingDestroyBlockEvent(LivingDestroyBlockEvent event) {
            if (event.getEntity() instanceof LeviathanCutsceneEntity) {
                event.setCanceled(true);
            }
        }
    }
}

