/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.cataclysm_custscenes.entities.ancient_remnant;

import com.finderfeed.cataclysm_custscenes.CatCutUtil;
import com.finderfeed.cataclysm_custscenes.CataclysmCutscenes;
import com.finderfeed.fdlib.init.FDScreenEffects;
import com.finderfeed.fdlib.nbt.AutoSerializable;
import com.finderfeed.fdlib.nbt.SerializableField;
import com.finderfeed.fdlib.network.FDPacketHandler;
import com.finderfeed.fdlib.systems.cutscenes.CameraPos;
import com.finderfeed.fdlib.systems.cutscenes.CutsceneData;
import com.finderfeed.fdlib.systems.cutscenes.EasingType;
import com.finderfeed.fdlib.systems.screen.screen_effect.ScreenEffectData;
import com.finderfeed.fdlib.systems.screen.screen_effect.instances.datas.ScreenColorData;
import com.finderfeed.fdlib.systems.shake.DefaultShakePacket;
import com.finderfeed.fdlib.systems.shake.FDShakeData;
import com.finderfeed.fdlib.util.FDTargetFinder;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters.Ancient_Remnant.Ancient_Remnant_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Ancient_Desert_Stele_Entity;
import com.github.L_Ender.cataclysm.init.ModEntities;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

public class AncientRemnantCutsceneEntity
extends Ancient_Remnant_Entity
implements AutoSerializable {
    @SerializableField
    private Vec3 cutsceneDirection;

    public static void summon(Level level, Vec3 pos, BlockPos homePos) {
        AncientRemnantCutsceneEntity cutsceneEntity = new AncientRemnantCutsceneEntity(CataclysmCutscenes.ANCIENT_REMNANT_CUTSCENE.get(), level);
        cutsceneEntity.setHomePos(homePos);
        cutsceneEntity.m_146884_(pos);
        cutsceneEntity.setAttackState(1);
        Vec3 cutsceneDirection = AncientRemnantCutsceneEntity.decideCutsceneDirection(level, pos.m_82520_(0.0, 2.0, 0.0));
        cutsceneEntity.m_7618_(EntityAnchorArgument.Anchor.FEET, pos.m_82549_(cutsceneDirection.m_82548_().m_82490_(100.0)));
        cutsceneEntity.cutsceneDirection = cutsceneDirection;
        CutsceneData cutscene = AncientRemnantCutsceneEntity.cutsceneData(pos, cutsceneDirection);
        List<ServerPlayer> affected = CatCutUtil.startCutsceneForPlayersCylinder((ServerLevel)level, pos.m_82520_(0.0, -10.0, 0.0).m_82549_(cutsceneDirection.m_82490_(30.0)), 40.0f, 35.0f, 200, cutscene);
        List<ServerPlayer> inSurvival = affected.stream().filter(player -> !player.m_7500_() && !player.m_5833_()).toList();
        for (int i = 0; i < inSurvival.size(); ++i) {
            int md = i % 2 == 0 ? 1 : -1;
            Vec3 v = pos.m_82520_(0.0, 10.0, 0.0).m_82549_(cutsceneDirection.m_82490_(30.0)).m_82549_(cutsceneDirection.m_82524_(1.5707964f).m_82490_((double)(md * ((i + 2) / 2))));
            ClipContext clipContext = new ClipContext(v, v.m_82520_(0.0, -50.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
            BlockHitResult result = level.m_45547_(clipContext);
            if (result.m_6662_() == HitResult.Type.MISS || !(result.m_82450_().m_82554_(v) > 1.0)) continue;
            ServerPlayer player2 = inSurvival.get(i);
            Vec3 loc = result.m_82450_();
            player2.m_6021_(loc.f_82479_, loc.f_82480_, loc.f_82481_);
            player2.m_7618_(EntityAnchorArgument.Anchor.FEET, pos);
        }
        level.m_7967_((Entity)cutsceneEntity);
    }

    public static CutsceneData cutsceneData(Vec3 pos, Vec3 cutsceneDirection) {
        CutsceneData data = CutsceneData.create().addScreenEffect(0, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 0, 0, 40).timeEasing(EasingType.EASE_IN_OUT).time(90);
        Vec3 initPos = pos.m_82549_(cutsceneDirection.m_82490_(5.0)).m_82520_(0.0, 3.0, 0.0);
        CameraPos lastPos = null;
        lastPos = new CameraPos(initPos.m_82549_(cutsceneDirection.m_82490_(5.0)).m_82520_(0.0, 2.0, 0.0), cutsceneDirection.m_82548_().m_82520_(0.0, -0.1, 0.0));
        data.addCameraPos(new CameraPos(initPos, cutsceneDirection.m_82548_().m_82520_(0.0, -0.5, 0.0))).addCameraPos(lastPos);
        CutsceneData data1 = CutsceneData.create().addScreenEffect(40, FDScreenEffects.SCREEN_COLOR, (ScreenEffectData)new ScreenColorData(0.0f, 0.0f, 0.0f, 1.0f), 30, 20, 20).timeEasing(EasingType.EASE_OUT).time(70).addCameraPos(lastPos).addCameraPos(new CameraPos(lastPos.getPos().m_82549_(cutsceneDirection.m_82490_(18.0)).m_82520_(0.0, -7.0, 0.0), cutsceneDirection.m_82548_().m_82520_(0.0, 0.5, 0.0)));
        data.nextCutscene(data1);
        return data;
    }

    public static Vec3 decideCutsceneDirection(Level level, Vec3 basePos) {
        Vec3 dir = null;
        double maxDist = -1.0;
        for (Direction d : Direction.Plane.HORIZONTAL) {
            Vec3 checkVec = new Vec3((double)d.m_122429_(), (double)d.m_122430_(), (double)d.m_122431_());
            Vec3 endVec = basePos.m_82549_(checkVec.m_82490_(100.0));
            ClipContext clipContext = new ClipContext(basePos, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
            BlockHitResult result = level.m_45547_(clipContext);
            Vec3 location = result.m_82450_();
            Vec3 between = location.m_82546_(basePos);
            double dist = between.m_82553_();
            if (!(dist > maxDist)) continue;
            maxDist = dist;
            dir = checkVec;
        }
        return dir;
    }

    public AncientRemnantCutsceneEntity(EntityType entity, Level world) {
        super(entity, world);
    }

    public void m_8119_() {
        this.f_19794_ = true;
        this.m_20242_(true);
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.cutsceneDirection == null) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            this.tickCutscene();
        }
    }

    private void tickCutscene() {
        if (this.f_19797_ >= 10) {
            this.m_21563_().m_24964_(this.m_20182_().m_82549_(this.cutsceneDirection.m_82490_(100.0)));
        }
        if (this.f_19797_ == 3) {
            this.setAttackState(2);
        } else if (this.f_19797_ == 75) {
            this.setAttackState(17);
            for (int forward = 0; forward < 30; ++forward) {
                for (int sideward = -10; sideward < 10; ++sideward) {
                    if (this.f_19796_.m_188501_() > 0.33f) continue;
                    Vec3 offsetPos = this.m_20182_().m_82520_(0.0, 2.0, 0.0).m_82549_(this.cutsceneDirection.m_82490_((double)forward)).m_82549_(this.cutsceneDirection.m_82524_(1.5707964f).m_82490_((double)sideward));
                    Vec3 endCheck = offsetPos.m_82520_(0.0, 40.0, 0.0);
                    ClipContext clipContext = new ClipContext(offsetPos, endCheck, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
                    BlockHitResult result = this.m_9236_().m_45547_(clipContext);
                    Vec3 location = result.m_82450_();
                    Vec3 between = endCheck.m_82546_(location);
                    double dist = between.m_82553_();
                    if (!(dist > 10.0)) continue;
                    Ancient_Desert_Stele_Entity ancientDesertSteleEntity = new Ancient_Desert_Stele_Entity(this.m_9236_(), location.f_82479_, location.f_82480_ - 2.0, location.f_82481_, 0.0f, forward + 25, 0.0f, (LivingEntity)this);
                    this.m_9236_().m_7967_((Entity)ancientDesertSteleEntity);
                }
            }
        } else if (this.f_19797_ == 95) {
            Vec3 shakeStart = this.m_20182_().m_82549_(this.cutsceneDirection.m_82490_(30.0)).m_82520_(0.0, -5.0, 0.0);
            for (ServerPlayer player : FDTargetFinder.getEntitiesInCylinder(ServerPlayer.class, (Level)this.m_9236_(), (Vec3)shakeStart, (float)30.0f, (float)40.0f)) {
                FDPacketHandler.INSTANCE.sendTo((Object)new DefaultShakePacket(FDShakeData.builder().amplitude(1.0f).outTime(60).build()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
        if (this.f_19797_ >= 180) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            Ancient_Remnant_Entity ancientRemnantEntity = (Ancient_Remnant_Entity)((EntityType)ModEntities.ANCIENT_REMNANT.get()).m_20615_(this.m_9236_());
            ancientRemnantEntity.setHomePos(this.getHomePos());
            ancientRemnantEntity.setDimensionType(this.m_9236_().m_46472_().m_135782_().toString());
            ancientRemnantEntity.m_146884_(this.m_20182_());
            ancientRemnantEntity.setNecklace(true);
            this.m_9236_().m_7967_((Entity)ancientRemnantEntity);
        }
    }

    public int m_21529_() {
        return 4;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    protected void m_8099_() {
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_6457_(ServerPlayer player) {
    }

    public void m_6452_(ServerPlayer player) {
    }

    public void m_7334_(Entity entityIn) {
    }

    public void m_5997_(double x, double y, double z) {
    }

    protected void m_6138_() {
    }

    public boolean m_6469_(DamageSource source, float damage) {
        return (source.m_276093_(DamageTypes.f_286979_) || source.m_276093_(DamageTypes.f_268724_)) && super.m_6469_(source, damage);
    }

    protected void m_6153_() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    protected SoundEvent m_5501_() {
        return null;
    }

    protected void ReturnToHome() {
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.autoLoad(compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.autoSave(compound);
    }

    @Mod.EventBusSubscriber(modid="cinematiccataclysm", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void livingDestroyBlockEvent(LivingDestroyBlockEvent event) {
            if (event.getEntity() instanceof AncientRemnantCutsceneEntity) {
                event.setCanceled(true);
            }
        }
    }
}

