/*
 * Decompiled with CFR 0.152.
 */
package com.finderfeed.cataclysm_custscenes;

import com.finderfeed.fdlib.util.FDTargetFinder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingBreatheEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cinematiccataclysm", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CatCutEvents {
    private static HashMap<ServerPlayer, Integer> PLAYER_INVULNERABILITY = new HashMap();

    @SubscribeEvent
    public static void serverTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            CatCutEvents.tickPlayerInvulnerability();
        }
    }

    private static void tickPlayerInvulnerability() {
        Iterator<Map.Entry<ServerPlayer, Integer>> iter = PLAYER_INVULNERABILITY.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<ServerPlayer, Integer> entry = iter.next();
            int value = entry.getValue();
            if (value <= 0) {
                iter.remove();
                continue;
            }
            entry.setValue(value - 1);
        }
    }

    public static boolean isPlayerInvulnerable(ServerPlayer player) {
        return PLAYER_INVULNERABILITY.containsKey(player);
    }

    public static void setPlayerInvulnerable(ServerPlayer serverPlayer, int duration) {
        PLAYER_INVULNERABILITY.put(serverPlayer, duration);
        for (Mob entity : FDTargetFinder.getEntitiesInSphere(Mob.class, (Level)serverPlayer.m_9236_(), (Vec3)serverPlayer.m_20182_(), (float)100.0f)) {
            if (entity.m_5448_() != serverPlayer) continue;
            entity.m_6710_(null);
        }
    }

    @SubscribeEvent
    public static void livingHurtEvent(LivingHurtEvent event) {
        ServerPlayer serverPlayer;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && CatCutEvents.isPlayerInvulnerable(serverPlayer = (ServerPlayer)livingEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void targetEvent(LivingChangeTargetEvent event) {
        ServerPlayer serverPlayer;
        LivingEntity livingEntity = event.getNewTarget();
        if (livingEntity instanceof ServerPlayer && CatCutEvents.isPlayerInvulnerable(serverPlayer = (ServerPlayer)livingEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void airEvent(LivingBreatheEvent event) {
        ServerPlayer serverPlayer;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && CatCutEvents.isPlayerInvulnerable(serverPlayer = (ServerPlayer)livingEntity)) {
            event.setConsumeAirAmount(0);
            serverPlayer.m_20301_(300);
        }
    }
}

