/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.mixinsquared.reflection;

import com.bawnorton.mixinsquared.reflection.FieldReference;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;

@ApiStatus.Internal
public final class TargetClassContextExtension {
    private final ITargetClassContext reference;
    private final FieldReference<SortedSet<?>> mixinsField;

    public TargetClassContextExtension(ITargetClassContext reference) {
        this.reference = reference;
        this.mixinsField = new FieldReference(reference.getClass(), "mixins");
    }

    public static void tryAs(ITargetClassContext reference, Consumer<TargetClassContextExtension> consumer) {
        if (reference.getClass().getName().equals("org.spongepowered.asm.mixin.transformer.TargetClassContext")) {
            consumer.accept(new TargetClassContextExtension(reference));
        }
    }

    public SortedSet<IMixinInfo> getMixins() {
        return this.mixinsField.get(this.reference);
    }
}

