/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.render;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.effects.Nullification;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MonochromePlayerLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final Map<ResourceLocation, ResourceLocation> cache = new ConcurrentHashMap<ResourceLocation, ResourceLocation>();
    private static final Map<ResourceLocation, CompletableFuture<ResourceLocation>> pendingRequests = new ConcurrentHashMap<ResourceLocation, CompletableFuture<ResourceLocation>>();

    public MonochromePlayerLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!player.m_20145_() && (Nullification.ClientEvent.ENTITY_EFFECT_STATUS.containsKey(player.m_19879_()) || player.m_21023_((MobEffect)MoreRelics.NULLIFICATION.get()))) {
            ResourceLocation graySkin = MonochromePlayerLayer.getGrayscaleSkin(player.m_108560_(), player.m_36316_()).getNow(player.m_108560_());
            ((PlayerModel)this.m_117386_()).m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)graySkin)), packedLight, LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static CompletableFuture<ResourceLocation> getGrayscaleSkin(ResourceLocation original, GameProfile profile) {
        if (cache.containsKey(original)) {
            return CompletableFuture.completedFuture(cache.get(original));
        }
        return pendingRequests.computeIfAbsent(original, loc -> {
            CompletableFuture<ResourceLocation> future = CompletableFuture.supplyAsync(() -> {
                NativeImage grayImg = null;
                try {
                    NativeImage baseImg = MonochromePlayerLayer.fetchNativeImage(original, profile);
                    grayImg = MonochromePlayerLayer.convertToGrayscale(baseImg);
                    baseImg.close();
                    return MonochromePlayerLayer.registerOnMainThread(original, grayImg);
                }
                catch (Exception e) {
                    return original;
                }
            });
            future.whenComplete((res, ex) -> Minecraft.m_91087_().execute(() -> pendingRequests.remove(original)));
            return future;
        });
    }

    private static NativeImage fetchNativeImage(ResourceLocation original, GameProfile profile) throws Exception {
        String url;
        Map textures = Minecraft.m_91087_().m_91109_().m_118815_(profile);
        if (textures.containsKey(MinecraftProfileTexture.Type.SKIN) && (url = ((MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN)).getUrl()) != null) {
            try (InputStream is = new URI(url).toURL().openStream();){
                BufferedImage bImg = ImageIO.read(is);
                NativeImage nativeImg = new NativeImage(bImg.getWidth(), bImg.getHeight(), false);
                for (int y = 0; y < bImg.getHeight(); ++y) {
                    for (int x = 0; x < bImg.getWidth(); ++x) {
                        nativeImg.m_84988_(x, y, bImg.getRGB(x, y));
                    }
                }
                NativeImage nativeImage = nativeImg;
                return nativeImage;
            }
        }
        return NativeImage.m_85058_((InputStream)((Resource)Minecraft.m_91087_().m_91098_().m_213713_(original).orElseThrow()).m_215507_());
    }

    private static NativeImage convertToGrayscale(NativeImage source) {
        NativeImage grayImg = new NativeImage(source.m_85102_(), source.m_84982_(), source.m_85084_(), false);
        for (int y = 0; y < source.m_85084_(); ++y) {
            for (int x = 0; x < source.m_84982_(); ++x) {
                int abgr = source.m_84985_(x, y);
                int a = abgr >> 24 & 0xFF;
                int b = abgr >> 16 & 0xFF;
                int g = abgr >> 8 & 0xFF;
                int r = abgr & 0xFF;
                int avg = (int)(0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b);
                avg = Math.min(255, avg + 40);
                int grayAbgr = a << 24 | avg << 16 | avg << 8 | avg;
                grayImg.m_84988_(x, y, grayAbgr);
            }
        }
        return grayImg;
    }

    private static ResourceLocation registerOnMainThread(ResourceLocation original, NativeImage grayImg) {
        Minecraft.m_91087_().execute(() -> {
            try {
                DynamicTexture dynamicTexture = new DynamicTexture(grayImg);
                String id = "morerelics_gray_" + original.m_135815_().replaceAll("[^a-zA-Z0-9/]", "_");
                ResourceLocation loc = Minecraft.m_91087_().m_91097_().m_118490_(id, dynamicTexture);
                cache.put(original, loc);
            }
            catch (Exception e) {
                grayImg.close();
            }
        });
        return original;
    }
}

