/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelics;
import com.blorb.morerelics.MoreRelicsUtil;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

@Mod.EventBusSubscriber
public class WonderOfU
extends MoreRelicBase {
    public static boolean inDamageReflect = false;

    public WonderOfU() {
        super(new Item.Properties().m_41497_(Rarity.EPIC).m_41487_(1));
    }

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"entropy").stat(StatData.builder((String)"perch").initialValue(7.0, 10.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(0).build()).ability(AbilityData.builder((String)"flow_of_calamity").stat(StatData.builder((String)"cooldown").initialValue(12.0, 8.0).upgradeModifier(UpgradeOperation.ADD, -1.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(5).requiredLevel(5).build()).ability(AbilityData.builder((String)"event_horizon").stat(StatData.builder((String)"duration").initialValue(10.0, 14.0).upgradeModifier(UpgradeOperation.ADD, 2.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).stat(StatData.builder((String)"cooldown").initialValue(540.0, 420.0).upgradeModifier(UpgradeOperation.ADD, -40.0).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(3).active(CastData.builder().type(CastType.INSTANTANEOUS).build()).requiredLevel(10).build()).build()).leveling(LevelingData.builder().maxLevel(13).initialCost(300).step(60).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity.m_9236_().f_46443_) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        int calamityCooldown = tag.m_128451_("morerelics_calamity_cooldown");
        if (calamityCooldown >= 1) {
            --calamityCooldown;
        }
        tag.m_128405_("morerelics_calamity_cooldown", calamityCooldown);
        MobEffectInstance nullEffect = livingEntity.m_21124_((MobEffect)MoreRelics.NULLIFICATION.get());
        if (nullEffect != null && nullEffect.m_19557_() == 1) {
            livingEntity.m_9236_().m_6263_(null, livingEntity.m_20182_().f_82479_, livingEntity.m_20182_().f_82480_, livingEntity.m_20182_().f_82481_, SoundEvents.f_11738_, SoundSource.MASTER, 1.0f, 0.5f);
        }
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        if (ability.equals("event_horizon")) {
            MobEffectInstance nullification = new MobEffectInstance((MobEffect)MoreRelics.NULLIFICATION.get(), (int)(this.getAbilityValue(stack, "event_horizon", "duration") * 20.0));
            player.m_7292_(nullification);
            player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_, player.m_20182_().f_82481_, (SoundEvent)MoreRelics.WONDER.get(), SoundSource.MASTER, 1.0f, 1.0f);
            this.horizonActivationBlast(player);
            this.setAbilityCooldown(stack, "event_horizon", (int)this.getAbilityValue(stack, "event_horizon", "cooldown") * 20);
        }
    }

    @Override
    public boolean canEquipMultipleCopies() {
        return false;
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        LivingEntity livingEntity = slotContext.entity();
        if (stack.m_41720_() != newStack.m_41720_() && livingEntity.m_21023_((MobEffect)MoreRelics.NULLIFICATION.get())) {
            livingEntity.m_21195_((MobEffect)MoreRelics.NULLIFICATION.get());
            livingEntity.m_9236_().m_6263_(null, livingEntity.m_20182_().f_82479_, livingEntity.m_20182_().f_82480_, livingEntity.m_20182_().f_82481_, SoundEvents.f_11738_, SoundSource.MASTER, 1.5f, 0.5f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void OnPlayerHurt(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        boolean entityHasNullification = livingEntity.m_21023_((MobEffect)MoreRelics.NULLIFICATION.get());
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity applier = (LivingEntity)entity;
            if (!applier.m_9236_().f_46443_ && livingEntity instanceof Player && (player = (Player)livingEntity) != applier) {
                int shouldApplyBadEffect;
                if (!inDamageReflect) {
                    inDamageReflect = true;
                    if (event.getAmount() < 0.5f) {
                        inDamageReflect = false;
                        return;
                    }
                    double reflectAmount = MoreRelicsUtil.actuallyGetEquippedRelics((LivingEntity)player).stream().mapToDouble(stack -> {
                        Item patt8273$temp = stack.m_41720_();
                        if (!(patt8273$temp instanceof WonderOfU)) {
                            return 0.0;
                        }
                        WonderOfU item = (WonderOfU)patt8273$temp;
                        if (!item.canUseAbility((ItemStack)stack, "entropy")) {
                            return 0.0;
                        }
                        item.spreadExperience((LivingEntity)player, (ItemStack)stack, 5);
                        return (double)event.getAmount() * (item.getAbilityValue((ItemStack)stack, "entropy", "perch") / 100.0);
                    }).sum();
                    if (reflectAmount > 0.0) {
                        if (entityHasNullification) {
                            reflectAmount *= 2.0;
                        }
                        reflectAmount = Math.max(0.0, Math.min(reflectAmount, (double)player.m_21223_()));
                        applier.m_6469_(new DamageSource(livingEntity.m_269291_().m_269374_((Entity)livingEntity).m_269150_(), (Entity)player, (Entity)player), (float)reflectAmount);
                    }
                    inDamageReflect = false;
                }
                if ((shouldApplyBadEffect = MoreRelicsUtil.actuallyGetEquippedRelics((LivingEntity)player).stream().mapToInt(stack -> {
                    Item patt9299$temp = stack.m_41720_();
                    if (!(patt9299$temp instanceof WonderOfU)) {
                        return 0;
                    }
                    WonderOfU item = (WonderOfU)patt9299$temp;
                    if (!item.canUseAbility((ItemStack)stack, "flow_of_calamity")) {
                        return 0;
                    }
                    CompoundTag tag = stack.m_41784_();
                    int calamityCooldown = tag.m_128451_("morerelics_calamity_cooldown");
                    if (calamityCooldown <= 0) {
                        tag.m_128405_("morerelics_calamity_cooldown", (int)(20.0 * item.getAbilityValue((ItemStack)stack, "flow_of_calamity", "cooldown")));
                        return 1;
                    }
                    return 0;
                }).sum()) >= 1) {
                    WonderOfU.applyCalamity(applier);
                    if (entityHasNullification) {
                        WonderOfU.applyCalamity(applier);
                    }
                }
            }
        }
        if (entityHasNullification) {
            event.setCanceled(true);
        }
    }

    private static void applyCalamity(LivingEntity target) {
        Map<MobEffect, Integer[]> calamityEffects = WonderOfU.getCalamityEffects();
        ArrayList<Map.Entry<MobEffect, Integer[]>> effectList = new ArrayList<Map.Entry<MobEffect, Integer[]>>(calamityEffects.entrySet());
        Collections.shuffle(effectList, new Random());
        for (Map.Entry entry : effectList) {
            MobEffect effectType = (MobEffect)entry.getKey();
            Integer[] data = (Integer[])entry.getValue();
            int duration = data[0];
            int amplifier = data[1];
            if (target.m_21023_(effectType)) continue;
            target.m_7292_(new MobEffectInstance(effectType, duration, amplifier));
            break;
        }
    }

    private void horizonActivationBlast(Player player) {
        Vec3 center = player.m_20182_();
        float radius = 4.0f;
        WonderOfU.spawnWonderExplosionParticles(player.m_9236_(), player.m_20182_(), radius);
        AABB area = new AABB(center.f_82479_ - (double)radius, center.f_82480_ - (double)radius, center.f_82481_ - (double)radius, center.f_82479_ + (double)radius, center.f_82480_ + (double)radius, center.f_82481_ + (double)radius);
        List detectedEntities = player.m_9236_().m_45933_((Entity)player, area);
        for (Entity detected : detectedEntities) {
            if (!(detected instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)detected;
            if (player == detected) continue;
            Vec3 direction = livingEntity.m_20182_().m_82546_(center).m_82541_();
            double pushStrength = Math.max(1.0, Math.min(3.0 / livingEntity.m_20182_().m_82554_(center), 2.0));
            MobEffectInstance stun = new MobEffectInstance((MobEffect)EffectRegistry.STUN.get(), 60);
            livingEntity.m_7292_(stun);
            livingEntity.m_20256_(livingEntity.m_20184_().m_82549_(direction.m_82490_(pushStrength)));
        }
    }

    private static Map<MobEffect, Integer[]> getCalamityEffects() {
        HashMap<MobEffect, Integer[]> effects = new HashMap<MobEffect, Integer[]>();
        effects.put(MobEffects.f_19597_, new Integer[]{100, 0});
        effects.put(MobEffects.f_19613_, new Integer[]{80, 0});
        effects.put(MobEffects.f_19610_, new Integer[]{40, 0});
        effects.put(MobEffects.f_216964_, new Integer[]{120, 0});
        effects.put(MobEffects.f_19612_, new Integer[]{200, 1});
        effects.put(MobEffects.f_19614_, new Integer[]{100, 1});
        effects.put(MobEffects.f_19615_, new Integer[]{80, 0});
        effects.put(MobEffects.f_19590_, new Integer[]{180, 9});
        effects.put((MobEffect)EffectRegistry.STUN.get(), new Integer[]{20, 0});
        effects.put((MobEffect)EffectRegistry.PARALYSIS.get(), new Integer[]{40, 0});
        effects.put((MobEffect)EffectRegistry.ANTI_HEAL.get(), new Integer[]{200, 0});
        effects.put((MobEffect)MoreRelics.CORROSION.get(), new Integer[]{80, 4});
        effects.put((MobEffect)MoreRelics.VULNERABILITY.get(), new Integer[]{240, 0});
        return effects;
    }

    public static void spawnWonderExplosionParticles(Level level, Vec3 position, float radius) {
        int particleCount = 240;
        ServerLevel sevLevel = (ServerLevel)level;
        List players = level.m_6907_();
        for (int i = 0; i < particleCount; ++i) {
            double theta = Math.random() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * Math.random() - 1.0);
            double r = Math.cbrt(Math.random()) * (double)radius;
            double x = position.f_82479_ + r * Math.sin(phi) * Math.cos(theta);
            double y = position.f_82480_ + r * Math.cos(phi);
            double z = position.f_82481_ + r * Math.sin(phi) * Math.sin(theta);
            for (ServerPlayer player : players) {
                sevLevel.m_8624_(player, (ParticleOptions)MoreRelics.WONDER_EXPLOSION.get(), true, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }
}

