/*
 * Decompiled with CFR 0.152.
 */
package com.blorb.morerelics.relics;

import com.blorb.morerelics.MoreRelicsUtil;
import com.blorb.morerelics.relics.MoreRelicBase;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WhimsOfFate
extends MoreRelicBase {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"just_one_more").stat(StatData.builder((String)"damage_reduction_per").initialValue(0.5, 1.0).upgradeModifier(UpgradeOperation.ADD, (double)0.1f).formatValue(value -> Float.valueOf((float)Math.round(value * 100.0) / 100.0f)).build()).maxLevel(8).requiredPoints(1).requiredLevel(0).build()).build()).leveling(LevelingData.builder().maxLevel(8).initialCost(100).step(25).build()).loot(LootData.builder().entry(LootCollections.DESERT).entry(LootCollections.BASTION).build()).build();
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        Player player;
        block14: {
            block13: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block13;
                player = (Player)livingEntity;
                if (!player.m_9236_().f_46443_) break block14;
            }
            return;
        }
        int highestRoll = 0;
        double highestReductionPer = 0.0;
        Random rand = new Random();
        for (ItemStack stack : MoreRelicsUtil.actuallyGetEquippedRelics((LivingEntity)player)) {
            double reductionPer;
            WhimsOfFate item;
            Item item2 = stack.m_41720_();
            if (!(item2 instanceof WhimsOfFate) || !(item = (WhimsOfFate)item2).canUseAbility(stack, "just_one_more")) continue;
            item.spreadExperience((LivingEntity)player, stack, 2);
            int diceRoll = rand.nextInt(20) + 1;
            if (diceRoll > highestRoll) {
                highestRoll = diceRoll;
            }
            CompoundTag tag = stack.m_41784_();
            tag.m_128405_("morerelics_last_roll", diceRoll);
            if (diceRoll == 20) {
                tag.m_128405_("morerelics_twenties_rolled", tag.m_128451_("morerelics_twenties_rolled") + 1);
            } else if (diceRoll == 1) {
                tag.m_128405_("morerelics_ones_rolled", tag.m_128451_("morerelics_ones_rolled") + 1);
            }
            if (!((reductionPer = item.getAbilityValue(stack, "just_one_more", "damage_reduction_per")) > highestReductionPer)) continue;
            highestReductionPer = reductionPer;
        }
        if (highestRoll == 0) {
            return;
        }
        if (highestRoll == 1) {
            message = Component.m_237115_((String)"action.morerelics.roll1").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000))).m_130940_(ChatFormatting.BOLD);
            player.m_5661_((Component)message, true);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12557_, SoundSource.MASTER, 0.3f, 0.6f);
            event.setAmount(event.getAmount() * 2.0f);
        } else if (highestRoll == 20) {
            message = Component.m_237115_((String)"action.morerelics.roll20").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)-16711936))).m_130940_(ChatFormatting.BOLD);
            player.m_5661_((Component)message, true);
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, SoundSource.MASTER, 0.3f, 1.2f);
            event.setCanceled(true);
        } else {
            event.setAmount((float)((double)event.getAmount() * (100.0 - (double)highestRoll * highestReductionPer) / 100.0));
        }
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128451_("morerelics_last_roll") != 0) {
            list.add((Component)Component.m_237110_((String)"tooltip.morerelics.last_roll", (Object[])new Object[]{tag.m_128451_("morerelics_last_roll")}).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        }
        if (tag.m_128451_("morerelics_twenties_rolled") != 0) {
            list.add((Component)Component.m_237110_((String)"tooltip.morerelics.20count", (Object[])new Object[]{tag.m_128451_("morerelics_twenties_rolled")}).m_130940_(ChatFormatting.GREEN).m_130940_(ChatFormatting.ITALIC));
        }
        if (tag.m_128451_("morerelics_ones_rolled") != 0) {
            list.add((Component)Component.m_237110_((String)"tooltip.morerelics.1count", (Object[])new Object[]{tag.m_128451_("morerelics_ones_rolled")}).m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        }
        return list;
    }
}

